/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.xml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.codehaus.plexus.util.xml.XMLWriter;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class SerializerXMLWriter
implements XMLWriter {
    private final XmlSerializer serializer;
    private final String namespace;
    private final Stack elements = new Stack();
    private List exceptions;
    private boolean documentStarted;
    private String encoding;

    public SerializerXMLWriter(String namespace, XmlSerializer serializer) {
        this.serializer = serializer;
        this.namespace = namespace;
    }

    public void startElement(String name) {
        try {
            if (!this.documentStarted) {
                this.documentStarted = true;
                this.serializer.startDocument(this.encoding, null);
            }
        }
        catch (IOException e) {
            this.storeException(e);
        }
        try {
            this.serializer.startTag(this.namespace, name);
            this.elements.push(name);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void setEncoding(String encoding) throws IllegalStateException {
        this.encoding = encoding;
    }

    public void setDocType(String docType) throws IllegalStateException {
        if (this.documentStarted) {
            throw new IllegalStateException("docType should be set before starting writing the document.");
        }
        try {
            this.documentStarted = true;
            this.serializer.startDocument(this.encoding, null);
            this.serializer.docdecl(docType);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void addAttribute(String key, String value) {
        try {
            this.serializer.attribute(this.namespace, key, value);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void writeText(String text) {
        try {
            this.serializer.text(text);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void writeMarkup(String text) {
        try {
            this.serializer.cdsect(text);
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    public void endElement() {
        try {
            this.serializer.endTag(this.namespace, (String)this.elements.pop());
        }
        catch (IOException e) {
            this.storeException(e);
        }
    }

    private void storeException(IOException e) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
        }
        this.exceptions.add(e);
    }

    public List getExceptions() {
        return this.exceptions == null ? Collections.EMPTY_LIST : this.exceptions;
    }
}

