/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.credentials;

import java.nio.charset.StandardCharsets;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.auth.credentials.CredentialsProvider;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.TlsContext;

public class EcsCredentialsProvider
extends CredentialsProvider {
    public static EcsCredentialsProvider create() {
        return EcsCredentialsProvider.builder().build();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    private static byte[] toByteArray(String string) {
        return string == null ? null : string.getBytes(StandardCharsets.UTF_8);
    }

    private static long toNativeHandle(CrtResource crtResource) {
        return crtResource == null ? 0L : crtResource.getNativeHandle();
    }

    private EcsCredentialsProvider(BuilderImpl builder) {
        try (ClientBootstrap bootstrap = builder.clientBootstrap == null ? new ClientBootstrap(null, null) : builder.clientBootstrap;){
            long nativeHandle = EcsCredentialsProvider.ecsCredentialsProviderNew(this, EcsCredentialsProvider.toNativeHandle(bootstrap), EcsCredentialsProvider.toNativeHandle(builder.tlsContext), EcsCredentialsProvider.toByteArray(builder.host), EcsCredentialsProvider.toByteArray(builder.pathAndQuery), EcsCredentialsProvider.toByteArray(builder.authToken));
            this.acquireNativeHandle(nativeHandle);
            this.addReferenceTo(bootstrap);
            if (builder.tlsContext != null) {
                this.addReferenceTo(builder.tlsContext);
            }
            if (builder.clientBootstrap != null) {
                bootstrap.addRef();
            }
        }
        catch (Exception e) {
            throw e;
        }
    }

    private static native long ecsCredentialsProviderNew(EcsCredentialsProvider var0, long var1, long var3, byte[] var5, byte[] var6, byte[] var7);

    static final class BuilderImpl
    implements Builder {
        private ClientBootstrap clientBootstrap;
        private TlsContext tlsContext;
        private String host;
        private String pathAndQuery;
        private String authToken;

        BuilderImpl() {
        }

        @Override
        public Builder withClientBootstrap(ClientBootstrap clientBootstrap) {
            this.clientBootstrap = clientBootstrap;
            return this;
        }

        @Override
        public Builder withTlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        @Override
        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        @Override
        public Builder withPathAndQuery(String pathAndQuery) {
            this.pathAndQuery = pathAndQuery;
            return this;
        }

        @Override
        public Builder withAuthToken(String authToken) {
            this.authToken = authToken;
            return this;
        }

        @Override
        public EcsCredentialsProvider build() {
            return new EcsCredentialsProvider(this);
        }
    }

    public static interface Builder {
        public Builder withClientBootstrap(ClientBootstrap var1);

        public Builder withTlsContext(TlsContext var1);

        public Builder withHost(String var1);

        public Builder withPathAndQuery(String var1);

        public Builder withAuthToken(String var1);

        public EcsCredentialsProvider build();
    }
}

