/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The inventory table configuration for an S3 Metadata configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryTableConfigurationResult implements SdkPojo, Serializable,
        ToCopyableBuilder<InventoryTableConfigurationResult.Builder, InventoryTableConfigurationResult> {
    private static final SdkField<String> CONFIGURATION_STATE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ConfigurationState")
            .getter(getter(InventoryTableConfigurationResult::configurationStateAsString))
            .setter(setter(Builder::configurationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationState")
                    .unmarshallLocationName("ConfigurationState").build(), RequiredTrait.create()).build();

    private static final SdkField<String> TABLE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TableStatus")
            .getter(getter(InventoryTableConfigurationResult::tableStatus))
            .setter(setter(Builder::tableStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableStatus")
                    .unmarshallLocationName("TableStatus").build()).build();

    private static final SdkField<ErrorDetails> ERROR_FIELD = SdkField
            .<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Error")
            .getter(getter(InventoryTableConfigurationResult::error))
            .setter(setter(Builder::error))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error")
                    .unmarshallLocationName("Error").build()).build();

    private static final SdkField<String> TABLE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TableName")
            .getter(getter(InventoryTableConfigurationResult::tableName))
            .setter(setter(Builder::tableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName")
                    .unmarshallLocationName("TableName").build()).build();

    private static final SdkField<String> TABLE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TableArn")
            .getter(getter(InventoryTableConfigurationResult::tableArn))
            .setter(setter(Builder::tableArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableArn")
                    .unmarshallLocationName("TableArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_STATE_FIELD,
            TABLE_STATUS_FIELD, ERROR_FIELD, TABLE_NAME_FIELD, TABLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String configurationState;

    private final String tableStatus;

    private final ErrorDetails error;

    private final String tableName;

    private final String tableArn;

    private InventoryTableConfigurationResult(BuilderImpl builder) {
        this.configurationState = builder.configurationState;
        this.tableStatus = builder.tableStatus;
        this.error = builder.error;
        this.tableName = builder.tableName;
        this.tableArn = builder.tableArn;
    }

    /**
     * <p>
     * The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return {@link InventoryConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The configuration state of the inventory table, indicating whether the inventory table is enabled or
     *         disabled.
     * @see InventoryConfigurationState
     */
    public final InventoryConfigurationState configurationState() {
        return InventoryConfigurationState.fromValue(configurationState);
    }

    /**
     * <p>
     * The configuration state of the inventory table, indicating whether the inventory table is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configurationState} will return {@link InventoryConfigurationState#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #configurationStateAsString}.
     * </p>
     * 
     * @return The configuration state of the inventory table, indicating whether the inventory table is enabled or
     *         disabled.
     * @see InventoryConfigurationState
     */
    public final String configurationStateAsString() {
        return configurationState;
    }

    /**
     * <p>
     * The status of the inventory table. The status values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The inventory table is in the process of being created in the specified Amazon Web
     * Services managed table bucket.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BACKFILLING</code> - The inventory table is in the process of being backfilled. When you enable the
     * inventory table for your metadata configuration, the table goes through a process known as backfilling, during
     * which Amazon S3 scans your general purpose bucket to retrieve the initial metadata for all objects in the bucket.
     * Depending on the number of objects in your bucket, this process can take several hours. When the backfilling
     * process is finished, the status of your inventory table changes from <code>BACKFILLING</code> to
     * <code>ACTIVE</code>. After backfilling is completed, updates to your objects are reflected in the inventory table
     * within one hour.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTIVE</code> - The inventory table has been created successfully, and records are being delivered to the
     * table.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Amazon S3 is unable to create the inventory table, or Amazon S3 is unable to deliver
     * records.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the inventory table. The status values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The inventory table is in the process of being created in the specified Amazon
     *         Web Services managed table bucket.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BACKFILLING</code> - The inventory table is in the process of being backfilled. When you enable the
     *         inventory table for your metadata configuration, the table goes through a process known as backfilling,
     *         during which Amazon S3 scans your general purpose bucket to retrieve the initial metadata for all objects
     *         in the bucket. Depending on the number of objects in your bucket, this process can take several hours.
     *         When the backfilling process is finished, the status of your inventory table changes from
     *         <code>BACKFILLING</code> to <code>ACTIVE</code>. After backfilling is completed, updates to your objects
     *         are reflected in the inventory table within one hour.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - The inventory table has been created successfully, and records are being delivered
     *         to the table.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Amazon S3 is unable to create the inventory table, or Amazon S3 is unable to
     *         deliver records.
     *         </p>
     *         </li>
     */
    public final String tableStatus() {
        return tableStatus;
    }

    /**
     * Returns the value of the Error property for this object.
     * 
     * @return The value of the Error property for this object.
     */
    public final ErrorDetails error() {
        return error;
    }

    /**
     * <p>
     * The name of the inventory table.
     * </p>
     * 
     * @return The name of the inventory table.
     */
    public final String tableName() {
        return tableName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the inventory table.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the inventory table.
     */
    public final String tableArn() {
        return tableArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(configurationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tableStatus());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(tableName());
        hashCode = 31 * hashCode + Objects.hashCode(tableArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryTableConfigurationResult)) {
            return false;
        }
        InventoryTableConfigurationResult other = (InventoryTableConfigurationResult) obj;
        return Objects.equals(configurationStateAsString(), other.configurationStateAsString())
                && Objects.equals(tableStatus(), other.tableStatus()) && Objects.equals(error(), other.error())
                && Objects.equals(tableName(), other.tableName()) && Objects.equals(tableArn(), other.tableArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InventoryTableConfigurationResult").add("ConfigurationState", configurationStateAsString())
                .add("TableStatus", tableStatus()).add("Error", error()).add("TableName", tableName())
                .add("TableArn", tableArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConfigurationState":
            return Optional.ofNullable(clazz.cast(configurationStateAsString()));
        case "TableStatus":
            return Optional.ofNullable(clazz.cast(tableStatus()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        case "TableName":
            return Optional.ofNullable(clazz.cast(tableName()));
        case "TableArn":
            return Optional.ofNullable(clazz.cast(tableArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ConfigurationState", CONFIGURATION_STATE_FIELD);
        map.put("TableStatus", TABLE_STATUS_FIELD);
        map.put("Error", ERROR_FIELD);
        map.put("TableName", TABLE_NAME_FIELD);
        map.put("TableArn", TABLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InventoryTableConfigurationResult, T> g) {
        return obj -> g.apply((InventoryTableConfigurationResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryTableConfigurationResult> {
        /**
         * <p>
         * The configuration state of the inventory table, indicating whether the inventory table is enabled or
         * disabled.
         * </p>
         * 
         * @param configurationState
         *        The configuration state of the inventory table, indicating whether the inventory table is enabled or
         *        disabled.
         * @see InventoryConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryConfigurationState
         */
        Builder configurationState(String configurationState);

        /**
         * <p>
         * The configuration state of the inventory table, indicating whether the inventory table is enabled or
         * disabled.
         * </p>
         * 
         * @param configurationState
         *        The configuration state of the inventory table, indicating whether the inventory table is enabled or
         *        disabled.
         * @see InventoryConfigurationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InventoryConfigurationState
         */
        Builder configurationState(InventoryConfigurationState configurationState);

        /**
         * <p>
         * The status of the inventory table. The status values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The inventory table is in the process of being created in the specified Amazon Web
         * Services managed table bucket.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BACKFILLING</code> - The inventory table is in the process of being backfilled. When you enable the
         * inventory table for your metadata configuration, the table goes through a process known as backfilling,
         * during which Amazon S3 scans your general purpose bucket to retrieve the initial metadata for all objects in
         * the bucket. Depending on the number of objects in your bucket, this process can take several hours. When the
         * backfilling process is finished, the status of your inventory table changes from <code>BACKFILLING</code> to
         * <code>ACTIVE</code>. After backfilling is completed, updates to your objects are reflected in the inventory
         * table within one hour.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTIVE</code> - The inventory table has been created successfully, and records are being delivered to
         * the table.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Amazon S3 is unable to create the inventory table, or Amazon S3 is unable to deliver
         * records.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tableStatus
         *        The status of the inventory table. The status values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The inventory table is in the process of being created in the specified Amazon
         *        Web Services managed table bucket.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BACKFILLING</code> - The inventory table is in the process of being backfilled. When you enable
         *        the inventory table for your metadata configuration, the table goes through a process known as
         *        backfilling, during which Amazon S3 scans your general purpose bucket to retrieve the initial metadata
         *        for all objects in the bucket. Depending on the number of objects in your bucket, this process can
         *        take several hours. When the backfilling process is finished, the status of your inventory table
         *        changes from <code>BACKFILLING</code> to <code>ACTIVE</code>. After backfilling is completed, updates
         *        to your objects are reflected in the inventory table within one hour.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - The inventory table has been created successfully, and records are being
         *        delivered to the table.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Amazon S3 is unable to create the inventory table, or Amazon S3 is unable to
         *        deliver records.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableStatus(String tableStatus);

        /**
         * Sets the value of the Error property for this object.
         *
         * @param error
         *        The new value for the Error property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetails error);

        /**
         * Sets the value of the Error property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #error(ErrorDetails)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetails)
         */
        default Builder error(Consumer<ErrorDetails.Builder> error) {
            return error(ErrorDetails.builder().applyMutation(error).build());
        }

        /**
         * <p>
         * The name of the inventory table.
         * </p>
         * 
         * @param tableName
         *        The name of the inventory table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableName(String tableName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for the inventory table.
         * </p>
         * 
         * @param tableArn
         *        The Amazon Resource Name (ARN) for the inventory table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableArn(String tableArn);
    }

    static final class BuilderImpl implements Builder {
        private String configurationState;

        private String tableStatus;

        private ErrorDetails error;

        private String tableName;

        private String tableArn;

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryTableConfigurationResult model) {
            configurationState(model.configurationState);
            tableStatus(model.tableStatus);
            error(model.error);
            tableName(model.tableName);
            tableArn(model.tableArn);
        }

        public final String getConfigurationState() {
            return configurationState;
        }

        public final void setConfigurationState(String configurationState) {
            this.configurationState = configurationState;
        }

        @Override
        public final Builder configurationState(String configurationState) {
            this.configurationState = configurationState;
            return this;
        }

        @Override
        public final Builder configurationState(InventoryConfigurationState configurationState) {
            this.configurationState(configurationState == null ? null : configurationState.toString());
            return this;
        }

        public final String getTableStatus() {
            return tableStatus;
        }

        public final void setTableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
        }

        @Override
        public final Builder tableStatus(String tableStatus) {
            this.tableStatus = tableStatus;
            return this;
        }

        public final ErrorDetails.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetails.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetails error) {
            this.error = error;
            return this;
        }

        public final String getTableName() {
            return tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getTableArn() {
            return tableArn;
        }

        public final void setTableArn(String tableArn) {
            this.tableArn = tableArn;
        }

        @Override
        public final Builder tableArn(String tableArn) {
            this.tableArn = tableArn;
            return this;
        }

        @Override
        public InventoryTableConfigurationResult build() {
            return new InventoryTableConfigurationResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
