/*
 * Decompiled with CFR 0.152.
 */
package co.kuali.financials.datatools.liquimongo;

import co.kuali.financials.datatools.liquimongo.service.DocumentStoreSchemaUpdateService;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DocumentStoreSchemaUpdater {
    private static final Logger LOG = Logger.getLogger(DocumentStoreSchemaUpdater.class);
    private static ClassPathXmlApplicationContext context;

    public static void main(String[] args) {
        BasicConfigurator.configure();
        if (args.length < 1) {
            LOG.error((Object)"You must provide a path to the migration files.");
        } else if (!args[0].endsWith(".json")) {
            LOG.error((Object)"Path needs to point to a json file.");
        } else {
            DocumentStoreSchemaUpdater.initializeSpring();
            DocumentStoreSchemaUpdater.start(args[0]);
        }
    }

    private static void start(String updateFilePath) {
        DocumentStoreSchemaUpdateService service = (DocumentStoreSchemaUpdateService)context.getBean(DocumentStoreSchemaUpdateService.class);
        service.updateDocumentStoreSchemaForLocation(updateFilePath);
    }

    public static void initializeSpring() {
        long startInit = System.currentTimeMillis();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Initializing Spring Context...");
        }
        context = new ClassPathXmlApplicationContext(new String[]{"co/kuali/financials/datatools/liquimongo/spring-liquimongo-bootstrap.xml", "co/kuali/financials/datatools/liquimongo/spring-liquimongo.xml"});
        context.start();
        if (LOG.isInfoEnabled()) {
            long endInit = System.currentTimeMillis();
            LOG.info((Object)("...Spring Context successfully initialized, startup took " + (endInit - startInit) + " ms."));
        }
    }
}

