<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2026 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="permissionAttributes" value="${DataDictionary.Permission.attributes}" />

<kul:tab tabTitle="Permissions" defaultOpen="true" tabErrorKey="document.perm*">
	<div class="tab-container" align="center">
    <table class="standard side-margins">
          <c:if test="${!readOnly}">
             <tr>
				<td align="center">
	                <div align="center">
	                	<br/>
						<b>Add Permission ID:</b>
                        <kul:htmlControlAttribute property="permission.permissionId" attributeEntry="${permissionAttributes.id}"/>
	                	<kul:lookup boClassName="org.kuali.kfs.kim.impl.permission.Permission" fieldConversions=
	                	"id:permission.permissionId,template.name:permission.permission.template.name,name:permission.permission.name,namespaceCode:permission.permission.namespaceCode" anchor="${tabKey}" />
						<html:hidden property="permission.name" />
						<html:hidden property="permission.namespaceCode" />
						${KualiForm.permission.namespaceCode}&nbsp;&nbsp;${KualiForm.permission.name}&nbsp;
	                	<br/>
	                	<br/>
		            </div>
				</td>
			</tr>
			<tr>
                <td class="infoline">
					<div align="center">
						<html:submit property="methodToCall.addPermission.anchor${tabKey}"
							styleClass="btn btn-green" value="Add"/>
					</div>
                </td>
	       </tr>
     </c:if>
	</table>
	<table class="standard side-margins">
        	<tr>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.namespaceCode}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.id}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.name}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.detailObjectsValues}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${permissionAttributes.active}" noColon="true" /></div></th>
				<c:if test="${!readOnly}">
            		<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
				</c:if>
        	</tr>
      	<c:forEach var="permission" items="${KualiForm.document.permissions}" varStatus="status">
            <tr>
				<%--<th class="infoline">--%>
					<%--<c:out value="${status.index+1}" />--%>
				<%--</th>--%>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.permissions[${status.index}].permission.namespaceCode"  attributeEntry="${permissionAttributes.namespaceCode}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.permissions[${status.index}].permissionId"  attributeEntry="${permissionAttributes.id}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.permissions[${status.index}].permission.name"  attributeEntry="${permissionAttributes.name}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	              	<div align="left"> <kul:htmlControlAttribute property="document.permissions[${status.index}].permissionDetailValues"  attributeEntry="${permissionAttributes.detailObjectsValues}" readOnly="true"  />
					</div>
				</td>
				<c:choose>
					<c:when test="${permission.edit && !readOnly}">
			            <td align="center" valign="middle">
			               	<div align="center"> <kul:htmlControlAttribute property="document.permissions[${status.index}].active"  attributeEntry="${permissionAttributes.active}" />
							</div>
						</td>
					</c:when>
       	       		<c:otherwise>
			            <td align="center" valign="middle">
			               	<div align="center"> <kul:htmlControlAttribute property="document.permissions[${status.index}].active"  attributeEntry="${permissionAttributes.active}" readOnly="true"  />
							</div>
						</td>
        	       	</c:otherwise>
       	     	</c:choose>
			<c:if test="${!readOnly}">
				<td>
					<div align="center">&nbsp;
						<c:choose>
							<c:when test="${permission.edit}">
								<button class="btn btn-red" disabled>Delete</button>
							</c:when>
	        	       		<c:otherwise>
	        	        		<html:submit property='methodToCall.deletePermission.line${status.index}.anchor${currentTabIndex}'
								value="Delete" styleClass='btn btn-red'/>
		        	       	</c:otherwise>
	        	     	</c:choose>
					</div>
				</td>
			</c:if>
			</tr>
		</c:forEach>
	</table>
	</div>
</kul:tab>
