<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2026 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="responsibilityAttributes" value="${DataDictionary.Responsibility.attributes}" />

<kul:tab tabTitle="Responsibilities" defaultOpen="true" tabErrorKey="document.resp*">
	<div class="tab-container" align="center">

    <table class="standard side-margins">
          <c:if test="${!readOnly}">

             <tr>
				<td align="center">
	                <div align="center">
	                	<br/>
						<b>Add Responsibility ID:</b>
						<kul:htmlControlAttribute property="responsibility.responsibilityId" attributeEntry="${responsibilityAttributes.id}"/>
	                	<kul:lookup boClassName="org.kuali.kfs.kim.impl.responsibility.Responsibility" fieldConversions=
	                	"id:responsibility.responsibilityId,template.name:responsibility.kimResponsibility.template.name,name:responsibility.kimResponsibility.name,namespaceCode:responsibility.kimResponsibility.namespaceCode" anchor="${tabKey}" />
						<html:hidden property="responsibility.name" />
						<html:hidden property="responsibility.namespaceCode" />
						${KualiForm.responsibility.namespaceCode}&nbsp;&nbsp;${KualiForm.responsibility.name}&nbsp;
	                	<br/>
	                	<br/>
		            </div>
				</td>
			</tr>
			<tr>
                <td class="infoline">
					<div align="center">
						<html:submit property="methodToCall.addResponsibility.anchor${tabKey}"
							styleClass="btn btn-green" value="Add"/>
					</div>
                </td>
	       </tr>
     </c:if>
	</table>
	<table class="standard side-margins">
        	<tr>
        		<%--<th>&nbsp;</th> --%>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.namespaceCode}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.id}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.name}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.detailObjectsValues}" noColon="true" /></div></th>
        		<th><div align="left"><kul:htmlAttributeLabel attributeEntry="${responsibilityAttributes.active}" noColon="true" /></div></th>
				<c:if test="${!readOnly}">
            		<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
				</c:if>
        	</tr>
      	<c:forEach var="responsibility" items="${KualiForm.document.responsibilities}" varStatus="status">
       	    <c:set var="rows" value="1"/>
       		<c:if test="${responsibility.roleRspAction.roleResponsibilityId!=null}">
        	       <c:set var="rows" value="2"/>
       		</c:if>
            <tr>
				<%--<th rowspan="${rows}" class="infoline" valign="top">--%>
					<%--<c:out value="${status.index+1}" />--%>
				<%--</th>--%>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].kimResponsibility.namespaceCode"  attributeEntry="${responsibilityAttributes.namespaceCode}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].responsibilityId"  attributeEntry="${responsibilityAttributes.id}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].kimResponsibility.name"  attributeEntry="${responsibilityAttributes.name}" readOnly="true"  />
					</div>
				</td>
	            <td align="left" valign="middle">
	               	<div align="left">  <kul:htmlControlAttribute property="document.responsibilities[${status.index}].kimResponsibility.detailObjectsToDisplay"  attributeEntry="${responsibilityAttributes.detailObjectsToDisplay}" readOnly="true"  />
					</div>
				</td>
				<c:choose>
					<c:when test="${responsibility.edit && !readOnly}">
			            <td align="center" valign="middle">
			               	<div align="center"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].active"  attributeEntry="${responsibilityAttributes.active}" />
							</div>
						</td>
					</c:when>
       	       		<c:otherwise>
			            <td align="center" valign="middle">
			               	<div align="center"> <kul:htmlControlAttribute property="document.responsibilities[${status.index}].active"  attributeEntry="${responsibilityAttributes.active}" readOnly="true"  />
							</div>
						</td>
        	       	</c:otherwise>
       	     	</c:choose>
			<c:if test="${!readOnly}">
				<td>
					<div align=center>&nbsp;
						<c:choose>
							<c:when test="${responsibility.edit}">
								<button class="btn btn-red" disabled>Delete</button>
							</c:when>
	        	       		<c:otherwise>
	        	        		<html:submit property='methodToCall.deleteResponsibility.line${status.index}.anchor${currentTabIndex}'
								styleClass='btn btn-red' value="Delete"/>
		        	       	</c:otherwise>
	        	     	</c:choose>
					</div>
				</td>
			</c:if>
			</tr>
	        <c:if test="${responsibility.roleRspAction != null}">
    			<tr>
	              <td colspan="7" style="padding:0px;">
	              	<kim:responsibilityAction responsibilityIdx="${status.index}" />
		          </td>
		        </tr>
			</c:if>
		</c:forEach>
	</table>
	</div>
</kul:tab>
