<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2026 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="personAttributes" value="${DataDictionary.Person.attributes}"/>

<kul:subtab width="${tableWidth}" subTabTitle="Affiliation" noShowHideButton="true">
    <table class="standard side-margins">
        <tr>
            <th>
                <div align="left">&nbsp;</div>
            </th>
            <kim:cell isLabel="true" textAlign="center"
                      attributeEntry="${personAttributes.affiliationTypeCode}" noColon="true"/>
            <kim:cell isLabel="true" textAlign="center"
                      attributeEntry="${personAttributes.campusCode}" noColon="true"/>
        </tr>
        <tr>
            <th rowspan="1" class="infoline"/>
            <kim:cell valign="middle" cellClass="infoline" textAlign="center"
                      property="document.affiliationTypeCode"
                      attributeEntry="${personAttributes.affiliationTypeCode}"
                      readOnly="${readOnlyEntity}"/>
            <kim:cell valign="middle" cellClass="infoline" textAlign="center"
                      property="document.campusCode"
                      attributeEntry="${personAttributes.campusCode}" readOnly="${readOnlyEntity}"/>
        </tr>
    </table>
</kul:subtab>
