<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2026 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="groupMemberAttributes" value="${DataDictionary.GroupDocumentMember.attributes}"/>
<c:set var="groupQualifierAttributes" value="${DataDictionary.GroupDocumentQualifier.attributes}"/>
<c:set var="kimAttributes" value="${DataDictionary.KimAttributeImpl.attributes}"/>

<c:if test="${!empty KualiForm.document.kimType.attributeDefinitions}">
  <kul:tab tabTitle="Attributes" defaultOpen="true" tabErrorKey="document.qualifier*">
    <div class="tab-container" align="center">
      <table cellpadding="0" cellspacing="0" summary="" class="datatable standard old-new">
        <tr class="header">
          <c:forEach var="attrDefn" items="${KualiForm.document.kimType.attributeDefinitions}" varStatus="status">
            <c:set var="fieldName" value="${attrDefn.kimAttribute.attributeName}"/>
            <c:set var="attrEntry" value="${KualiForm.document.attributeEntry[fieldName]}"/>
            <kul:htmlAttributeHeaderCell attributeEntry="${attrEntry}" useShortLabel="false" horizontal="false"/>
          </c:forEach>
        </tr>
        <tr>
          <c:forEach var="qualifier" items="${KualiForm.document.kimType.attributeDefinitions}"
                     varStatus="statusQualifier">
            <c:set var="fieldName" value="${qualifier.kimAttribute.attributeName}"/>
            <c:set var="attrEntry" value="${KualiForm.document.attributeEntry[fieldName]}"/>
            <c:set var="attrDefinition" value="${KualiForm.document.definitionsKeyedByAttributeName[fieldName]}"/>
            <c:set var="attrReadOnly" value="${(readOnly || !(attrDefinition.unique && KualiForm.document.editing))}"/>
            <td align="left" valign="middle">
              <div align="center">
                <c:if test="${not empty KualiForm.document.qualifiers[statusQualifier.index]}">
                  <kul:htmlControlAttribute property="document.qualifiers[${statusQualifier.index}].attrVal"
                                            attributeEntry="${attrEntry}" readOnly="${attrReadOnly}"/>
                </c:if>
                <c:if test="${attrDefinition.quickFinder != null}">
                    <c:if test="${!empty attrDefinition.quickFinder.dataObjectClass and not attrReadOnly}">
                      <kim:attributeLookup attributeDefinitions="${KualiForm.document.definitions}"
                                           pathPrefix="document" attr="${attrDefinition.quickFinder}"/>
                    </c:if>
                </c:if>
              </div>
            </td>
          </c:forEach>
        </tr>
      </table>
    </div>
  </kul:tab>
</c:if>
