<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2025 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ attribute name="attributeDefinitions" required="true" type="java.util.List"
              description="The list of KIM Attribute Fields." %>
<%@ attribute name="pathPrefix" required="true"
              description="The prefix of values that are returned.  For instance, if the pathPrefix is document and the lookup is on organizationCode, the lookup will populate document.organizationCode in the form." %>
<%@ attribute name="attr" required="true" type="org.kuali.kfs.kim.api.type.QuickFinder"
              description="The data dictionary definition of the attribute this lookup will help populate." %>
<%--  handling multiple lookup --%>
<c:set var="fieldConversion" value=""/>
<c:set var="params" value=""/>

<c:forEach var="attrDefn" items="${attributeDefinitions}" varStatus="defidx">
  <c:set var="searchStr" value="${attrDefn.attributeField.name}"/>
  <c:forEach items="${attr.fieldConversions}" var="lookupReturn" varStatus="lookupIdx">
    <c:if test="${lookupReturn.key == searchStr}">
      <c:set var="fieldConversion"
             value="${fieldConversion},${searchStr}:${pathPrefix}.qualifiers[${defidx.index}].attrVal"/>
    </c:if>
    <c:if test="${lookupReturn.key != searchStr and lookupReturn.value == searchStr}">
      <c:set var="fieldConversion"
             value="${fieldConversion},${lookupReturn.key}:${pathPrefix}.qualifiers[${defidx.index}].attrVal"/>
    </c:if>
  </c:forEach>

  <c:forEach items="${attr.lookupParameters}" var="lookupInput" varStatus="lookupIdx">
    <c:if test="${lookupInput.key == searchStr}">
      <%-- TODO : replace searstr with fielname for testing --%>

      <c:set var="params" value="${params},${pathPrefix}.qualifiers[${defidx.index}].attrVal:${lookupInput.value}"/>

    </c:if>
  </c:forEach>
</c:forEach>

<c:set var="fieldConversion" value="${fn:substringAfter(fieldConversion, ',')}"/>
<c:set var="params" value="${fn:substringAfter(params, ',')}"/>
  <kul:lookup boClassName="${attr.dataObjectClass}"
              fieldConversions="${fieldConversion}"
              lookupParameters="${params}"
              baseLookupUrl="${attr.baseLookupUrl}"/>
