<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2025 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<kul:page
    headerTitle="Document Type Hierarchy"
    transactionalDocument="false"
    showDocumentInfo="false"
    htmlFormAction="RuleQuickLinks"
    docTitle="Document Type Hierarchy"
>
    <c:if test="${!empty KualiForm.documentTypeQuickLinksStructures}">
        <c:forEach var="documentTypeStruct" items="${KualiForm.documentTypeQuickLinksStructures}" varStatus="docStatus">
            <c:if test="${documentTypeStruct.shouldDisplay}">
                <c:set var="documentType" value="${documentTypeStruct.documentType}" />
                <c:choose>
                    <c:when test="${docStatus.count == 1}">
                        <kul:tabTop
                            tabTitle="${documentType.label}"
                            defaultOpen="${renderOpened}"
                            boClassName="org.kuali.kfs.kew.doctype.bo.DocumentType"
                            keyValues="documentTypeId=${documentType.documentTypeId}"
                        >
                            <div class="tab-container" style="width:auto;">
                                <c:set var="documentTypeStruct" value="${documentTypeStruct}" scope="request"/>
                                <c:set var="excludeDocId" value="${documentType.documentTypeId}" scope="request" />
                                <c:import url="RuleQuickLinksDocumentTypeLinks.jsp" />
                            </div>
                        </kul:tabTop>
                    </c:when>
                    <c:otherwise>
                        <kul:tab
                            tabTitle="${documentType.label}"
                            defaultOpen="false"
                            boClassName="org.kuali.kfs.kew.doctype.bo.DocumentType"
                            keyValues="documentTypeId=${documentType.documentTypeId}"
                        >
                            <div class="tab-container" style="width:auto;">
                                <c:set var="documentTypeStruct" value="${documentTypeStruct}" scope="request"/>
                                <c:set var="excludeDocId" value="${documentType.documentTypeId}" scope="request" />
                                <c:import url="RuleQuickLinksDocumentTypeLinks.jsp" />
                            </div>
                        </kul:tab>
                    </c:otherwise>
                </c:choose>
            </c:if>
        </c:forEach>
        <kul:panelFooter />
    </c:if>
    <c:if test="${empty KualiForm.documentTypeQuickLinksStructures}">
        No Documents Match
    </c:if>
</kul:page>

<script type="application/javascript">
    // This is written for RuleQuickLinksDocumentTypeLinks.jsp but if it's included there it will be included multiple times
    function handleValueClick (documentTypeName) {
        document.getElementById('document-dropdown-' + documentTypeName).classList.toggle('show');
    }

    window.onclick = function(event) {
        if (!event.target.matches('.document-edit-view')) {
            var dropdowns = document.getElementsByClassName('document-edit-menu');
            var i;
            for (i = 0; i < dropdowns.length; i++) {
                var openDropdown = dropdowns[i];
                if (openDropdown.classList.contains('show')) {
                    openDropdown.classList.remove('show');
                }
            }
        }
    }
</script>
