/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.itextpdf.kernel.Version;
import com.itextpdf.kernel.counter.DataHandlerCounter;
import com.itextpdf.kernel.counter.EventCounter;
import com.itextpdf.kernel.counter.EventCounterHandler;
import com.itextpdf.kernel.counter.IEventCounterFactory;
import com.itextpdf.kernel.counter.SimpleEventCounterFactory;
import com.itextpdf.kernel.counter.context.UnknownContext;
import com.itextpdf.kernel.counter.data.EventDataCacheComparatorBased;
import com.itextpdf.kernel.counter.data.EventDataHandler;
import com.itextpdf.kernel.counter.data.EventDataHandlerUtil;
import com.itextpdf.kernel.counter.data.IEventDataCache;
import com.itextpdf.licensekey.LicenseKey;
import com.itextpdf.licensekey.PortingUtils;
import com.itextpdf.licensekey.VolumeDataHandler;
import com.itextpdf.licensekey.kinesis.IKinesisClientProvider;
import com.itextpdf.licensekey.kinesis.RotationKinesisClientProvider;
import com.itextpdf.licensekey.kinesis.StaticKinesisClientProvider;
import com.itextpdf.licensekey.kinesis.WrapperKinesisClientProvider;
import com.itextpdf.licensekey.volume.VolumeData;
import com.itextpdf.licensekey.volume.VolumeDataFactory;
import com.itextpdf.licensekey.volume.VolumeDataSignature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

final class VolumeCounterLoader {
    private static final Object syncLock = new Object();
    private static volatile VolumeCounter counter;

    private VolumeCounterLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update() {
        block10: {
            VolumeCounter local = counter;
            try {
                String iTextVersion = Version.getInstance().getRelease();
                String systemInfo = PortingUtils.getSystemInfo();
                String[] licenseInfo = LicenseKey.getLicenseeInfoForVersion((String)iTextVersion);
                String key = licenseInfo[3];
                String type = licenseInfo[8];
                String access = licenseInfo[9];
                String secret = licenseInfo[10];
                boolean isEligible = VolumeDataFactory.isEligible(key, type);
                String[] products = LicenseKey.getProductsForVersion((String)iTextVersion);
                HashMap<String, String> productTypes = new HashMap<String, String>();
                for (String productName : products) {
                    String productType = LicenseKey.getProductInfoForVersion((String)iTextVersion, (String)productName)[3];
                    productTypes.put(productName, productType);
                    isEligible = isEligible || VolumeDataFactory.isEligible(key, productType);
                }
                if (local != null) {
                    local.updateInfo(key, type, productTypes, access, secret);
                    break block10;
                }
                if (isEligible) {
                    WrapperKinesisClientProvider wrapperKinesisClientProvider = new WrapperKinesisClientProvider(VolumeCounterLoader.buildClientProvider(Arrays.asList(new BasicAWSCredentials("AKIAIIWNGWLJS4HO4EUQ", "mf681Ll1uR2Ij6QXHqoWZ1MnUFXbL4jGRS/gKrzd"), new BasicAWSCredentials("AKIAIJQ2YOJ6G4KDN4ZQ", "5052lXnNpZGXdV37P/AJvoizSu8Z33gZDQp4rgS5"), new BasicAWSCredentials("AKIAI63C3DVY2NJCHBJQ", "XtxAcdtHUXMD9vUax+QW+9agdEyQF44UCPL4ORrx"), new BasicAWSCredentials("AKIAI7R34MWFRMLJWSCQ", "fABWyFEo21x+AJzxhHFfWDXRRI9smM/ZSnVoYK6b"), new BasicAWSCredentials("AKIAIRIOXCHB56IINC3Q", "YWlDdhJFvbvG1VKEXmWkGbhmw3BaEfqMN4sS1YS9"), new BasicAWSCredentials("AKIAJDYE6W343SHRPHKQ", "q+EMFVAtbATkSkzVHmEPJy9Tntj8X05vqSQ8jiF+")), Regions.US_EAST_1));
                    local = new VolumeCounter((IEventDataCache<VolumeDataSignature, VolumeData>)new EventDataCacheComparatorBased((Comparator)new EventDataHandlerUtil.BiggerCountComparator()), new VolumeDataFactory(iTextVersion, systemInfo), wrapperKinesisClientProvider, "iTextVolumeCounterStream", Regions.US_EAST_1);
                    local.updateInfo(key, type, productTypes, access, secret);
                }
                Object object = syncLock;
                synchronized (object) {
                    if (counter == null && local != null) {
                        counter = local;
                        EventCounterHandler.getInstance().register((IEventCounterFactory)new SimpleEventCounterFactory((EventCounter)counter));
                    }
                }
            }
            catch (Exception any) {
                if (local != null) {
                    local.unloadInfo();
                }
                throw any;
            }
        }
    }

    private static IKinesisClientProvider buildClientProvider(Collection<BasicAWSCredentials> credentialsCollection, Regions region) {
        ArrayList<AmazonKinesis> clients = new ArrayList<AmazonKinesis>();
        for (AWSCredentials aWSCredentials : credentialsCollection) {
            clients.add(PortingUtils.buildStandardKinesisClient(aWSCredentials, region));
        }
        if (clients.size() == 1) {
            return new StaticKinesisClientProvider((AmazonKinesis)clients.get(0));
        }
        return new RotationKinesisClientProvider(clients);
    }

    private static class VolumeCounter
    extends DataHandlerCounter<VolumeDataSignature, VolumeData> {
        private final VolumeDataFactory dataFactory;
        private final WrapperKinesisClientProvider clientProvider;
        private final Regions region;

        public VolumeCounter(IEventDataCache<VolumeDataSignature, VolumeData> dataCache, VolumeDataFactory dataFactory, WrapperKinesisClientProvider clientProvider, String streamName, Regions region) {
            super((EventDataHandler)new VolumeDataHandler(dataCache, dataFactory, clientProvider, streamName), UnknownContext.RESTRICTIVE);
            this.dataFactory = dataFactory;
            this.clientProvider = clientProvider;
            this.region = region;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void updateInfo(String key, String type, Map<String, String> productTypes, String access, String secret) {
            VolumeDataFactory volumeDataFactory = this.dataFactory;
            synchronized (volumeDataFactory) {
                this.dataFactory.updateLicenseInfo(key, type, productTypes);
            }
            if (!access.trim().isEmpty() && !secret.trim().isEmpty()) {
                this.clientProvider.setCustomClient(PortingUtils.buildStandardKinesisClient((AWSCredentials)new BasicAWSCredentials(access, secret), this.region));
            } else {
                this.clientProvider.setCustomClient(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unloadInfo() {
            VolumeDataFactory volumeDataFactory = this.dataFactory;
            synchronized (volumeDataFactory) {
                this.dataFactory.unloadLicenseInfo();
            }
            this.clientProvider.setCustomClient(null);
        }
    }
}

