/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.kinesis;

import com.amazonaws.services.kinesis.model.PutRecordRequest;
import com.itextpdf.kernel.counter.data.EventData;
import com.itextpdf.kernel.counter.data.EventDataHandler;
import com.itextpdf.kernel.counter.data.IEventDataCache;
import com.itextpdf.kernel.counter.data.IEventDataFactory;
import com.itextpdf.licensekey.PortingUtils;
import com.itextpdf.licensekey.kinesis.IKinesisClientProvider;
import com.itextpdf.licensekey.kinesis.KinesisRecordDataBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.LoggerFactory;

public abstract class KinesisEventDataHandler<T, V extends EventData<T>>
extends EventDataHandler<T, V> {
    private final String streamName;
    private final IKinesisClientProvider clientProvider;
    private final KinesisRecordDataBuffer buffer = new KinesisRecordDataBuffer(0x100000);
    protected final String putErrorLogMessage;
    protected final int errorLimit;
    protected final AtomicLong consecutiveFailures = new AtomicLong(0L);

    public KinesisEventDataHandler(IEventDataCache<T, V> cache, IEventDataFactory<T, V> factory, IKinesisClientProvider clientProvider, String streamName, String putErrorLogMessage, int errorLimit) {
        super(cache, factory, 10000L, 300000L);
        this.streamName = streamName;
        this.clientProvider = clientProvider;
        this.putErrorLogMessage = putErrorLogMessage;
        this.errorLimit = errorLimit;
    }

    protected boolean process(V data) {
        PutRecordRequest putRecordRequest = new PutRecordRequest();
        putRecordRequest.setStreamName(this.streamName);
        putRecordRequest.setData(this.buffer.wrap(this.toBytes(data)).toRecordData());
        putRecordRequest.setPartitionKey("partitionKey-" + (int)(Math.random() * 2.147483647E9));
        return PortingUtils.isSuccessful(this.clientProvider.getClient().putRecord(putRecordRequest));
    }

    protected void onSuccess(V data) {
        super.onSuccess(data);
        this.consecutiveFailures.set(0L);
    }

    protected void onFailure(V data) {
        super.onFailure(data);
        this.clientProvider.refresh();
        if (this.putErrorLogMessage != null && this.consecutiveFailures.get() == 0L) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn(this.putErrorLogMessage);
        }
        if (this.consecutiveFailures.incrementAndGet() > (long)this.errorLimit) {
            this.consecutiveFailures.set(1L);
            if (this.putErrorLogMessage != null) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn(this.putErrorLogMessage);
            }
        }
    }

    protected abstract byte[] toBytes(V var1);
}

