/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.kinesis;

import com.itextpdf.licensekey.PortingUtils;
import com.itextpdf.licensekey.kinesis.IEvent;
import com.itextpdf.licensekey.kinesis.IEventCache;
import com.itextpdf.licensekey.kinesis.Kinesis;
import com.itextpdf.licensekey.kinesis.KinesisAsyncPut;
import java.util.List;

@Deprecated
public class KinesisEventHandler<T extends IEvent> {
    private final Object syncLock = new Object();
    private Kinesis<T> kinesis;
    private IEventCache<T> cache;
    private KinesisAsyncPut<T> previous;
    private long lastProcessedTime = 0L;
    private long initialWaitTimeMillis;
    private long waitTimeMillis;
    private long maxWaitTimeMillis;

    public KinesisEventHandler(Kinesis<T> kinesis, IEventCache<T> cache) {
        this(kinesis, cache, 10000L, 300000L);
    }

    public KinesisEventHandler(Kinesis<T> kinesis, IEventCache<T> cache, long initialWaitTimeMillis, long maxWaitTimeMillis) {
        this.kinesis = kinesis;
        this.cache = cache;
        this.initialWaitTimeMillis = initialWaitTimeMillis;
        this.waitTimeMillis = initialWaitTimeMillis;
        this.maxWaitTimeMillis = maxWaitTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> clear() {
        Object object = this.syncLock;
        synchronized (object) {
            this.previous = null;
            this.lastProcessedTime = 0L;
            this.resetWaitTime();
            return this.cache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(T event) {
        Object object = this.syncLock;
        synchronized (object) {
            this.cache.put(event);
            if (this.previous == null) {
                this.processNext();
            } else if (this.previous.isFinished()) {
                if (this.previous.isSuccessful()) {
                    this.resetWaitTime();
                    this.processNext();
                } else {
                    this.cache.put(this.previous.getEvent());
                    this.increaseWaitTime();
                    this.processNext();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNext() {
        Object object = this.syncLock;
        synchronized (object) {
            long currentTime = PortingUtils.getSystemTimeMills();
            if (currentTime - this.lastProcessedTime > this.waitTimeMillis) {
                T next = this.cache.retrieveNext();
                this.previous = null;
                if (next != null) {
                    this.previous = this.kinesis.asyncPut(next);
                    this.lastProcessedTime = currentTime;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetWaitTime() {
        Object object = this.syncLock;
        synchronized (object) {
            this.waitTimeMillis = this.initialWaitTimeMillis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increaseWaitTime() {
        Object object = this.syncLock;
        synchronized (object) {
            this.waitTimeMillis = Math.min(this.waitTimeMillis * 2L, this.maxWaitTimeMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryProcessRest() {
        Object object = this.syncLock;
        synchronized (object) {
            List<T> unprocessedEvents = this.clear();
            for (IEvent event : unprocessedEvents) {
                this.kinesis.syncPut(event);
            }
        }
    }
}

