/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensekey.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.itextpdf.licensekey.kinesis.IKinesisClientProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RotationKinesisClientProvider
implements IKinesisClientProvider {
    private final List<AmazonKinesis> clients = new ArrayList<AmazonKinesis>();
    private volatile int current = 0;

    public RotationKinesisClientProvider(Collection<AmazonKinesis> clients) {
        for (AmazonKinesis client : clients) {
            if (client == null) continue;
            this.clients.add(client);
        }
        if (this.clients.size() < 1) {
            throw new IllegalArgumentException("The \"clients\" argument must contain at least one not null client");
        }
    }

    @Override
    public AmazonKinesis getClient() {
        return this.clients.get(this.current);
    }

    @Override
    public void refresh() {
        int local = this.current;
        if (++local >= this.clients.size()) {
            local = 0;
        }
        this.current = local;
    }
}

