/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.statistics;

import com.itextpdf.licensing.base.reporting.AwsResourcesCreator;
import com.itextpdf.licensing.base.statistics.IStatisticsServer;
import com.itextpdf.licensing.base.statistics.ProductStatistics;
import com.itextpdf.licensing.base.util.JsonMapperUtil;
import com.itextpdf.licensing.remote.LoggingUtil;
import com.itextpdf.licensing.remote.kinesis.KinesisDataSender;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AwsStatisticsServer
implements IStatisticsServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwsStatisticsServer.class);
    private static final String AWS_KINESIS_STREAM_NAME = "StatisticsData";
    private static final int AWS_RECORD_MAX_SIZE = 0x100000;
    private static AwsStatisticsServer instance;
    private final KinesisDataSender kinesisDataSender = AwsResourcesCreator.createKinesisDataSender(0x100000, "StatisticsData");

    private AwsStatisticsServer() {
    }

    static AwsStatisticsServer getInstance() {
        if (instance == null) {
            LoggingUtil.traceLog((Logger)LOGGER, (String)"Creating new instance of AwsStatisticsServer", (Object[])new Object[0]);
            instance = new AwsStatisticsServer();
        }
        return instance;
    }

    @Override
    public boolean write(List<ProductStatistics> usageList) {
        String usageArrayStr = JsonMapperUtil.serializeToMinimalString(usageList);
        LoggingUtil.traceLog((Logger)LOGGER, (String)"Attempt to write statistic: {0}", (Object[])new Object[]{usageArrayStr});
        if (usageArrayStr != null) {
            byte[] recordBytes = usageArrayStr.getBytes(StandardCharsets.UTF_8);
            return this.kinesisDataSender.sendRecord(recordBytes);
        }
        return false;
    }
}

