/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.volume;

import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.base.LicenseKeyProductData;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.reporting.volume.ProductUsage;
import com.itextpdf.licensing.base.reporting.volume.VolumeData;
import com.itextpdf.licensing.base.util.PortingUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class VolumeDataAggregator {
    private static final String HEALTH_CHECK_EVENT_TYPE = "volume-health-check";

    private VolumeDataAggregator() {
    }

    public static List<ProductUsage> aggregateVolumeEvents(List<VolumeData> dataList) {
        if (dataList == null || dataList.isEmpty()) {
            return new ArrayList<ProductUsage>();
        }
        LinkedHashMap<UsageKey, Map<String, Long>> usages = new LinkedHashMap<UsageKey, Map<String, Long>>();
        for (VolumeData data : dataList) {
            String eventType;
            Long oldUsage;
            UsageKey key = new UsageKey(data.getLicenseFileKey(), data.getProductName());
            LinkedHashMap<String, Long> events = (LinkedHashMap<String, Long>)usages.get(key);
            if (events == null) {
                events = new LinkedHashMap<String, Long>();
                usages.put(key, events);
            }
            if ((oldUsage = (Long)events.get(eventType = data.getEventType())) == null) {
                oldUsage = 0L;
            }
            Long count = oldUsage + data.getCount();
            events.put(eventType, count);
        }
        return VolumeDataAggregator.aggregateUsages(usages, VolumeDataAggregator.getCurrentTimeForSendUsage());
    }

    public static List<ProductUsage> createHealthCheckUsage(String healthCheckTime) {
        LinkedHashMap<UsageKey, Map<String, Long>> usages = new LinkedHashMap<UsageKey, Map<String, Long>>();
        LinkedHashMap<String, Long> eventsMap = new LinkedHashMap<String, Long>();
        eventsMap.put(HEALTH_CHECK_EVENT_TYPE, 1L);
        String licenseKey = VolumeDataAggregator.getSomeLoadedLicenseFileKey();
        String productName = LicenseKeyProductData.getInstance().getProductName();
        usages.put(new UsageKey(licenseKey, productName), eventsMap);
        return VolumeDataAggregator.aggregateUsages(usages, healthCheckTime);
    }

    public static String getCurrentTimeForSendUsage() {
        return PortingUtils.getUtcTimestamp(SystemUtil.getRelativeTimeMillis());
    }

    private static List<ProductUsage> aggregateUsages(Map<UsageKey, Map<String, Long>> usages, String eventTime) {
        ArrayList<ProductUsage> productUsageList = new ArrayList<ProductUsage>(usages.size());
        for (Map.Entry<UsageKey, Map<String, Long>> entry : usages.entrySet()) {
            ProductUsage usage = new ProductUsage(entry.getKey().getLicenseFileKey(), entry.getKey().getProductName(), entry.getValue(), eventTime);
            productUsageList.add(usage);
        }
        return productUsageList;
    }

    private static String getSomeLoadedLicenseFileKey() {
        LicenseFile file = LicenseFileService.getSomeLoadedLicenseFileWithTryPreserveKey();
        if (file == null) {
            throw new LicenseKeyException("License file not loaded.");
        }
        return file.getKey();
    }

    private static final class UsageKey {
        private final String licenseFileKey;
        private final String productName;

        public UsageKey(String licenseFileKey, String productName) {
            this.licenseFileKey = licenseFileKey;
            this.productName = productName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UsageKey usageKey = (UsageKey)o;
            return Objects.equals(this.licenseFileKey, usageKey.licenseFileKey) && Objects.equals(this.productName, usageKey.productName);
        }

        public int hashCode() {
            return Objects.hash(this.licenseFileKey, this.productName);
        }

        public String getLicenseFileKey() {
            return this.licenseFileKey;
        }

        public String getProductName() {
            return this.productName;
        }
    }
}

