/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.AnonymousAWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentity;
import com.amazonaws.services.cognitoidentity.AmazonCognitoIdentityClientBuilder;
import com.amazonaws.services.cognitoidentity.model.Credentials;
import com.amazonaws.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.model.PutRecordResult;
import com.itextpdf.licensing.remote.LicenseKeyRemoteConfigurer;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import com.itextpdf.licensing.remote.auth.AuthData;
import com.itextpdf.licensing.remote.auth.AwsSdkCredentialsProvider;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public final class PortingUtil {
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final ContentType CONTENT_TYPE = ContentType.APPLICATION_JSON;
    private static ClientConfiguration clientConfiguration;

    private PortingUtil() {
    }

    public static AmazonKinesis buildStandardKinesisClient(AwsSdkCredentialsProvider credentialsProvider) {
        return (AmazonKinesis)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)((AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withClientConfiguration(PortingUtil.getClientConfiguration())).withCredentials((AWSCredentialsProvider)new AwsCredentialsProviderStrategy(credentialsProvider))).withRegion(credentialsProvider.getCredentialsData().getRegion())).build();
    }

    public static boolean isSuccessful(PutRecordResult result) {
        return result != null && result.getSdkHttpMetadata().getHttpStatusCode() == 200;
    }

    public static double random() {
        return Math.random();
    }

    public static <T> List<T> singletonList(T o) {
        return Collections.singletonList(o);
    }

    public static String getAwsCurrentUtcTimestamp() {
        ZonedDateTime time = ZonedDateTime.now(ZoneOffset.UTC);
        String datestamp = time.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        return datestamp + "T" + time.format(DateTimeFormatter.ofPattern("HHmmss")) + "Z";
    }

    public static String toHexString(byte[] bytes) {
        try (Formatter formatter = new Formatter();){
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static byte[] hmacSha256HashCalculate(byte[] key, String msg) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new LicenseKeyRemoteException("Exception during request signing.", e);
        }
    }

    public static int getHashCodeFromObjects(Object ... objects) {
        return Objects.hash(objects);
    }

    public static String sha256HashCalculate(byte[] msg) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedHash = digest.digest(msg);
            return PortingUtil.toHexString(encodedHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LicenseKeyRemoteException("Exception during request signing.", e);
        }
    }

    public static AWSCredentials getAwsCredentialsObject(String access, String secret, String session) {
        return session == null ? new BasicAWSCredentials(access, secret) : new BasicSessionCredentials(access, secret, session);
    }

    public static String getJsonContentTypeHeader() {
        return CONTENT_TYPE.getMimeType();
    }

    public static Credentials getAwsCognitoCredentials(AuthData authData, String provider) {
        try {
            return ((AmazonCognitoIdentity)((AmazonCognitoIdentityClientBuilder)((AmazonCognitoIdentityClientBuilder)((AmazonCognitoIdentityClientBuilder)AmazonCognitoIdentityClientBuilder.standard().withClientConfiguration(PortingUtil.getClientConfiguration())).withRegion(authData.getRegion())).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new AnonymousAWSCredentials()))).build()).getCredentialsForIdentity(new GetCredentialsForIdentityRequest().withLogins(Collections.singletonMap(provider, authData.getToken())).withIdentityId(authData.getIdentityId())).getCredentials();
        }
        catch (Exception e) {
            throw new LicenseKeyRemoteException(e.getMessage(), e);
        }
    }

    public static ApiGatewayResponse tryMakePostHttpRequest(String requestBody, String host, String resource, Map<String, String> headers, int timeoutMillis) throws IOException {
        HttpPost httpPost = new HttpPost(HTTPS_PROTOCOL_PREFIX + host + resource);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpPost.addHeader(entry.getKey(), entry.getValue());
        }
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(requestBody.getBytes(StandardCharsets.UTF_8), CONTENT_TYPE));
        httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(timeoutMillis).setConnectTimeout(timeoutMillis).setSocketTimeout(timeoutMillis).setNormalizeUri(false).build());
        ClientConfiguration clientConfig = PortingUtil.getClientConfiguration();
        String proxyHost = clientConfig.getProxyHost();
        int proxyPort = clientConfig.getProxyPort();
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (null != proxyHost && !proxyHost.trim().isEmpty() && proxyPort != -1) {
            builder.setProxy(new HttpHost(proxyHost, proxyPort));
        }
        try (CloseableHttpClient httpClient = builder.build();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int status = response.getStatusLine().getStatusCode();
            String body = null;
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                body = EntityUtils.toString((HttpEntity)respEntity);
            }
            ApiGatewayResponse apiGatewayResponse = new ApiGatewayResponse(status, body);
            return apiGatewayResponse;
        }
    }

    public static boolean isClientConfigurationInitialized() {
        return null != clientConfiguration;
    }

    static ClientConfiguration getClientConfiguration() {
        PortingUtil.initiateClientConfigInstance();
        return clientConfiguration;
    }

    static void resetClientConfiguration() {
        clientConfiguration = null;
    }

    static void initiateClientConfigInstance() {
        if (null == clientConfiguration) {
            clientConfiguration = new ClientConfiguration();
            LicenseKeyRemoteConfigurer.ProxyConfig proxyConfig = LicenseKeyRemoteConfigurer.getProxyConfig();
            if (null != proxyConfig) {
                clientConfiguration.setProxyHost(proxyConfig.getHost());
                clientConfiguration.setProxyPort(proxyConfig.getPort());
            }
        }
    }

    private static final class AwsCredentialsProviderStrategy
    implements AWSCredentialsProvider {
        private final AwsSdkCredentialsProvider provider;

        public AwsCredentialsProviderStrategy(AwsSdkCredentialsProvider provider) {
            this.provider = provider;
        }

        public AWSCredentials getCredentials() {
            return this.provider.getCredentials();
        }

        public void refresh() {
            this.provider.refresh();
        }
    }
}

