/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.element.AbstractDrawer;
import com.itextpdf.tool.xml.xtra.xfa.format.CornerFormattingElement;
import com.itextpdf.tool.xml.xtra.xfa.format.FormattingElement;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BorderDrawer
extends AbstractDrawer {
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;
    private static final int TOP_LEFT = 0;
    private static final int TOP_RIGHT = 1;
    private static final int BOTTOM_RIGHT = 2;
    private static final int BOTTOM_LEFT = 3;
    protected Boolean fill = false;
    protected BaseColor fillColor = BaseColor.WHITE;
    protected List<FormattingElement> borderEdges = null;
    protected List<CornerFormattingElement> borderCorners = null;
    boolean hasLoweredStyle = false;
    boolean hasEmbossedStyle = false;
    boolean hasEtchedStyle = false;
    boolean hasRaisedStyle = false;
    boolean hasOtherStyle = false;
    protected FormNode borderNode;
    protected boolean isCombElementBorder;
    protected Integer combElementCellsNumber;

    public BorderDrawer(FormNode border) {
        this.borderNode = border;
        this.addBorderLines(border);
        this.calculateStyle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEmpty(FormNode border) {
        int i;
        String borderPresenceValue = XFAUtil.getAttributeValue("presence", border.retrieveAttributes());
        if (borderPresenceValue != null && !"visible".equals(borderPresenceValue)) return true;
        boolean isFill = false;
        FormNode fill = border.retrieveChild("fill");
        if (fill != null) {
            isFill = true;
        }
        List<FormNode> edgeTags = border.retrieveChildren("edge");
        int size = edgeTags.size();
        List<FormNode> cornerTags = border.retrieveChildren("corner");
        String[] presenceValues = new String[size += cornerTags.size()];
        String[] thicknessValues = new String[size];
        String[] strokeValues = new String[size];
        String[] radiusValues = new String[size];
        for (i = 0; i < edgeTags.size(); ++i) {
            Map<String, String> edgeAttributes = edgeTags.get(i).retrieveAttributes();
            if (edgeAttributes == null) continue;
            presenceValues[i] = edgeAttributes.get("presence");
            thicknessValues[i] = edgeAttributes.get("thickness");
            strokeValues[i] = edgeAttributes.get("stroke");
            radiusValues[i] = "1pt";
        }
        for (i = 0; i < cornerTags.size(); ++i) {
            Map<String, String> cornerAttributes = cornerTags.get(i).retrieveAttributes();
            if (cornerAttributes == null) continue;
            presenceValues[edgeTags.size() + i] = (String)cornerAttributes.get("presence");
            thicknessValues[edgeTags.size() + i] = (String)cornerAttributes.get("thickness");
            strokeValues[edgeTags.size() + i] = (String)cornerAttributes.get("stroke");
            radiusValues[edgeTags.size() + i] = (String)cornerAttributes.get("radius");
        }
        boolean hasOtherStyle = false;
        for (String strokeValue : strokeValues) {
            if ("lowered".equals(strokeValue) || "embossed".equals(strokeValue) || "etched".equals(strokeValue) || "raised".equals(strokeValue)) continue;
            hasOtherStyle = true;
        }
        if (isFill) {
            return false;
        }
        if (hasOtherStyle) {
            if (size <= 0) return false;
            for (int i2 = 0; i2 < size; ++i2) {
                float thicknessValue = 0.5f;
                if (thicknessValues[i2] != null) {
                    thicknessValue = CssUtils.getInstance().parsePxInCmMmPcToPt(thicknessValues[i2], "pt");
                }
                float radiusValue = 0.0f;
                if (radiusValues[i2] != null) {
                    radiusValue = CssUtils.getInstance().parsePxInCmMmPcToPt(radiusValues[i2], "pt");
                }
                if (presenceValues[i2] != null && !"visible".equals(presenceValues[i2]) || !((double)thicknessValue > 0.001) || radiusValue == 0.0f) continue;
                return false;
            }
            return true;
        } else {
            if (size != 0 && "hidden".equals(presenceValues[0])) return true;
            return false;
        }
    }

    @Override
    public void draw(PdfContentByte canvas, XFARectangle borderArea) {
        if (this.fill.booleanValue()) {
            if (canvas.isTagged()) {
                canvas.openMCBlock(this);
            }
            canvas.saveState();
            canvas.setColorFill(this.fillColor);
            if (this.borderCorners == null) {
                canvas.rectangle(borderArea.getLlx().floatValue(), borderArea.getUry().floatValue() - borderArea.getHeight().floatValue(), borderArea.getWidth().floatValue(), borderArea.getHeight().floatValue());
            } else {
                canvas.setColorStroke(new BaseColor(0, 255, 0));
                float width = borderArea.getWidth().floatValue();
                float height = borderArea.getHeight().floatValue();
                float llx = borderArea.getLlx().floatValue();
                float ury = borderArea.getUry().floatValue();
                float k = (float)(4.0 * (Math.sqrt(2.0) - 1.0) / 3.0);
                canvas.newPath();
                float r = this.borderCorners.get(0).getRadius().floatValue();
                boolean isRound = "round".equals(this.borderCorners.get(0).getJoin());
                boolean isInverted = "1".equals(this.borderCorners.get(0).getInverted());
                canvas.moveTo(llx, ury - r);
                if (r != 0.0f) {
                    if (isRound && isInverted) {
                        canvas.curveTo(llx + r * k, ury - r, llx + r, ury - k * r, llx + r, ury);
                    } else if (isRound) {
                        canvas.curveTo(llx, ury + r * (k - 1.0f), llx + r * (1.0f - k), ury, llx + r, ury);
                    } else {
                        if (isInverted) {
                            canvas.lineTo(llx + r, ury - r);
                        } else {
                            canvas.lineTo(llx, ury);
                        }
                        canvas.lineTo(llx + r, ury);
                    }
                }
                r = this.borderCorners.get(1).getRadius().floatValue();
                isRound = "round".equals(this.borderCorners.get(1).getJoin());
                isInverted = "1".equals(this.borderCorners.get(1).getInverted());
                canvas.lineTo(llx + width - r, ury);
                if (r != 0.0f) {
                    if (isRound && isInverted) {
                        canvas.curveTo(llx + width - r, ury - r * k, llx + width - r * k, ury - r, llx + width, ury - r);
                    } else if (isRound) {
                        canvas.curveTo(llx + width + r * (k - 1.0f), ury, llx + width, ury + r * (k - 1.0f), llx + width, ury - r);
                    } else {
                        if (isInverted) {
                            canvas.lineTo(llx + width - r, ury - r);
                        } else {
                            canvas.lineTo(llx + width, ury);
                        }
                        canvas.lineTo(llx + width, ury - r);
                    }
                }
                r = this.borderCorners.get(2).getRadius().floatValue();
                isRound = "round".equals(this.borderCorners.get(2).getJoin());
                isInverted = "1".equals(this.borderCorners.get(2).getInverted());
                canvas.lineTo(llx + width, ury - height + r);
                if (r != 0.0f) {
                    if (isRound && isInverted) {
                        canvas.curveTo(llx + width - r * k, ury - height + r, llx + width - r, ury - height + r * k, llx + width - r, ury - height);
                    } else if (isRound) {
                        canvas.curveTo(llx + width, ury - height + r * (1.0f - k), llx + width + r * (k - 1.0f), ury - height, llx + width - r, ury - height);
                    } else {
                        if (isInverted) {
                            canvas.lineTo(llx + width - r, ury - height + r);
                        } else {
                            canvas.lineTo(llx + width, ury - height);
                        }
                        canvas.lineTo(llx + width - r, ury - height);
                    }
                }
                r = this.borderCorners.get(3).getRadius().floatValue();
                isRound = "round".equals(this.borderCorners.get(3).getJoin());
                isInverted = "1".equals(this.borderCorners.get(3).getInverted());
                canvas.lineTo(llx + r, ury - height);
                if (r != 0.0f) {
                    if (isRound && isInverted) {
                        canvas.curveTo(llx + r, ury - height + r * k, llx + r * k, ury - height + r, llx, ury - height + r);
                    } else if (isRound) {
                        canvas.curveTo(llx + r * (1.0f - k), ury - height, llx, ury - height + r * (1.0f - k), llx, ury - height + r);
                    } else {
                        if (isInverted) {
                            canvas.lineTo(llx + r, ury - height + r);
                        } else {
                            canvas.lineTo(llx, ury - height);
                        }
                        canvas.lineTo(llx, ury - height + r);
                    }
                }
                canvas.closePath();
            }
            canvas.fill();
            canvas.restoreState();
            if (canvas.isTagged()) {
                canvas.closeMCBlock(this);
            }
        }
        if (this.borderEdges != null) {
            this.updateBorderLinesPoints(borderArea);
            if (this.hasOtherStyle) {
                boolean saveState = false;
                if (this.borderEdges != null) {
                    saveState = this.drawEdge(this.borderEdges.get(0), canvas, saveState);
                    saveState = this.drawEdge(this.borderEdges.get(2), canvas, saveState);
                    saveState = this.drawEdge(this.borderEdges.get(3), canvas, saveState);
                    saveState = this.drawEdge(this.borderEdges.get(1), canvas, saveState);
                    if (this.isCombElementBorder && "right".equals(this.borderNode.retrieveAttribute("hand"))) {
                        saveState = this.drawCombElementLines(this.borderEdges.get(2), this.borderEdges.get(1), canvas, saveState);
                    }
                }
                if (this.borderCorners != null) {
                    saveState = this.drawCorner(this.borderCorners.get(3), canvas, saveState);
                    saveState = this.drawCorner(this.borderCorners.get(2), canvas, saveState);
                    saveState = this.drawCorner(this.borderCorners.get(1), canvas, saveState);
                    saveState = this.drawCorner(this.borderCorners.get(0), canvas, saveState);
                }
                if (saveState) {
                    canvas.restoreState();
                    if (canvas.isTagged()) {
                        canvas.closeMCBlock(this);
                    }
                }
            } else if (!"hidden".equals(this.borderEdges.get(0).getPresence())) {
                if (this.hasEmbossedStyle) {
                    this.drawEmbossed(canvas, borderArea, BaseColor.GRAY, BaseColor.BLACK, BaseColor.GRAY, BaseColor.BLACK);
                } else if (this.hasEtchedStyle) {
                    this.drawEmbossed(canvas, borderArea, BaseColor.GRAY, BaseColor.WHITE, BaseColor.GRAY, BaseColor.WHITE);
                } else if (this.hasLoweredStyle) {
                    this.drawEmbossed(canvas, borderArea, BaseColor.BLACK, BaseColor.GRAY, new BaseColor(212, 208, 200), BaseColor.BLACK);
                } else if (this.hasRaisedStyle) {
                    this.drawEmbossed(canvas, borderArea, BaseColor.BLACK, BaseColor.WHITE, BaseColor.GRAY, BaseColor.BLACK);
                }
            }
        }
    }

    private void drawEmbossed(PdfContentByte canvas, XFARectangle borderArea, BaseColor color1, BaseColor color2, BaseColor color3, BaseColor color4) {
        float lw = this.borderEdges.get(0).getThickness().floatValue();
        float width = borderArea.getWidth().floatValue();
        float height = borderArea.getHeight().floatValue();
        float llx = borderArea.getLlx().floatValue();
        float ury = borderArea.getUry().floatValue();
        if (canvas.isTagged()) {
            canvas.openMCBlock(this);
        }
        canvas.saveState();
        canvas.setLineWidth(0.0f);
        canvas.setColorFill(color1);
        canvas.moveTo(llx, ury - height);
        canvas.lineTo(llx + lw, ury - height + lw);
        canvas.lineTo(llx + lw, ury - lw);
        canvas.lineTo(llx, ury);
        canvas.closePath();
        canvas.fill();
        canvas.moveTo(llx + lw, ury - lw);
        canvas.lineTo(llx + width - lw, ury - lw);
        canvas.lineTo(llx + width, ury);
        canvas.lineTo(llx, ury);
        canvas.closePath();
        canvas.fill();
        canvas.setColorFill(color2);
        canvas.moveTo(llx + lw, ury - height + lw);
        canvas.lineTo(llx + lw * 2.0f, ury - height + lw * 2.0f);
        canvas.lineTo(llx + lw * 2.0f, ury - lw * 2.0f);
        canvas.lineTo(llx + lw, ury - lw);
        canvas.closePath();
        canvas.fill();
        canvas.moveTo(llx + lw * 2.0f, ury - lw * 2.0f);
        canvas.lineTo(llx + lw, ury - lw);
        canvas.lineTo(llx + width - lw, ury - lw);
        canvas.lineTo(llx + width - lw * 2.0f, ury - lw * 2.0f);
        canvas.closePath();
        canvas.fill();
        canvas.setColorFill(color3);
        canvas.moveTo(llx + width - lw, ury - height + lw);
        canvas.lineTo(llx + width - lw, ury - lw);
        canvas.lineTo(llx + width - lw * 2.0f, ury - lw * 2.0f);
        canvas.lineTo(llx + width - lw * 2.0f, ury - height + lw * 2.0f);
        canvas.closePath();
        canvas.fill();
        canvas.moveTo(llx + lw, ury - height + lw);
        canvas.lineTo(llx + width - lw, ury - height + lw);
        canvas.lineTo(llx + width - lw * 2.0f, ury - height + lw * 2.0f);
        canvas.lineTo(llx + lw * 2.0f, ury - height + lw * 2.0f);
        canvas.closePath();
        canvas.fill();
        canvas.setColorFill(color4);
        canvas.moveTo(llx + width, ury - height);
        canvas.lineTo(llx + width - lw, ury - height + lw);
        canvas.lineTo(llx + width - lw, ury - lw);
        canvas.lineTo(llx + width, ury);
        canvas.closePath();
        canvas.fill();
        canvas.moveTo(llx + lw, ury - height + lw);
        canvas.lineTo(llx, ury - height);
        canvas.lineTo(llx + width, ury - height);
        canvas.lineTo(llx + width - lw, ury - height + lw);
        canvas.closePath();
        canvas.fill();
        canvas.restoreState();
        if (canvas.isTagged()) {
            canvas.closeMCBlock(this);
        }
    }

    protected boolean drawEdge(FormattingElement fe, PdfContentByte canvas, boolean saveState) {
        if ("visible".equals(fe.getPresence()) && (double)fe.getThickness().floatValue() > 0.001) {
            if (!saveState) {
                canvas.saveState();
                if (canvas.isTagged()) {
                    canvas.openMCBlock(this);
                }
                saveState = true;
            }
            canvas.setLineWidth(fe.getThickness().floatValue());
            canvas.setColorStroke(fe.getColor());
            this.setLineDash(canvas, fe);
            float x1 = Math.min(fe.getX1().floatValue(), fe.getX2().floatValue());
            float x2 = Math.max(fe.getX1().floatValue(), fe.getX2().floatValue());
            float y1 = Math.min(fe.getY1().floatValue(), fe.getY2().floatValue());
            float y2 = Math.max(fe.getY1().floatValue(), fe.getY2().floatValue());
            canvas.moveTo(x1, y1);
            canvas.lineTo(x2, y2);
            canvas.stroke();
        }
        return saveState;
    }

    protected boolean drawCombElementLines(FormattingElement bottom, FormattingElement vertical, PdfContentByte canvas, boolean saveState) {
        if ("visible".equals(bottom.getPresence()) && (double)bottom.getThickness().floatValue() > 0.001) {
            if (!saveState) {
                canvas.saveState();
                if (canvas.isTagged()) {
                    canvas.openMCBlock(this);
                }
                saveState = true;
            }
            canvas.setLineWidth(bottom.getThickness().floatValue());
            canvas.setColorStroke(bottom.getColor());
            this.setLineDash(canvas, bottom);
            for (int i = 1; i < this.combElementCellsNumber; ++i) {
                float x1;
                float x2 = x1 = Math.min(bottom.getX1().floatValue(), bottom.getX2().floatValue()) + Math.abs(bottom.getX1().floatValue() - bottom.getX2().floatValue()) * (float)i / (float)this.combElementCellsNumber.intValue();
                float y1 = Math.min(vertical.getY1().floatValue(), vertical.getY2().floatValue());
                float y2 = Math.max(vertical.getY1().floatValue(), vertical.getY2().floatValue());
                canvas.moveTo(x1, y1);
                canvas.lineTo(x2, y2);
            }
            canvas.stroke();
        }
        return saveState;
    }

    protected boolean drawCorner(CornerFormattingElement fe, PdfContentByte canvas, boolean saveState) {
        if ("visible".equals(fe.getPresence()) && (double)fe.getThickness().floatValue() > 0.001) {
            if (!saveState) {
                canvas.saveState();
                if (canvas.isTagged()) {
                    canvas.openMCBlock(this);
                }
                saveState = true;
            }
            if ("round".equals(fe.getJoin())) {
                canvas.setLineWidth(fe.getThickness().floatValue());
                canvas.setColorStroke(fe.getColor());
                this.setLineDash(canvas, fe);
                canvas.saveState();
                canvas.rectangle(fe.getCenterX().floatValue(), fe.getCenterY().floatValue(), (fe.getX1().floatValue() - fe.getX2().floatValue()) * 2.0f, (fe.getY1().floatValue() - fe.getY2().floatValue()) * 2.0f);
                canvas.clip();
                canvas.newPath();
                canvas.setLineWidth(fe.getThickness().floatValue());
                canvas.setColorStroke(fe.getColor());
                this.setLineDash(canvas, fe);
                canvas.circle(fe.getCenterX().floatValue(), fe.getCenterY().floatValue(), fe.getRadius().floatValue());
                canvas.stroke();
                canvas.restoreState();
                if (fe.isInverted()) {
                    canvas.moveTo(fe.getX1().floatValue(), fe.getCenterY().floatValue());
                    canvas.lineTo(fe.getX1().floatValue(), fe.getY2().floatValue());
                    canvas.stroke();
                    canvas.moveTo(fe.getCenterX().floatValue(), fe.getY1().floatValue());
                    canvas.lineTo(fe.getX2().floatValue(), fe.getY1().floatValue());
                    canvas.stroke();
                }
            } else {
                canvas.setLineWidth(fe.getThickness().floatValue());
                canvas.setColorStroke(fe.getColor());
                this.setLineDash(canvas, fe);
                canvas.moveTo(fe.getX1().floatValue(), fe.getY2().floatValue());
                canvas.lineTo(fe.getX1().floatValue(), fe.getY1().floatValue());
                canvas.lineTo(fe.getX2().floatValue(), fe.getY1().floatValue());
                canvas.stroke();
            }
        }
        return saveState;
    }

    @Override
    public boolean isEmpty() {
        if (this.fill.booleanValue()) {
            return false;
        }
        if (this.borderEdges != null) {
            if (this.hasOtherStyle) {
                for (FormattingElement formattingElement : this.borderEdges) {
                    if (!"visible".equals(formattingElement.getPresence()) || !((double)formattingElement.getThickness().floatValue() > 0.001)) continue;
                    return false;
                }
            } else if (!"hidden".equals(this.borderEdges.get(0).getPresence())) {
                return false;
            }
        }
        if (this.borderCorners != null) {
            for (CornerFormattingElement cornerFormattingElement : this.borderCorners) {
                if (!"visible".equals(cornerFormattingElement.getPresence()) || !((double)cornerFormattingElement.getThickness().floatValue() > 0.001) || cornerFormattingElement.getRadius().floatValue() == 0.0f) continue;
                return false;
            }
        }
        return true;
    }

    public float[] getBorderThicknesses() {
        float[] result = null;
        if (this.borderEdges != null && this.borderEdges.size() == 4) {
            result = new float[4];
            result[3] = 0.0f;
            result[2] = 0.0f;
            result[1] = 0.0f;
            result[0] = 0.0f;
            FormattingElement bl = this.borderEdges.get(0);
            if ("lowered".equals(bl.getStroke()) || "etched".equals(bl.getStroke()) || "raised".equals(bl.getStroke()) || "embossed".equals(bl.getStroke())) {
                result[2] = result[3] = bl.getThickness().floatValue() * 4.0f;
                result[1] = result[3];
                result[0] = result[3];
            } else {
                int i = 0;
                for (FormattingElement bl1 : this.borderEdges) {
                    result[i] = "visible".equals(bl1.getPresence()) ? bl1.getThickness().floatValue() * 2.0f : 0.0f;
                    ++i;
                }
            }
        }
        return result;
    }

    public boolean hasEmbossedStyle() {
        return this.hasEmbossedStyle || this.hasEtchedStyle || this.hasLoweredStyle || this.hasRaisedStyle;
    }

    protected void updateBorderLinesPoints(XFARectangle rec) {
        float llx = rec.getLlx().floatValue();
        Float height = rec.getHeight();
        float lly = rec.getUry().floatValue() - (height != null ? height.floatValue() : 0.0f);
        Float width = rec.getWidth();
        float urx = rec.getLlx().floatValue() + (width != null ? width.floatValue() : 0.0f);
        float ury = rec.getUry().floatValue();
        this.setBorderEdgePoints(llx, lly, urx, ury);
        this.setBorderCornerPoints(llx, lly, urx, ury);
    }

    protected void setBorderEdgePoints(float llx, float lly, float urx, float ury) {
        if (this.borderEdges == null) {
            return;
        }
        Float topLeftCornerRadius = Float.valueOf(0.0f);
        Float topRightCornerRadius = Float.valueOf(0.0f);
        Float bottomRightCornerRadius = Float.valueOf(0.0f);
        Float bottomLeftCornerRadius = Float.valueOf(0.0f);
        if (this.borderCorners != null) {
            topLeftCornerRadius = this.borderCorners.get(0).getRadius();
            topRightCornerRadius = this.borderCorners.get(1).getRadius();
            bottomRightCornerRadius = this.borderCorners.get(2).getRadius();
            bottomLeftCornerRadius = this.borderCorners.get(3).getRadius();
        }
        this.borderEdges.get(0).setRectanglePoints(Float.valueOf(llx), Float.valueOf(ury), Float.valueOf(urx), Float.valueOf(ury));
        this.borderEdges.get(1).setRectanglePoints(Float.valueOf(urx), Float.valueOf(ury), Float.valueOf(urx), Float.valueOf(lly));
        this.borderEdges.get(2).setRectanglePoints(Float.valueOf(urx), Float.valueOf(lly), Float.valueOf(llx), Float.valueOf(lly));
        this.borderEdges.get(3).setRectanglePoints(Float.valueOf(llx), Float.valueOf(lly), Float.valueOf(llx), Float.valueOf(ury));
        if (topLeftCornerRadius.floatValue() != 0.0f) {
            this.borderEdges.get(0).setX1(Float.valueOf(this.borderEdges.get(0).getX1().floatValue() + topLeftCornerRadius.floatValue()));
            this.borderEdges.get(3).setY2(Float.valueOf(this.borderEdges.get(3).getY2().floatValue() - topLeftCornerRadius.floatValue()));
        } else {
            this.borderEdges.get(0).setX1(Float.valueOf(this.borderEdges.get(0).getX1().floatValue() - this.borderEdges.get(3).getThickness().floatValue() / 2.0f));
            this.borderEdges.get(3).setY2(Float.valueOf(this.borderEdges.get(3).getY2().floatValue() + this.borderEdges.get(0).getThickness().floatValue() / 2.0f));
        }
        if (topRightCornerRadius.floatValue() != 0.0f) {
            this.borderEdges.get(0).setX2(Float.valueOf(this.borderEdges.get(0).getX2().floatValue() - topRightCornerRadius.floatValue()));
            this.borderEdges.get(1).setY1(Float.valueOf(this.borderEdges.get(1).getY1().floatValue() - topRightCornerRadius.floatValue()));
        } else {
            this.borderEdges.get(0).setX2(Float.valueOf(this.borderEdges.get(0).getX2().floatValue() + this.borderEdges.get(1).getThickness().floatValue() / 2.0f));
            this.borderEdges.get(1).setY1(Float.valueOf(this.borderEdges.get(1).getY1().floatValue() + this.borderEdges.get(0).getThickness().floatValue() / 2.0f));
        }
        if (bottomRightCornerRadius.floatValue() != 0.0f) {
            this.borderEdges.get(2).setX1(Float.valueOf(this.borderEdges.get(2).getX1().floatValue() - bottomRightCornerRadius.floatValue()));
            this.borderEdges.get(1).setY2(Float.valueOf(this.borderEdges.get(1).getY2().floatValue() + bottomRightCornerRadius.floatValue()));
        } else {
            this.borderEdges.get(2).setX1(Float.valueOf(this.borderEdges.get(2).getX1().floatValue() + this.borderEdges.get(1).getThickness().floatValue() / 2.0f));
            this.borderEdges.get(1).setY2(Float.valueOf(this.borderEdges.get(1).getY2().floatValue() - this.borderEdges.get(2).getThickness().floatValue() / 2.0f));
        }
        if (bottomLeftCornerRadius.floatValue() != 0.0f) {
            this.borderEdges.get(2).setX2(Float.valueOf(this.borderEdges.get(2).getX2().floatValue() + bottomLeftCornerRadius.floatValue()));
            this.borderEdges.get(3).setY1(Float.valueOf(this.borderEdges.get(3).getY1().floatValue() + bottomLeftCornerRadius.floatValue()));
        } else {
            this.borderEdges.get(2).setX2(Float.valueOf(this.borderEdges.get(2).getX2().floatValue() - this.borderEdges.get(3).getThickness().floatValue() / 2.0f));
            this.borderEdges.get(3).setY1(Float.valueOf(this.borderEdges.get(3).getY1().floatValue() - this.borderEdges.get(2).getThickness().floatValue() / 2.0f));
        }
    }

    protected void setBorderCornerPoints(float llx, float lly, float urx, float ury) {
        Float bottomLeftRadius;
        Float bottomRightRadius;
        Float topRightRadius;
        Float topLeftRadius;
        if (this.borderCorners == null) {
            return;
        }
        Float topEdgeThickness = Float.valueOf(0.0f);
        Float rightEdgeThickness = Float.valueOf(0.0f);
        Float bottomEdgeThickness = Float.valueOf(0.0f);
        Float leftEdgeThickness = Float.valueOf(0.0f);
        if (this.borderEdges != null) {
            topEdgeThickness = this.borderEdges.get(0).getThickness();
            rightEdgeThickness = this.borderEdges.get(1).getThickness();
            bottomEdgeThickness = this.borderEdges.get(2).getThickness();
            leftEdgeThickness = this.borderEdges.get(3).getThickness();
        }
        if ((topLeftRadius = this.borderCorners.get(0).getRadius()).floatValue() != 0.0f) {
            if (!this.borderCorners.get(0).isInverted()) {
                this.borderCorners.get(0).setRectanglePoints(Float.valueOf(llx), Float.valueOf(ury), Float.valueOf(llx + topLeftRadius.floatValue()), Float.valueOf(ury - topLeftRadius.floatValue()));
                this.borderCorners.get(0).setCenter(Float.valueOf(llx + topLeftRadius.floatValue()), Float.valueOf(ury - topLeftRadius.floatValue()));
            } else {
                this.borderCorners.get(0).setRectanglePoints(Float.valueOf(llx + topLeftRadius.floatValue()), Float.valueOf(ury - topLeftRadius.floatValue()), Float.valueOf(llx - leftEdgeThickness.floatValue() / 2.0f), Float.valueOf(ury + topEdgeThickness.floatValue() / 2.0f));
                this.borderCorners.get(0).setCenter(Float.valueOf(llx), Float.valueOf(ury));
            }
        }
        if ((topRightRadius = this.borderCorners.get(1).getRadius()).floatValue() != 0.0f) {
            if (!this.borderCorners.get(1).isInverted()) {
                this.borderCorners.get(1).setRectanglePoints(Float.valueOf(urx), Float.valueOf(ury), Float.valueOf(urx - topRightRadius.floatValue()), Float.valueOf(ury - topRightRadius.floatValue()));
                this.borderCorners.get(1).setCenter(Float.valueOf(urx - topRightRadius.floatValue()), Float.valueOf(ury - topRightRadius.floatValue()));
            } else {
                this.borderCorners.get(1).setRectanglePoints(Float.valueOf(urx - topRightRadius.floatValue()), Float.valueOf(ury - topRightRadius.floatValue()), Float.valueOf(urx + rightEdgeThickness.floatValue() / 2.0f), Float.valueOf(ury + topEdgeThickness.floatValue() / 2.0f));
                this.borderCorners.get(1).setCenter(Float.valueOf(urx), Float.valueOf(ury));
            }
        }
        if ((bottomRightRadius = this.borderCorners.get(2).getRadius()).floatValue() != 0.0f) {
            if (!this.borderCorners.get(2).isInverted()) {
                this.borderCorners.get(2).setRectanglePoints(Float.valueOf(urx), Float.valueOf(lly), Float.valueOf(urx - bottomRightRadius.floatValue()), Float.valueOf(lly + bottomRightRadius.floatValue()));
                this.borderCorners.get(2).setCenter(Float.valueOf(urx - bottomRightRadius.floatValue()), Float.valueOf(lly + bottomRightRadius.floatValue()));
            } else {
                this.borderCorners.get(2).setRectanglePoints(Float.valueOf(urx - bottomRightRadius.floatValue()), Float.valueOf(lly + bottomRightRadius.floatValue()), Float.valueOf(urx + rightEdgeThickness.floatValue() / 2.0f), Float.valueOf(lly - bottomEdgeThickness.floatValue() / 2.0f));
                this.borderCorners.get(2).setCenter(Float.valueOf(urx), Float.valueOf(lly));
            }
        }
        if ((bottomLeftRadius = this.borderCorners.get(3).getRadius()).floatValue() != 0.0f) {
            if (!this.borderCorners.get(3).isInverted()) {
                this.borderCorners.get(3).setRectanglePoints(Float.valueOf(llx), Float.valueOf(lly), Float.valueOf(llx + bottomLeftRadius.floatValue()), Float.valueOf(lly + bottomLeftRadius.floatValue()));
                this.borderCorners.get(3).setCenter(Float.valueOf(llx + bottomLeftRadius.floatValue()), Float.valueOf(lly + bottomLeftRadius.floatValue()));
            } else {
                this.borderCorners.get(3).setRectanglePoints(Float.valueOf(llx + bottomLeftRadius.floatValue()), Float.valueOf(lly + bottomLeftRadius.floatValue()), Float.valueOf(llx - leftEdgeThickness.floatValue() / 2.0f), Float.valueOf(lly - bottomEdgeThickness.floatValue() / 2.0f));
                this.borderCorners.get(3).setCenter(Float.valueOf(llx), Float.valueOf(lly));
            }
        }
    }

    private void addBorderLines(FormNode border) {
        String borderPesenceValue;
        if (border != null && ((borderPesenceValue = XFAUtil.getAttributeValue("presence", border.retrieveAttributes())) == null || "visible".equals(borderPesenceValue))) {
            BaseColor[] colors;
            String[] strokeValues;
            String[] thicknessValues;
            String[] presenceValues;
            String fillPesenceValue;
            FormNode fill = border.retrieveChild("fill");
            if (fill != null && ((fillPesenceValue = XFAUtil.getAttributeValue("presence", fill.retrieveAttributes())) == null || "visible".equals(fillPesenceValue))) {
                String colorValue;
                Map<String, String> colorAttributes;
                this.fill = true;
                FormNode color = fill.retrieveChild("color");
                if (color != null && (colorAttributes = color.retrieveAttributes()) != null && (colorValue = colorAttributes.get("value")) != null && colorValue.length() > 0) {
                    this.fillColor = XFAUtil.parseXfaColor(colorValue);
                }
            }
            List<FormNode> edgeTags = border.retrieveChildren("edge");
            List<FormNode> cornerTags = border.retrieveChildren("corner");
            if (edgeTags != null && edgeTags.size() > 0) {
                int i;
                if (edgeTags.size() == 1) {
                    edgeTags.add(edgeTags.get(0));
                    edgeTags.add(edgeTags.get(0));
                    edgeTags.add(edgeTags.get(0));
                } else if (edgeTags.size() == 2) {
                    edgeTags.add(edgeTags.get(0));
                    edgeTags.add(edgeTags.get(1));
                } else if (edgeTags.size() == 3) {
                    edgeTags.add(edgeTags.get(1));
                }
                int size = edgeTags.size();
                presenceValues = new String[size];
                thicknessValues = new String[size];
                strokeValues = new String[size];
                colors = new BaseColor[size];
                for (i = 0; i < size; ++i) {
                    String colorValue;
                    Map<String, String> colorAttributes;
                    FormNode colorTag;
                    Map<String, String> attributes = edgeTags.get(i).retrieveAttributes();
                    if (attributes != null) {
                        presenceValues[i] = (String)attributes.get("presence");
                        thicknessValues[i] = (String)attributes.get("thickness");
                        strokeValues[i] = (String)attributes.get("stroke");
                    }
                    if ((colorTag = edgeTags.get(i).retrieveChild("color")) == null || (colorAttributes = colorTag.retrieveAttributes()) == null || (colorValue = colorAttributes.get("value")) == null || colorValue.length() <= 0) continue;
                    colors[i] = XFAUtil.parseXfaColor(colorValue);
                }
                this.initBorderEdges(false);
                i = 0;
                for (FormattingElement borderEdge : this.borderEdges) {
                    BaseColor colorValue;
                    String strokeValue;
                    String thicknessValue;
                    String presenceValue = presenceValues[i];
                    if (presenceValue != null) {
                        borderEdge.setPresence(presenceValue);
                    }
                    if ((thicknessValue = thicknessValues[i]) != null) {
                        borderEdge.setThickness(Float.valueOf(CssUtils.getInstance().parsePxInCmMmPcToPt(thicknessValue, "pt")));
                    }
                    if ((strokeValue = strokeValues[i]) != null) {
                        borderEdge.setStroke(strokeValue);
                    }
                    if ((colorValue = colors[i]) != null) {
                        borderEdge.setColor(colorValue);
                    }
                    if (++i != size) continue;
                    i = 0;
                }
            } else if (cornerTags == null || cornerTags.size() == 0) {
                this.initBorderEdges(false);
            } else {
                this.initBorderEdges(true);
            }
            if (cornerTags != null && cornerTags.size() > 0) {
                int i;
                if (cornerTags.size() == 1) {
                    cornerTags.add(cornerTags.get(0));
                    cornerTags.add(cornerTags.get(0));
                    cornerTags.add(cornerTags.get(0));
                } else if (cornerTags.size() == 2) {
                    cornerTags.add(cornerTags.get(0));
                    cornerTags.add(cornerTags.get(1));
                } else if (cornerTags.size() == 3) {
                    cornerTags.add(cornerTags.get(1));
                }
                int size = cornerTags.size();
                presenceValues = new String[size];
                thicknessValues = new String[size];
                strokeValues = new String[size];
                colors = new BaseColor[size];
                String[] radiusValues = new String[size];
                String[] joinValues = new String[size];
                String[] invertedValues = new String[size];
                for (i = 0; i < size; ++i) {
                    String colorValue;
                    Map<String, String> colorAttributes;
                    FormNode colorTag;
                    Map<String, String> attributes = cornerTags.get(i).retrieveAttributes();
                    if (attributes != null) {
                        presenceValues[i] = attributes.get("presence");
                        thicknessValues[i] = attributes.get("thickness");
                        strokeValues[i] = attributes.get("stroke");
                        radiusValues[i] = attributes.get("radius");
                        joinValues[i] = attributes.get("join");
                        invertedValues[i] = attributes.get("inverted");
                    }
                    if ((colorTag = cornerTags.get(i).retrieveChild("color")) == null || (colorAttributes = colorTag.retrieveAttributes()) == null || (colorValue = colorAttributes.get("value")) == null || colorValue.length() <= 0) continue;
                    colors[i] = XFAUtil.parseXfaColor(colorValue);
                }
                this.borderCorners = new ArrayList<CornerFormattingElement>();
                this.initBorderCorners();
                i = 0;
                for (CornerFormattingElement borderCorner : this.borderCorners) {
                    BaseColor colorValue;
                    String joinValue;
                    String invertedValue;
                    String radiusValue;
                    String strokeValue;
                    String thicknessValue;
                    String presenceValue = presenceValues[i];
                    if (presenceValue != null) {
                        borderCorner.setPresence(presenceValue);
                    }
                    if ((thicknessValue = thicknessValues[i]) != null) {
                        borderCorner.setThickness(Float.valueOf(CssUtils.getInstance().parsePxInCmMmPcToPt(thicknessValue, "pt")));
                    }
                    if ((strokeValue = strokeValues[i]) != null) {
                        borderCorner.setStroke(strokeValue);
                    }
                    if ((radiusValue = radiusValues[i]) != null) {
                        borderCorner.setRadius(Float.valueOf(CssUtils.getInstance().parsePxInCmMmPcToPt(radiusValue, "pt")));
                    }
                    if ((invertedValue = invertedValues[i]) != null) {
                        borderCorner.setInverted(invertedValue);
                    }
                    if ((joinValue = joinValues[i]) != null) {
                        borderCorner.setJoin(joinValue);
                    }
                    if ((colorValue = colors[i]) != null) {
                        borderCorner.setColor(colorValue);
                    }
                    if (++i != size) continue;
                    i = 0;
                }
            }
            if (this.ignoreCorners()) {
                this.borderCorners = null;
            }
        }
    }

    private boolean ignoreCorners() {
        int i;
        if (this.borderCorners == null) {
            return false;
        }
        float thicknessValue = this.borderEdges.get(0).getThickness().floatValue();
        String strokeValue = this.borderEdges.get(0).getStroke();
        BaseColor colorValue = this.borderEdges.get(0).getColor();
        String presenceValue = this.borderEdges.get(0).getPresence();
        for (i = 1; i < this.borderEdges.size(); ++i) {
            if (!strokeValue.equals(this.borderEdges.get(i).getStroke())) {
                return false;
            }
            if (!colorValue.equals(this.borderEdges.get(i).getColor())) {
                return false;
            }
            if (!presenceValue.equals(this.borderEdges.get(i).getPresence())) {
                return false;
            }
            if (!((double)Math.abs(thicknessValue - this.borderEdges.get(i).getThickness().floatValue()) >= 5.0E-4)) continue;
            return false;
        }
        presenceValue = this.borderCorners.get(0).getPresence();
        for (i = 0; i < this.borderCorners.size(); ++i) {
            if ("1".equals(this.borderCorners.get(i).getInverted())) {
                return false;
            }
            if ("round".equals(this.borderCorners.get(i).getJoin())) {
                return false;
            }
            if (!strokeValue.equals(this.borderCorners.get(i).getStroke())) {
                return false;
            }
            if (!colorValue.equals(this.borderCorners.get(i).getColor())) {
                return false;
            }
            if (!presenceValue.equals(this.borderCorners.get(i).getPresence())) {
                return false;
            }
            if (!((double)Math.abs(thicknessValue - this.borderCorners.get(i).getThickness().floatValue()) >= 5.0E-4)) continue;
            return false;
        }
        return true;
    }

    protected void initBorderEdges(boolean empty) {
        this.borderEdges = new ArrayList<FormattingElement>();
        FormattingElement topLine = new FormattingElement();
        this.borderEdges.add(topLine);
        FormattingElement rightLine = new FormattingElement();
        this.borderEdges.add(rightLine);
        FormattingElement bottomLine = new FormattingElement();
        this.borderEdges.add(bottomLine);
        FormattingElement leftLine = new FormattingElement();
        this.borderEdges.add(leftLine);
        if (empty) {
            for (FormattingElement fe : this.borderEdges) {
                fe.setThickness(Float.valueOf(0.0f));
            }
        }
    }

    protected void initBorderCorners() {
        this.borderCorners = new ArrayList<CornerFormattingElement>();
        CornerFormattingElement leftTopCorner = new CornerFormattingElement();
        this.borderCorners.add(leftTopCorner);
        CornerFormattingElement rightTopCorner = new CornerFormattingElement();
        this.borderCorners.add(rightTopCorner);
        CornerFormattingElement rightBottomCorner = new CornerFormattingElement();
        this.borderCorners.add(rightBottomCorner);
        CornerFormattingElement leftBottomCorner = new CornerFormattingElement();
        this.borderCorners.add(leftBottomCorner);
    }

    protected void calculateStyle() {
        if (this.borderEdges != null) {
            for (FormattingElement formattingElement : this.borderEdges) {
                if ("lowered".equals(formattingElement.getStroke())) {
                    this.hasLoweredStyle = true;
                    continue;
                }
                if ("embossed".equals(formattingElement.getStroke())) {
                    this.hasEmbossedStyle = true;
                    continue;
                }
                if ("etched".equals(formattingElement.getStroke())) {
                    this.hasEtchedStyle = true;
                    continue;
                }
                if ("raised".equals(formattingElement.getStroke())) {
                    this.hasRaisedStyle = true;
                    continue;
                }
                this.hasOtherStyle = true;
            }
            if (this.borderCorners != null) {
                for (CornerFormattingElement cornerFormattingElement : this.borderCorners) {
                    if ("lowered".equals(cornerFormattingElement.getStroke())) {
                        this.hasLoweredStyle = true;
                        continue;
                    }
                    if ("embossed".equals(cornerFormattingElement.getStroke())) {
                        this.hasEmbossedStyle = true;
                        continue;
                    }
                    if ("etched".equals(cornerFormattingElement.getStroke())) {
                        this.hasEtchedStyle = true;
                        continue;
                    }
                    if ("raised".equals(cornerFormattingElement.getStroke())) {
                        this.hasRaisedStyle = true;
                        continue;
                    }
                    if (!(cornerFormattingElement.getRadius().floatValue() > 0.0f)) continue;
                    this.hasOtherStyle = true;
                }
            }
            if (this.hasOtherStyle) {
                this.hasLoweredStyle = false;
                this.hasEmbossedStyle = false;
                this.hasEtchedStyle = false;
                this.hasRaisedStyle = false;
                for (FormattingElement formattingElement : this.borderEdges) {
                    if (!"lowered".equals(formattingElement.getStroke()) && !"embossed".equals(formattingElement.getStroke()) && !"etched".equals(formattingElement.getStroke()) && !"raised".equals(formattingElement.getStroke())) continue;
                    formattingElement.setStroke("solid");
                }
                if (this.borderCorners != null) {
                    for (FormattingElement formattingElement : this.borderCorners) {
                        if (!"lowered".equals(formattingElement.getStroke()) && !"embossed".equals(formattingElement.getStroke()) && !"etched".equals(formattingElement.getStroke()) && !"raised".equals(formattingElement.getStroke())) continue;
                        formattingElement.setStroke("solid");
                    }
                }
            }
        }
    }

    protected void setLineDash(PdfContentByte canvas, FormattingElement fe) {
        if (fe.getStroke() == null || "solid".equals(fe.getStroke())) {
            canvas.setLineDash(0.0f);
        } else if ("dotted".equals(fe.getStroke())) {
            canvas.setLineDash(fe.getThickness().floatValue(), fe.getThickness().floatValue() * 2.0f, 0.0f);
        } else if ("dashed".equals(fe.getStroke())) {
            canvas.setLineDash(fe.getThickness().floatValue() * 5.0f, fe.getThickness().floatValue() * 1.0f, 0.0f);
        } else if ("dashDot".equals(fe.getStroke())) {
            float[] arr = new float[]{3.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue(), 1.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue()};
            canvas.setLineDash(arr, 0.0f);
        } else if ("dashDotDot".equals(fe.getStroke())) {
            float[] arr = new float[]{3.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue(), 1.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue(), 1.0f * fe.getThickness().floatValue(), 2.0f * fe.getThickness().floatValue()};
            canvas.setLineDash(arr, 0.0f);
        }
    }

    public void setCombElementBorder(int combElementCellsNumber) {
        this.isCombElementBorder = true;
        this.combElementCellsNumber = combElementCellsNumber;
    }
}

