/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.xtra.xfa.element.BorderDrawer;
import com.itextpdf.tool.xml.xtra.xfa.format.FormattingElement;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.util.ArrayList;
import java.util.Map;

public class LineDrawer
extends BorderDrawer {
    protected Slope slope = Slope.TOP_TO_BOTTOM;

    public LineDrawer(FormNode border) {
        super(border);
        Map<String, String> attrs = border.retrieveAttributes();
        if (attrs != null && attrs.containsKey("slope")) {
            String slopeAttr = attrs.get("slope");
            if ("\\".equals(slopeAttr)) {
                this.slope = Slope.TOP_TO_BOTTOM;
            } else if ("/".equals(slopeAttr)) {
                this.slope = Slope.BOTTOM_TO_TOP;
            }
        }
    }

    @Override
    protected void initBorderEdges(boolean empty) {
        this.borderEdges = new ArrayList();
        this.borderEdges.add(new FormattingElement());
    }

    @Override
    protected void setBorderEdgePoints(float llx, float lly, float urx, float ury) {
        if (this.borderEdges.size() == 1) {
            FormattingElement line = (FormattingElement)this.borderEdges.get(0);
            if (this.slope == Slope.TOP_TO_BOTTOM) {
                line.setRectanglePoints(Float.valueOf(llx), Float.valueOf(ury), Float.valueOf(urx), Float.valueOf(lly));
            } else if (this.slope == Slope.BOTTOM_TO_TOP) {
                line.setRectanglePoints(Float.valueOf(llx), Float.valueOf(lly), Float.valueOf(urx), Float.valueOf(ury));
            }
        }
    }

    @Override
    public void draw(PdfContentByte canvas, XFARectangle borderArea) {
        if (this.borderEdges != null) {
            this.updateBorderLinesPoints(borderArea);
            boolean saveState = false;
            FormattingElement fe = (FormattingElement)this.borderEdges.get(0);
            if ("visible".equals(fe.getPresence())) {
                if (!saveState) {
                    canvas.saveState();
                    if (canvas.isTagged()) {
                        canvas.openMCBlock(this);
                    }
                    saveState = true;
                }
                canvas.setLineWidth(fe.getThickness().floatValue());
                canvas.setColorStroke(fe.getColor());
                this.setLineCap(canvas, fe);
                this.setLineDash(canvas, fe);
                canvas.moveTo(fe.getX1().floatValue(), fe.getY1().floatValue());
                canvas.lineTo(fe.getX2().floatValue(), fe.getY2().floatValue());
                canvas.stroke();
            }
            if (saveState) {
                canvas.restoreState();
                if (canvas.isTagged()) {
                    canvas.closeMCBlock(this);
                }
            }
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.borderEdges != null) {
            for (FormattingElement fe : this.borderEdges) {
                if (!"visible".equals(fe.getPresence())) continue;
                return false;
            }
        }
        return true;
    }

    private void setLineCap(PdfContentByte canvas, FormattingElement fe) {
        if ("butt".equals(fe.getCap())) {
            canvas.setLineCap(0);
        } else if ("round".equals(fe.getCap())) {
            canvas.setLineCap(1);
        } else if ("square".equals(fe.getCap())) {
            canvas.setLineCap(2);
        }
    }

    protected static enum Slope {
        TOP_TO_BOTTOM,
        BOTTOM_TO_TOP;

    }
}

