/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.TabSettings;
import com.itextpdf.text.TabStop;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.FontSelector;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.pdfelement.XFAParagraph;
import com.itextpdf.tool.xml.xtra.xfa.XFAConstants;
import com.itextpdf.tool.xml.xtra.xfa.XFALocale;
import com.itextpdf.tool.xml.xtra.xfa.bind.EmbeddedElement;
import com.itextpdf.tool.xml.xtra.xfa.element.AbstractDrawer;
import com.itextpdf.tool.xml.xtra.xfa.element.CaptionElement;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.XFAFontSelector;
import com.itextpdf.tool.xml.xtra.xfa.element.XFAHyphenation;
import com.itextpdf.tool.xml.xtra.xfa.font.XFAFont;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.positioner.DrawPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.FieldPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextDrawer
extends AbstractDrawer {
    static final int VERTICAL_ALIGN_UNDEFIND = -1;
    static final int VERTICAL_ALIGN_TOP = 0;
    static final int VERTICAL_ALIGN_MIDDLE = 1;
    static final int VERTICAL_ALIGN_BOTTOM = 2;
    static final float MAX_MARGIN_HEIGHT_ADDITION = 1.05f;
    protected final JsNode parentNode;
    protected final XFARectangle pageSize;
    protected final FlattenerContext flattenerContext;
    protected final ArrayList<Element> content = new ArrayList();
    protected ColumnText box;
    protected XFARectangle textRectangle = null;
    protected XFARectangle externalBoxRef = null;
    protected XFARectangle initRect = null;
    protected int verticalAlignment = -1;
    protected boolean resolved = true;
    float verticalAlignShift = 0.0f;
    float widthAddition = 0.0f;
    float heightAddition = 0.0f;
    boolean ignoreEmbeddedElement = false;
    boolean isRTL = false;
    boolean isAutoSize = false;
    float autoSizeLimit = 144.0f;
    String autoSizePlainText = null;
    float marginHeightAddition;

    public TextDrawer(JsNode parentNode, XFARectangle pageSize, String plainText, FlattenerContext flattenerContext) {
        this(parentNode, pageSize, flattenerContext, false);
        if (plainText != null && plainText.length() > 0) {
            Font f1 = this.flattenerContext.getFont(parentNode, "Cp1252");
            if (f1.getSize() == 0.0f) {
                this.isAutoSize = true;
                this.autoSizePlainText = plainText;
            }
            Font f2 = this.flattenerContext.getFont(parentNode, "Identity-H");
            this.initBasedOnPlainTextAndFonts(plainText, f1, f2);
        }
    }

    public TextDrawer(JsNode parentNode, XFARectangle pageSize, List<Element> richText, FlattenerContext flattenerContext) {
        this(parentNode, pageSize, flattenerContext, false);
        this.processRichText(richText);
        this.applyContainerStyles();
    }

    public TextDrawer(JsNode parentNode, XFARectangle pageSize, List<Element> richText, FlattenerContext flattenerContext, boolean ignoreEmbeddedElement) {
        this(parentNode, pageSize, flattenerContext, ignoreEmbeddedElement);
        this.processRichText(richText);
        this.applyContainerStyles();
    }

    private TextDrawer(JsNode parentNode, XFARectangle pageSize, FlattenerContext flattenerContext, boolean ignoreEmbeddedElement) {
        this.role = PdfName.DIV;
        this.parentNode = parentNode;
        this.pageSize = pageSize;
        this.flattenerContext = flattenerContext;
        this.ignoreEmbeddedElement = ignoreEmbeddedElement;
    }

    protected void initBasedOnPlainTextAndFonts(String plainText, Font f1, Font f2) {
        this.content.clear();
        if (plainText != null && plainText.length() > 0) {
            XFAFontSelector fontSelector = new XFAFontSelector();
            if (f1 != null) {
                fontSelector.addFont(f1);
            }
            if (f2 != null) {
                fontSelector.addFont(f2);
            }
            Phrase ph = ((FontSelector)fontSelector).process(plainText);
            for (Chunk c : ph.getChunks()) {
                this.checkForUnderlineAndLineThrough(c);
            }
            XFAParagraph p = new XFAParagraph(ph);
            this.isRTL = this.isRightToLeft(p);
            p.setLeading(Float.NaN);
            this.applyParagraphStyles(p);
            this.content.add(p);
            this.applyContainerStyles();
        }
    }

    protected void reInitAutoSizeText() {
        Font f1 = this.flattenerContext.getFont(this.parentNode, "Cp1252");
        f1.setSize(12.0f);
        Font f2 = this.flattenerContext.getFont(this.parentNode, "Identity-H");
        f2.setSize(12.0f);
        this.initBasedOnPlainTextAndFonts(this.autoSizePlainText, f1, f2);
    }

    public static String getMaxSingleLineText(String originalText, XFARectangle textArea, JsNode node, Rectangle pageSize, FlattenerContext flattenerContext) {
        int l = 0;
        int r = originalText.length();
        while (l < r) {
            int m = (l + r + 1) / 2;
            String curSubstring = originalText.substring(0, m);
            TextDrawer textDrawer = new TextDrawer(node, new XFARectangle(pageSize), curSubstring, flattenerContext);
            textDrawer.createColumnText(textArea);
            if (textDrawer.box.getLinesWritten() == 1) {
                l = m;
                continue;
            }
            r = m - 1;
        }
        return originalText.substring(0, l);
    }

    public ArrayList<Element> getContent() {
        return this.content;
    }

    public FlattenerContext getFlattenerContext() {
        return this.flattenerContext;
    }

    public String getContentAsString() {
        StringBuilder stringContent = new StringBuilder();
        for (Element el : this.content) {
            for (Chunk ck : el.getChunks()) {
                stringContent.append(ck.getContent());
            }
        }
        return stringContent.toString();
    }

    public void createColumnText(XFARectangle rec) {
        this.externalBoxRef = rec;
        this.initRect = rec.clone();
        this.box = null;
        this.verticalAlignShift = 0.0f;
        this.widthAddition = 0.0f;
        this.heightAddition = 0.0f;
        if (this.content.size() > 0) {
            Float ury = rec.getUry();
            Float height = rec.getHeight();
            if (height == null && this.isAutoSize) {
                height = rec.getMinH();
            }
            Float lly = Float.valueOf(0.0f);
            if (height == null) {
                Float maxH = rec.getMaxH();
                if (maxH == null) {
                    lly = Float.valueOf(-3.4028235E38f);
                    if (this.isAutoSize) {
                        this.reInitAutoSizeText();
                        this.isAutoSize = false;
                    }
                } else {
                    lly = Float.valueOf(ury.floatValue() - maxH.floatValue());
                }
            } else {
                lly = Float.valueOf(ury.floatValue() - height.floatValue());
            }
            Float llx = rec.getLlx();
            Float width = rec.getWidth();
            if (width == null && this.isAutoSize) {
                width = rec.getMinW();
            }
            Float urx = Float.valueOf(0.0f);
            if (width == null) {
                Float maxW = rec.getMaxW();
                if (maxW == null) {
                    maxW = Float.valueOf(Math.max(this.pageSize.getWidth().floatValue(), this.pageSize.getHeight().floatValue()));
                    if (this.isAutoSize) {
                        this.reInitAutoSizeText();
                        this.isAutoSize = false;
                    }
                }
                urx = Float.valueOf(llx.floatValue() + maxW.floatValue());
            } else {
                urx = Float.valueOf(llx.floatValue() + width.floatValue());
            }
            this.box = new ColumnText(null);
            if (this.isRTL) {
                this.box.setRunDirection(3);
            }
            this.box.setUseAscender(true);
            this.box.setInheritGraphicState(true);
            float fontSize = 0.0f;
            float step = 0.2f;
            Font font = null;
            for (Element el : this.content) {
                if (this.isAutoSize && el instanceof Phrase) {
                    if (font == null && ((Phrase)el).getFont() != null) {
                        font = ((Phrase)el).getFont();
                        BaseFont baseFont = font.getBaseFont();
                        if (baseFont == null) {
                            baseFont = font.getCalculatedBaseFont(false);
                        }
                        float factor = baseFont.getFontDescriptor(8, 1.0f) - baseFont.getFontDescriptor(6, 1.0f);
                        fontSize = (ury.floatValue() - lly.floatValue()) / factor;
                        if (fontSize > 4.0f) {
                            if (fontSize > this.autoSizeLimit) {
                                fontSize = this.autoSizeLimit;
                            }
                            step = Math.max((fontSize - 4.0f) / 19.5f, 0.2f);
                        }
                    }
                    TextDrawer.changeFontSize((Phrase)el, fontSize);
                }
                if (width == null || !(el instanceof Paragraph)) continue;
                Paragraph p = (Paragraph)el;
                if (!(width.floatValue() < p.getIndentationLeft() + p.getIndentationRight())) continue;
                float left = p.getIndentationLeft();
                float right = p.getIndentationRight();
                float indents = left + right;
                p.setIndentationLeft(width.floatValue() * left / indents);
                p.setIndentationRight(width.floatValue() * right / indents);
            }
            float yLine = ury.floatValue();
            boolean glyphWidthDeviationApplyed = false;
            float glyphWidthDeviation = Float.NaN;
            boolean deletedRightIndentation = false;
            boolean usedBottomInsetSpace = false;
            try {
                int status = 2;
                block3: while (true) {
                    int latestStatus = status;
                    int latestWrittenLines = this.box.getLinesWritten();
                    this.box.setSimpleColumn(llx.floatValue(), lly.floatValue() - this.marginHeightAddition, urx.floatValue(), ury.floatValue());
                    this.box.setFilledWidth(0.0f);
                    this.box.setText(null);
                    this.box.addElement(this.getEmpty());
                    for (Element el : this.content) {
                        this.box.addElement(el);
                    }
                    this.box.addElement(this.getEmpty());
                    status = this.box.go(true);
                    if (this.isAutoSize) {
                        if ((status & 2) != 0 && !(fontSize - step < 4.0f)) {
                            fontSize -= step;
                            Iterator<Element> iterator = this.content.iterator();
                            while (true) {
                                Element el;
                                if (!iterator.hasNext()) continue block3;
                                el = iterator.next();
                                if (!(el instanceof Phrase)) continue;
                                TextDrawer.changeFontSize((Phrase)el, fontSize);
                            }
                        }
                    } else {
                        if (!Float.isNaN(glyphWidthDeviation) && (this.box.getFilledWidth() - width.floatValue() > glyphWidthDeviation || (!ColumnText.hasMoreText(latestStatus) || ColumnText.hasMoreText(status)) && latestWrittenLines <= this.box.getLinesWritten())) {
                            urx = Float.valueOf(urx.floatValue() - glyphWidthDeviation);
                            status = latestStatus;
                            glyphWidthDeviationApplyed = false;
                        }
                        if (width != null && Float.isNaN(glyphWidthDeviation)) {
                            glyphWidthDeviation = 0.5f;
                            if (ColumnText.hasMoreText(status) && height != null && this.box.getLinesWritten() == 1) {
                                glyphWidthDeviation = 3.0f;
                            }
                            urx = Float.valueOf(urx.floatValue() + glyphWidthDeviation);
                            glyphWidthDeviationApplyed = true;
                            continue;
                        }
                        if (!deletedRightIndentation && this.box.isWordSplit()) {
                            boolean rightIndentationFound = false;
                            for (Element el : this.content) {
                                Paragraph p;
                                if (!(el instanceof Paragraph) || (p = (Paragraph)el).getIndentationRight() == 0.0f) continue;
                                rightIndentationFound = true;
                                p.setIndentationRight(0.0f);
                            }
                            if (rightIndentationFound) {
                                deletedRightIndentation = true;
                                continue;
                            }
                        }
                        if (!usedBottomInsetSpace && (status & 2) != 0) {
                            if (this.parentNode instanceof Positioner) {
                                this.marginHeightAddition = Math.max(0.0f, Math.min(1.05f, ((Positioner)this.parentNode).getBottomInset()));
                            }
                            usedBottomInsetSpace = true;
                            continue;
                        }
                    }
                    break;
                }
            }
            catch (DocumentException status) {
                // empty catch block
            }
            float currentYLine = this.box.getYLine() + this.box.getDescender();
            this.box.setYLine(yLine);
            this.box.setText(null);
            this.box.addElement(this.getEmpty());
            for (Element el : this.content) {
                this.box.addElement(el);
            }
            this.box.addElement(this.getEmpty());
            if (rec.getHeight() == null) {
                if (rec.getMinH() != null) {
                    rec.setHeight(Float.valueOf(rec.getMinH().floatValue() > yLine - currentYLine ? rec.getMinH().floatValue() : yLine - currentYLine));
                } else {
                    rec.setHeight(Float.valueOf(yLine - currentYLine));
                }
                this.heightAddition = 0.001f;
            }
            if (rec.getWidth() == null) {
                if (rec.getMinW() != null) {
                    rec.setWidth(Float.valueOf(rec.getMinW().floatValue() > this.box.getFilledWidth() ? rec.getMinW().floatValue() : this.box.getFilledWidth()));
                } else {
                    rec.setWidth(Float.valueOf(this.box.getFilledWidth()));
                }
                this.widthAddition = 0.005f;
            } else if (glyphWidthDeviationApplyed) {
                this.widthAddition = this.box.getFilledWidth() - rec.getWidth().floatValue() + 0.005f;
            }
            if (this.verticalAlignment != -1 && this.verticalAlignment != 0) {
                float totalPhraseHeight = yLine - currentYLine;
                this.verticalAlignShift = rec.getHeight().floatValue() - totalPhraseHeight;
                if (this.verticalAlignShift > 0.0f) {
                    if (this.verticalAlignment == 1) {
                        ury = Float.valueOf(ury.floatValue() - this.verticalAlignShift / 2.0f);
                        this.verticalAlignShift /= 2.0f;
                    } else if (this.verticalAlignment == 2) {
                        ury = Float.valueOf(ury.floatValue() - this.verticalAlignShift);
                    }
                } else {
                    this.verticalAlignShift = 0.0f;
                }
            }
            this.textRectangle = new XFARectangle(llx, ury, Float.valueOf(this.box.getFilledWidth()), Float.valueOf(yLine - currentYLine));
        } else {
            XFAUtil.setMinAsDefault(rec);
            this.textRectangle = new XFARectangle(rec.getLlx(), rec.getUry(), rec.getWidth(), rec.getHeight());
        }
    }

    private static void changeFontSize(Phrase p, float size) {
        for (int k = 0; k < p.size(); ++k) {
            Element element = (Element)p.get(k);
            if (element instanceof Chunk) {
                ((Chunk)element).getFont().setSize(size);
                continue;
            }
            if (!(element instanceof Phrase)) continue;
            TextDrawer.changeFontSize((Phrase)element, size);
        }
    }

    @Override
    public void draw(PdfContentByte canvas, XFARectangle borderArea) {
        this.draw(canvas, borderArea, false);
    }

    public PositionResult draw(PdfContentByte canvas, XFARectangle parentBoundingBox, boolean simulate) {
        PositionResult pr = new PositionResult(PositionResult.State.FULL_CONTENT, this.externalBoxRef);
        if (canvas != null && canvas.isTagged() && this.isEmpty()) {
            Chunk emptyChunk = new Chunk();
            XFAParagraph p = new XFAParagraph(emptyChunk);
            p.setLeading(Float.NaN);
            this.applyParagraphStyles(p);
            this.content.add(p);
            this.applyContainerStyles();
            canvas.openMCBlock(p);
            canvas.openMCBlock(emptyChunk);
            canvas.closeMCBlock(emptyChunk);
            canvas.closeMCBlock(p);
            return pr;
        }
        if (this.box != null) {
            if (!this.resolved) {
                this.resolveEmbeddedElements();
                if (this.resolved) {
                    this.createColumnText(this.initRect);
                }
            }
            ColumnText box = simulate ? ColumnText.duplicate(this.box) : this.box;
            float yLine = this.externalBoxRef.getUry().floatValue() - this.verticalAlignShift;
            if (parentBoundingBox != null && XFAUtil.lt(this.externalBoxRef.getUry().floatValue() - this.externalBoxRef.getHeight().floatValue(), parentBoundingBox.getUry().floatValue() - parentBoundingBox.getHeight().floatValue())) {
                box.setSimpleColumn(this.externalBoxRef.getLlx().floatValue(), parentBoundingBox.getUry().floatValue() - parentBoundingBox.getHeight().floatValue() - this.marginHeightAddition, this.externalBoxRef.getLlx().floatValue() + this.externalBoxRef.getWidth().floatValue() + this.widthAddition, yLine);
            } else {
                box.setSimpleColumn(this.externalBoxRef.getLlx().floatValue(), this.externalBoxRef.getUry().floatValue() - this.externalBoxRef.getHeight().floatValue() - this.heightAddition - this.marginHeightAddition, this.externalBoxRef.getLlx().floatValue() + this.externalBoxRef.getWidth().floatValue() + this.widthAddition, yLine);
            }
            if (!simulate) {
                if (this.resolved) {
                    box.setCanvas(canvas);
                } else {
                    PdfTemplate pdfTemplate = canvas.createTemplate(this.externalBoxRef.getWidth().floatValue(), this.externalBoxRef.getHeight().floatValue());
                    pdfTemplate.setMatrix(1.0f, 0.0f, 0.0f, 1.0f, -this.externalBoxRef.getLlx().floatValue(), -this.externalBoxRef.getUry().floatValue() + this.externalBoxRef.getHeight().floatValue());
                    pdfTemplate.setBoundingBox(new Rectangle(this.externalBoxRef.getLlx().floatValue(), this.externalBoxRef.getUry().floatValue() - this.pageSize.getHeight().floatValue(), this.externalBoxRef.getLlx().floatValue() + this.pageSize.getWidth().floatValue(), this.externalBoxRef.getUry().floatValue()));
                    if (canvas.isTagged()) {
                        canvas.openMCBlock(this);
                    }
                    canvas.addTemplate(pdfTemplate, this.externalBoxRef.getLlx().floatValue(), this.externalBoxRef.getUry().floatValue() - this.externalBoxRef.getHeight().floatValue(), true);
                    if (canvas.isTagged()) {
                        canvas.closeMCBlock(this);
                    }
                    box.setCanvas(pdfTemplate);
                }
            } else {
                box.setCanvas(null);
            }
            if (!this.resolved && !simulate) {
                this.flattenerContext.addUnresolvedTextDrawer(this);
                return pr;
            }
            try {
                int status = box.go(simulate);
                if ((status & 1) == 0) {
                    if (!simulate) {
                        ColumnText simBox = ColumnText.duplicate(box);
                        simBox.setSimpleColumn(this.externalBoxRef.getLlx().floatValue(), this.externalBoxRef.getUry().floatValue(), this.externalBoxRef.getLlx().floatValue() + this.externalBoxRef.getWidth().floatValue(), this.externalBoxRef.getUry().floatValue());
                        simBox.go(true);
                        float newYLine = box.getYLine() - box.getCurrentLeading() + simBox.getCurrentLeading();
                        this.externalBoxRef.setUry(Float.valueOf(newYLine));
                        this.externalBoxRef.setHeight(Float.valueOf(this.externalBoxRef.getHeight().floatValue() - (yLine - newYLine)));
                        box.setSimpleColumn(this.externalBoxRef.toRectangle());
                    } else {
                        pr.setCurrentLeading(box.getCurrentLeading());
                    }
                    PositionResult.State state = 0 == box.getLinesWritten() ? PositionResult.State.NO_CONTENT : PositionResult.State.CONTENT_PART;
                    pr.setState(state);
                } else if (simulate) {
                    pr.setCurrentLeading(box.getCurrentLeading());
                }
            }
            catch (DocumentException docExc) {
                pr.setState(PositionResult.State.NO_CONTENT);
            }
        } else {
            return new PositionResult(PositionResult.State.NO_CONTENT);
        }
        return pr;
    }

    @Override
    public boolean isEmpty() {
        if (this.box != null) {
            for (Element element : this.content) {
                if (!(element instanceof Phrase) || ((Phrase)element).isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public void resolveEmbeddedElementsAndDraw(boolean forceDraw) throws DocumentException {
        this.resolveEmbeddedElements();
        if (this.resolved || forceDraw) {
            PdfContentByte canvas = this.box.getCanvas();
            this.createColumnText(this.initRect);
            this.box.setSimpleColumn(this.externalBoxRef.getLlx().floatValue(), this.externalBoxRef.getUry().floatValue() - this.externalBoxRef.getHeight().floatValue() - this.heightAddition, this.externalBoxRef.getLlx().floatValue() + this.externalBoxRef.getWidth().floatValue() + this.widthAddition, this.externalBoxRef.getUry().floatValue() - this.verticalAlignShift);
            this.box.setCanvas(canvas);
            this.box.go();
        }
    }

    private void resolveEmbeddedElements() {
        this.resolved = true;
        Font f1 = this.flattenerContext.getFont(this.parentNode, FontFactory.defaultEncoding);
        Font f2 = this.flattenerContext.getFont(this.parentNode, "Identity-H");
        for (Element el : this.content) {
            if (!(el instanceof Paragraph)) continue;
            Paragraph p = (Paragraph)el;
            for (int i = 0; i < p.size(); ++i) {
                if (!(p.get(i) instanceof EmbeddedElement)) continue;
                EmbeddedElement embeddedElement = (EmbeddedElement)p.get(i);
                ArrayList elements = null;
                if (i != p.size() - 1) {
                    elements = new ArrayList(p.subList(i + 1, p.size()));
                }
                int n = p.size() - i;
                for (int j = 0; j < n; ++j) {
                    p.remove(i);
                }
                this.processTextElement(embeddedElement, p, f1, f2);
                i = p.size() - 1;
                if (elements == null) continue;
                p.addAll(elements);
            }
        }
    }

    public XFARectangle getTextRectangle() {
        return this.textRectangle;
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    private Paragraph processTextElement(Element textElement, Paragraph currentParagraph, Font f1, Font f2) {
        Font paragraphF1 = f1 != null ? f1.difference(currentParagraph.getFont()) : currentParagraph.getFont();
        Font paragraphF2 = f2 != null ? ((XFAFont)f2).difference(currentParagraph.getFont(), "Identity-H") : null;
        XFAFontSelector fontSelector = new XFAFontSelector();
        Phrase phrase = null;
        HashMap<String, Object> elementAttributes = null;
        HashMap<PdfName, PdfObject> elementAccessibleAttributes = null;
        PdfName elementRole = null;
        if (textElement instanceof EmbeddedElement) {
            if (!this.ignoreEmbeddedElement) {
                EmbeddedElement embeddedElement = (EmbeddedElement)textElement;
                elementAttributes = embeddedElement.getAttributes();
                if (embeddedElement.isRaw()) {
                    Positioner positioner = embeddedElement.getPositioner();
                    if (positioner == null && embeddedElement.isUri() && (positioner = this.flattenerContext.resolvePositioner(embeddedElement.getEmbedValue())) != null) {
                        Font mergedElementFont;
                        embeddedElement = new EmbeddedElement(((EmbeddedElement)textElement).getEmbedValue());
                        embeddedElement.setRaw(true);
                        Font elementFont = ((EmbeddedElement)textElement).getFont();
                        Font font = mergedElementFont = paragraphF1 != null ? paragraphF1.difference(elementFont) : elementFont;
                        if (mergedElementFont != null) {
                            embeddedElement.setFont(mergedElementFont);
                        } else {
                            embeddedElement.setFont(((EmbeddedElement)textElement).getFont());
                        }
                        embeddedElement.setAttributes(elementAttributes);
                        embeddedElement.setPositioner(positioner);
                    }
                    Object rawValue = null;
                    if (positioner != null) {
                        Object origRawValue = positioner.getRawValue();
                        positioner.execEvent("ready", null);
                        positioner.execEvent("docReady", null);
                        positioner.execValidate();
                        if (this.flattenerContext.getExtraEventList() != null) {
                            for (String event : this.flattenerContext.getExtraEventList()) {
                                positioner.execEvent(event, null);
                            }
                        }
                        if ("".equals(rawValue = positioner.getFormattedValue())) {
                            rawValue = null;
                        }
                        positioner.setRawValue(origRawValue);
                    }
                    if (rawValue == null) {
                        this.resolved = false;
                        currentParagraph.add(embeddedElement);
                    } else {
                        if (rawValue instanceof String) {
                            Font mergedElementFont;
                            Font elementFont = embeddedElement.getFont();
                            Font font = mergedElementFont = paragraphF1 != null ? paragraphF1.difference(elementFont) : elementFont;
                            if (mergedElementFont != null) {
                                fontSelector.addFont(mergedElementFont);
                            }
                            if (paragraphF2 != null) {
                                fontSelector.addFont(((XFAFont)paragraphF2).difference(elementFont, "Identity-H"));
                            }
                            phrase = ((FontSelector)fontSelector).process((String)rawValue);
                        }
                        if (rawValue instanceof List) {
                            this.processRichText((List)rawValue);
                        }
                    }
                }
            }
        } else if (textElement instanceof Chunk) {
            Font mergedElementFont;
            Chunk chunk = (Chunk)textElement;
            elementAttributes = chunk.getAttributes();
            elementAccessibleAttributes = chunk.getAccessibleAttributes();
            Font elementFont = chunk.getFont();
            Font font = mergedElementFont = paragraphF1 != null ? paragraphF1.difference(elementFont) : elementFont;
            if (elementAttributes != null && elementAttributes.containsKey("TAB")) {
                Chunk tabChunk = new Chunk(chunk);
                tabChunk.setFont(mergedElementFont);
                this.checkForUnderlineAndLineThrough(tabChunk);
                currentParagraph.add(tabChunk);
            } else {
                elementRole = chunk.getRole();
                if (mergedElementFont != null) {
                    fontSelector.addFont(mergedElementFont);
                }
                if (paragraphF2 != null) {
                    Font mergedElementUnicodeFont = ((XFAFont)paragraphF2).difference(elementFont, "Identity-H");
                    fontSelector.addFont(mergedElementUnicodeFont);
                }
                phrase = ((FontSelector)fontSelector).process(chunk.getContent());
            }
        } else if (textElement instanceof Paragraph) {
            return this.processParagraph((Paragraph)textElement, currentParagraph, f1, f2);
        }
        if (phrase != null) {
            for (Chunk chunk : phrase.getChunks()) {
                if (elementAttributes != null) {
                    chunk.setAttributes(new HashMap<String, Object>(elementAttributes));
                }
                if (elementAccessibleAttributes != null) {
                    for (Map.Entry<PdfName, PdfObject> entry : elementAccessibleAttributes.entrySet()) {
                        chunk.setAccessibleAttribute(entry.getKey(), entry.getValue());
                    }
                }
                if (elementRole != null) {
                    chunk.setRole(elementRole);
                }
                this.checkForUnderlineAndLineThrough(chunk);
                currentParagraph.add(chunk);
            }
        }
        return null;
    }

    private void processRichText(List<Element> richText) {
        Font f1 = this.flattenerContext.getFont(this.parentNode, "Cp1252");
        Font f2 = this.flattenerContext.getFont(this.parentNode, "Identity-H");
        this.isRTL = this.isRightToLeft(richText);
        XFAParagraph currentParagraph = null;
        boolean newLine = true;
        for (Element element : richText) {
            if (element instanceof Phrase) {
                Phrase currentPhrase = (Phrase)element;
                if (currentPhrase instanceof Paragraph) {
                    Paragraph paragraphClone = this.processParagraph((Paragraph)currentPhrase, currentParagraph, f1, f2);
                    currentParagraph = null;
                    if (paragraphClone.trim()) {
                        newLine = true;
                    } else {
                        if (newLine) {
                            newLine = false;
                            continue;
                        }
                        paragraphClone = new XFAParagraph(Float.NaN);
                        this.processTextElement(new Chunk("\n"), paragraphClone, f1, f2);
                    }
                    this.applyParagraphStyles(paragraphClone);
                    this.content.add(paragraphClone);
                    continue;
                }
                if (currentParagraph == null) {
                    currentParagraph = new XFAParagraph(Float.NaN);
                }
                for (Element e1 : currentPhrase) {
                    this.processTextElement(e1, currentParagraph, f1, f2);
                }
                continue;
            }
            if (element instanceof Chunk && "\n".equals(((Chunk)element).getContent())) {
                if (currentParagraph != null && currentParagraph.trim()) {
                    this.applyParagraphStyles(currentParagraph);
                    this.content.add(currentParagraph);
                    currentParagraph = null;
                    newLine = false;
                    continue;
                }
                currentParagraph = null;
                if (newLine) {
                    newLine = false;
                    continue;
                }
                XFAParagraph newLineParagraph = new XFAParagraph(Float.NaN);
                this.processTextElement(element, newLineParagraph, f1, f2);
                this.applyParagraphStyles(newLineParagraph);
                this.content.add(newLineParagraph);
                continue;
            }
            if (!(element instanceof com.itextpdf.text.List)) continue;
            this.addParagraphToContent(currentParagraph);
            currentParagraph = null;
            if (this.parentNode instanceof DrawPositioner || this.parentNode instanceof FieldPositioner && this.flattenerContext.getXfaVersion() >= 3.3f) {
                this.content.add(this.processList((com.itextpdf.text.List)element, f1, f2));
                continue;
            }
            if (!(this.parentNode instanceof FieldPositioner)) continue;
            Paragraph itemParagraph = new Paragraph(Float.NaN);
            for (Element listItem : ((com.itextpdf.text.List)element).getItems()) {
                if (!(listItem instanceof ListItem)) continue;
                for (Chunk ck : listItem.getChunks()) {
                    this.processTextElement(ck, itemParagraph, f1, f2);
                }
            }
            this.content.add(itemParagraph);
        }
        this.addParagraphToContent(currentParagraph);
    }

    private void addParagraphToContent(Paragraph currentParagraph) {
        if (currentParagraph != null && currentParagraph.trim()) {
            this.applyParagraphStyles(currentParagraph);
            this.content.add(currentParagraph);
        }
    }

    private com.itextpdf.text.List processList(com.itextpdf.text.List list, Font f1, Font f2) {
        com.itextpdf.text.List listClone = list.cloneShallow();
        List<Element> normalizedItems = this.normalizeNestedLists(list);
        for (Element item : normalizedItems) {
            ListItem newItem;
            if (item instanceof com.itextpdf.text.List) {
                listClone.add(this.processList((com.itextpdf.text.List)item, f1, f2));
                continue;
            }
            if (!(item instanceof ListItem)) continue;
            Paragraph p = this.processParagraph((Paragraph)item, null, f1, f2);
            if (p instanceof ListItem) {
                newItem = (ListItem)p;
            } else {
                newItem = new ListItem();
                newItem.add(p);
            }
            ListItem origItem = (ListItem)item;
            if (origItem.getListSymbol() != null) {
                newItem.setListSymbol(origItem.getListSymbol());
            }
            newItem.setMultipliedLeading(1.2f);
            listClone.add(newItem);
        }
        return listClone;
    }

    private List<Element> normalizeNestedLists(com.itextpdf.text.List list) {
        ArrayList<Element> normalizedItems = new ArrayList<Element>();
        for (Element item : list.getItems()) {
            if (!(item instanceof ListItem)) {
                normalizedItems.add(item);
                continue;
            }
            ListItem li = (ListItem)item;
            ListItem liClone = (ListItem)li.cloneShallow(true);
            normalizedItems.add(liClone);
            for (int i = 0; i < li.size(); ++i) {
                Element liChild = (Element)li.get(i);
                if (!(liChild instanceof com.itextpdf.text.List)) {
                    liClone.add(liChild);
                    continue;
                }
                normalizedItems.add(liChild);
                if (i + 1 >= li.size()) continue;
                liClone = (ListItem)li.cloneShallow(true);
                normalizedItems.add(liClone);
                try {
                    char nonBreakingSpace = '\u00a0';
                    Font liSymbolFont = li.getListSymbol().getFont();
                    boolean liCloneSymbolFontSize = true;
                    Font liCloneSymbolFont = new Font(liSymbolFont.getBaseFont(), (float)liCloneSymbolFontSize, liSymbolFont.getStyle(), liSymbolFont.getColor());
                    double spaceWidth = liCloneSymbolFont.getCalculatedBaseFont(true).getWidthPoint(nonBreakingSpace, liCloneSymbolFont.getCalculatedSize());
                    char[] nSpaces = new char[(int)((double)li.getListSymbol().getWidthPoint() / spaceWidth)];
                    Arrays.fill(nSpaces, nonBreakingSpace);
                    Chunk symbol = new Chunk(new String(nSpaces));
                    symbol.setFont(liCloneSymbolFont);
                    liClone.setListSymbol(symbol);
                    continue;
                }
                catch (Exception any) {
                    liClone.setListSymbol(new Chunk(""));
                }
            }
        }
        return normalizedItems;
    }

    private Paragraph processParagraph(Paragraph currentPhrase, Paragraph currentParagraph, Font f1, Font f2) {
        this.addParagraphToContent(currentParagraph);
        currentParagraph = currentPhrase.cloneShallow(true);
        currentParagraph.setId(null);
        boolean newLine = true;
        boolean whitespace = false;
        for (Element element : currentPhrase) {
            Paragraph newParagraph;
            if (element instanceof Chunk) {
                Chunk chunk = (Chunk)element;
                if (currentPhrase.get(0) == element && "\n".equals(chunk.getContent()) && this.flattenerContext.getXfaVersion() == 2.6f && TextDrawer.getXFAApiVersion(currentPhrase) == null || this.content.isEmpty() && currentParagraph.isEmpty() && "\n".equals(chunk.getContent()) || newLine && chunk.isWhitespace()) continue;
                if ("\n".equals(chunk.getContent())) {
                    newLine = true;
                } else {
                    newLine = false;
                    if (whitespace && chunk.isWhitespace()) continue;
                    if (whitespace && chunk.getContent().startsWith(".")) {
                        currentParagraph.set(currentParagraph.size() - 1, new Chunk('\u00a0', chunk.getFont()));
                    }
                    whitespace = chunk.isWhitespace();
                }
            } else {
                newLine = false;
                whitespace = false;
            }
            if ((newParagraph = this.processTextElement(element, currentParagraph, f1, f2)) == null) continue;
            currentParagraph = newParagraph;
        }
        if (currentParagraph.size() == 0 && this.flattenerContext.getXfaVersion() == 2.6f && TextDrawer.getXFAApiVersion(currentParagraph) == null) {
            this.processTextElement(new Chunk("\n"), currentParagraph, f1, f2);
        }
        return currentParagraph;
    }

    private void applyParagraphStyles(Paragraph p) {
        Object hyphenationNode;
        String tabStops;
        HashMap<String, String> userStyles = null;
        if (p instanceof XFAParagraph) {
            userStyles = ((XFAParagraph)p).getUserStyles();
        }
        if (userStyles == null) {
            userStyles = new HashMap();
        }
        if ((tabStops = (String)userStyles.get("xfa-tab-stops")) == null) {
            tabStops = (String)userStyles.get("tab-stops");
        }
        String tabInterval = (String)userStyles.get("tab-interval");
        String localeName = this.parentNode.getStringProperty("locale");
        XFALocale xfaLocale = this.flattenerContext.getLocaleResolver().getLocale(localeName);
        FormNode paraNode = this.parentNode.retrieveChild("para");
        if (paraNode != null && (hyphenationNode = paraNode.retrieveChild("hyphenation")) != null && !"0".equals(hyphenationNode.retrieveAttribute("hyphenate"))) {
            XFAHyphenation hyphenation = new XFAHyphenation(xfaLocale, (FormNode)hyphenationNode, this.flattenerContext);
            p.setHyphenation(hyphenation);
            for (Chunk ch : p.getChunks()) {
                ch.setHyphenation(hyphenation);
            }
        }
        for (Chunk ch : p.getChunks()) {
            if (!ch.getContent().contains("\u00ad")) continue;
            ch.setHyphenation(new XFAHyphenation());
        }
        if (paraNode != null) {
            String spaceBelow;
            String spaceAbove;
            String marginRight;
            String marginLeft;
            String textIndent;
            float lineHeightValue;
            String lineHeight;
            if (p.getAlignment() == -1) {
                String hAlignValue = paraNode.retrieveAttribute("hAlign");
                if ("center".equals(hAlignValue)) {
                    p.setAlignment(1);
                } else if ("right".equals(hAlignValue)) {
                    p.setAlignment(2);
                } else if ("justify".equals(hAlignValue)) {
                    p.setAlignment(3);
                } else if ("justifyAll".equals(hAlignValue)) {
                    p.setAlignment(8);
                }
            }
            if (!userStyles.containsKey("line-height") && (!p.hasLeading() || p.getLeading() == 0.0f && Math.abs(p.getMultipliedLeading() - XFAConstants.DEFAULT_LEADING_MULTIPLIER.floatValue()) < 1.0E-4f) && (lineHeight = paraNode.retrieveAttribute("lineHeight")) != null && !lineHeight.isEmpty() && (lineHeightValue = CssUtils.getInstance().parsePxInCmMmPcToPt(lineHeight, "pt")) > 5.0E-4f) {
                p.setLeading(lineHeightValue);
            }
            if (!userStyles.containsKey("text-indent") && (textIndent = paraNode.retrieveAttribute("textIndent")) != null && !textIndent.isEmpty()) {
                float ti = CssUtils.getInstance().parsePxInCmMmPcToPt(textIndent, "pt");
                if (ti > 0.0f) {
                    p.setFirstLineIndent(ti);
                } else if (ti < 0.0f) {
                    p.setIndentationLeft(p.getIndentationLeft() + Math.abs(ti));
                    p.setFirstLineIndent(ti);
                }
            }
            if (!userStyles.containsKey("margin-left") && (marginLeft = paraNode.retrieveAttribute("marginLeft")) != null && !marginLeft.isEmpty()) {
                float ml = CssUtils.getInstance().parsePxInCmMmPcToPt(marginLeft, "pt");
                if (!this.isRTL) {
                    p.setIndentationLeft(p.getIndentationLeft() + ml);
                } else {
                    p.setIndentationRight(p.getIndentationRight() + ml);
                }
            }
            if (!userStyles.containsKey("margin-right") && (marginRight = paraNode.retrieveAttribute("marginRight")) != null && !marginRight.isEmpty()) {
                float mr = CssUtils.getInstance().parsePxInCmMmPcToPt(marginRight, "pt");
                if (!this.isRTL) {
                    p.setIndentationRight(p.getIndentationRight() + mr);
                } else {
                    p.setIndentationLeft(p.getIndentationLeft() + mr);
                }
            }
            if (!userStyles.containsKey("margin-top") && (spaceAbove = paraNode.retrieveAttribute("spaceAbove")) != null && !spaceAbove.isEmpty()) {
                float sa = CssUtils.getInstance().parsePxInCmMmPcToPt(spaceAbove, "pt");
                p.setSpacingBefore(p.getSpacingBefore() + sa);
            }
            if (!userStyles.containsKey("margin-bottom") && (spaceBelow = paraNode.retrieveAttribute("spaceBelow")) != null && !spaceBelow.isEmpty()) {
                float sb = CssUtils.getInstance().parsePxInCmMmPcToPt(spaceBelow, "pt");
                p.setSpacingAfter(p.getSpacingAfter() + sb);
            }
        }
        if (this.isRTL) {
            switch (p.getAlignment()) {
                case 1: 
                case 3: 
                case 8: {
                    break;
                }
                case 2: {
                    p.setAlignment(0);
                    break;
                }
                default: {
                    p.setAlignment(2);
                }
            }
        }
        if (userStyles.containsKey("text-valign")) {
            String vAlignValue = (String)userStyles.get("text-valign");
            if ("middle".equals(vAlignValue)) {
                this.verticalAlignment = 1;
            } else if ("bottom".equals(vAlignValue)) {
                this.verticalAlignment = 2;
            }
        }
        if (this.isRTL) {
            String marginRight;
            String marginLeft;
            Float marginLeftValue = null;
            if (userStyles.containsKey("margin-left") && (marginLeft = (String)userStyles.get("margin-left")) != null && !marginLeft.isEmpty()) {
                marginLeftValue = Float.valueOf(CssUtils.getInstance().parsePxInCmMmPcToPt(marginLeft, "pt"));
                p.setIndentationLeft(p.getIndentationLeft() - marginLeftValue.floatValue());
            }
            Float marginRightValue = null;
            if (userStyles.containsKey("margin-right") && (marginRight = (String)userStyles.get("margin-right")) != null && !marginRight.isEmpty()) {
                marginRightValue = Float.valueOf(CssUtils.getInstance().parsePxInCmMmPcToPt(marginRight, "pt"));
                p.setIndentationRight(p.getIndentationRight() - marginRightValue.floatValue());
            }
            if (marginLeftValue != null) {
                p.setIndentationRight(p.getIndentationRight() + marginLeftValue.floatValue());
            }
            if (marginRightValue != null) {
                p.setIndentationLeft(p.getIndentationLeft() + marginRightValue.floatValue());
            }
        }
        if (!p.hasLeading()) {
            p.setMultipliedLeading(XFAConstants.DEFAULT_LEADING_MULTIPLIER.floatValue());
        }
        TabSettings tabSettings = null;
        if (tabInterval != null) {
            float tabIntervalValue = CssUtils.getInstance().parsePxInCmMmPcToPt(tabInterval);
            tabSettings = new TabSettings(tabIntervalValue);
        }
        if (tabStops != null) {
            String[] tabStopsValues = tabStops.split(" ");
            ArrayList<TabStop> tabStopsList = new ArrayList<TabStop>();
            for (int i = 0; i < tabStopsValues.length / 2; ++i) {
                TabStop.Alignment tabStopAlign;
                String tabStopAlignName = tabStopsValues[i * 2];
                char decimalSeparator = '.';
                if ("left".equalsIgnoreCase(tabStopAlignName) || "after".equalsIgnoreCase(tabStopAlignName)) {
                    tabStopAlign = TabStop.Alignment.LEFT;
                } else if ("right".equalsIgnoreCase(tabStopAlignName) || "before".equalsIgnoreCase(tabStopAlignName)) {
                    tabStopAlign = TabStop.Alignment.RIGHT;
                } else if ("center".equalsIgnoreCase(tabStopAlignName)) {
                    tabStopAlign = TabStop.Alignment.CENTER;
                } else {
                    if (!"decimal".equalsIgnoreCase(tabStopAlignName)) break;
                    tabStopAlign = TabStop.Alignment.ANCHOR;
                    decimalSeparator = xfaLocale.getDecimalFormatSymbols().getDecimalSeparator();
                }
                String tabStopPositionStrValue = tabStopsValues[i * 2 + 1];
                Float tabStopPosition = Float.valueOf(CssUtils.getInstance().parsePxInCmMmPcToPt(tabStopPositionStrValue));
                tabStopsList.add(new TabStop(tabStopPosition.floatValue(), tabStopAlign, decimalSeparator));
            }
            if (tabSettings != null) {
                tabSettings.setTabStops(tabStopsList);
                p.setTabSettings(tabSettings);
            } else {
                p.setTabSettings(new TabSettings(tabStopsList, 36.0f));
            }
        } else if (tabSettings != null) {
            p.setTabSettings(tabSettings);
        }
    }

    private void applyContainerStyles() {
        if (this.verticalAlignment == -1) {
            FormNode paraNode = this.parentNode.retrieveChild("para");
            String vAlignValue = "";
            if (this.verticalAlignment == -1 && paraNode != null) {
                this.verticalAlignment = 0;
                vAlignValue = paraNode.retrieveAttribute("vAlign");
                if ("middle".equals(vAlignValue)) {
                    this.verticalAlignment = 1;
                } else if ("bottom".equals(vAlignValue)) {
                    this.verticalAlignment = 2;
                }
            }
        }
    }

    private void checkForUnderlineAndLineThrough(Chunk c) {
        String letterSpacing;
        FormNode fontNode = this.parentNode.retrieveChild("font");
        if (fontNode == null && this.parentNode instanceof CaptionElement && this.parentNode.getParent() != null) {
            fontNode = this.parentNode.getParent().retrieveChild("font");
        }
        if (fontNode != null && (c.getAttributes() == null || c.getAttributes().get("CHAR_SPACING") == null) && (letterSpacing = fontNode.retrieveAttribute("letterSpacing")) != null) {
            float letterSpacingValue = 0.0f;
            letterSpacingValue = CssUtils.getInstance().isRelativeValue(letterSpacing) ? CssUtils.getInstance().parseRelativeValue(letterSpacing, c.getFont().getSize()) : CssUtils.getInstance().parsePxInCmMmPcToPt(letterSpacing);
            if (letterSpacingValue != 0.0f) {
                c.setCharacterSpacing(letterSpacingValue);
            }
        }
        if (c.getAttributes() != null && c.getAttributes().containsKey("UNDERLINE")) {
            Object underline = c.getAttributes().get("UNDERLINE");
            if (underline == null) {
                c.getAttributes().remove("UNDERLINE");
            }
            return;
        }
        if (fontNode != null) {
            Float horScale;
            String horizontalScale;
            String lineThroughValue;
            String underlineValue = fontNode.retrieveAttribute("underline");
            if ("1".equals(underlineValue)) {
                c.setUnderline(0.75f, -c.getFont().getSize() / 8.0f);
            }
            if ("1".equals(lineThroughValue = fontNode.retrieveAttribute("lineThrough"))) {
                c.setUnderline(0.3f, c.getFont().getSize() / 3.0f);
            }
            if ((horizontalScale = fontNode.retrieveAttribute("fontHorizontalScale")) != null && !"100%".equals(horizontalScale) && (horScale = XFAUtil.parsePercent(horizontalScale)) != null) {
                c.setHorizontalScaling(horScale.floatValue() / 100.0f);
            }
        }
    }

    private XFAParagraph getEmpty() {
        XFAParagraph p = new XFAParagraph();
        p.add("");
        p.getChunks().get(0).setRole(null);
        p.setRole(null);
        return p;
    }

    private boolean isRightToLeft(String text) {
        Pattern pattern = Pattern.compile("\\p{InArabic}|\\p{InHebrew}|\\p{InSyriac}|\\p{InThaana}");
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    private boolean isRightToLeft(Chunk chunk) {
        return this.isRightToLeft(chunk.toString());
    }

    private boolean isRightToLeft(Paragraph paragraph) {
        for (Chunk chunk : paragraph.getChunks()) {
            if (!this.isRightToLeft(chunk)) continue;
            return true;
        }
        return false;
    }

    private boolean isRightToLeft(List<Element> elementList) {
        for (Element el : elementList) {
            for (Chunk ck : el.getChunks()) {
                if (!this.isRightToLeft(ck)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAutoSize() {
        return this.isAutoSize;
    }

    public float getAutoSizeLimit() {
        return this.autoSizeLimit;
    }

    public void setAutoSizeLimit(float autoSizeLimit) {
        this.autoSizeLimit = autoSizeLimit;
    }

    private static String getXFAApiVersion(Paragraph paragraph) {
        if (paragraph instanceof XFAParagraph) {
            return ((XFAParagraph)paragraph).getApiVersion();
        }
        return null;
    }
}

