/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.js;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.js.IJsObject;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContent;
import com.itextpdf.tool.xml.xtra.xfa.js.ScriptString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsScript
extends JsContent {
    static final Logger logger = LoggerFactory.getLogger(JsScript.class);
    protected static final JsContent scriptJsObject = new JsContent("script");

    public JsScript(Tag tag, IJsObject parent) {
        super(tag, parent, scriptJsObject);
        if (this.flattenerContext != null) {
            this.flattenerContext.addScriptVariableToBeEvaluated(this);
        } else {
            this.evaluate();
        }
    }

    public void evaluate() {
        ScriptString script = ScriptString.createScriptString(this);
        if (script != null) {
            try {
                this.evaluateScript(script);
            }
            catch (Exception exc) {
                String errorMessage = "Java Script variable evaluation";
                String variableName = this.getStringProperty("name");
                if (this.getParent() != null) {
                    errorMessage = errorMessage + "\nXFA form element: " + this.getParent().getSomExpression();
                }
                if (variableName != null && !variableName.isEmpty()) {
                    errorMessage = errorMessage + "\nVariable name: " + variableName;
                }
                logger.error(errorMessage, (Throwable)exc);
            }
        }
    }
}

