/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.resolver;

import com.itextpdf.tool.xml.xtra.xfa.resolver.ClassNameReferenceNode;
import com.itextpdf.tool.xml.xtra.xfa.resolver.IdReferenceNode;
import com.itextpdf.tool.xml.xtra.xfa.resolver.NameReferenceNode;
import com.itextpdf.tool.xml.xtra.xfa.resolver.ShortcutReferenceNode;
import com.itextpdf.tool.xml.xtra.xfa.resolver.SomExpressionNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import java.util.List;
import java.util.Stack;

public class SomExpression {
    protected String expression;
    protected Stack<SomExpressionNode> nodePath;

    public SomExpression(String expression) {
        this.expression = expression;
        this.init();
    }

    public void init() {
        String[] nodes;
        if (this.expression.matches("^#?som\\(.*\\)")) {
            this.expression = this.expression.replaceAll("^#?som\\(", "").replaceAll("\\)$", "");
            nodes = this.expression.split("\\.");
        } else {
            nodes = this.expression.split("\\.");
        }
        this.nodePath = new Stack();
        int somLength = nodes.length;
        if (somLength == 1 && nodes[0].startsWith("#")) {
            this.nodePath.push(new IdReferenceNode(nodes[0]));
        } else {
            for (int i = somLength - 1; i >= 0; --i) {
                String node = nodes[i];
                if (node.startsWith("#")) {
                    this.nodePath.push(new ClassNameReferenceNode(node));
                    continue;
                }
                if (node.startsWith("$")) {
                    this.nodePath.push(new ShortcutReferenceNode(node));
                    continue;
                }
                this.nodePath.push(new NameReferenceNode(node));
            }
        }
    }

    public Stack<SomExpressionNode> getNodePath() {
        return this.nodePath;
    }

    public String getExpression() {
        return this.expression;
    }

    public boolean match(String reference) {
        if (this.nodePath != null && this.nodePath.size() > 0) {
            return this.nodePath.peek().match(reference);
        }
        return false;
    }

    public boolean match(FormNode node) {
        if (this.nodePath != null && this.nodePath.size() > 0) {
            return this.nodePath.peek().match(node);
        }
        return false;
    }

    public boolean matchAndPop(FormNode node) {
        if (this.nodePath != null && this.nodePath.size() > 0 && this.nodePath.peek().match(node)) {
            this.nodePath.pop();
            return true;
        }
        return false;
    }

    public FormNode resolveNode(FormNode rootNode) {
        return this.resolveNode(rootNode, false);
    }

    public FormNode resolveNode(FormNode rootNode, boolean up) {
        if (this.nodePath.size() == 0) {
            return rootNode;
        }
        List<FormNode> childNodes = rootNode.retrieveChildren();
        for (FormNode childNode : childNodes) {
            if (!this.matchAndPop(childNode)) continue;
            FormNode node = this.resolveNode(childNode);
            if (node == null) break;
            return node;
        }
        if (up) {
            return this.resolveNode(rootNode.retrieveParent(), false);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SomExpression)) {
            return false;
        }
        SomExpression that = (SomExpression)o;
        return this.nodePath.equals(that.nodePath);
    }

    public int hashCode() {
        return this.nodePath.hashCode();
    }
}

