/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.tags;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.Span;
import com.itextpdf.tool.xml.xtra.xfa.bind.EmbeddedElement;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RichTextSpan
extends Span {
    static final float DEFAULT_TAB_WIDTH = 36.0f;
    public static final String TEXT = "text";

    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        String styleValue = XFAUtil.getAttributeValue("style", tag.getAttributes());
        ArrayList<Element> l = new ArrayList<Element>(1);
        Map<String, String> css = tag.getCSS();
        String tabCount = css.get("xfa-tab-count");
        if (tabCount != null) {
            int count = Integer.parseInt(tabCount);
            for (int i = 0; i < count; ++i) {
                Chunk tabbedChunk = new Chunk(Chunk.SPACETABBING);
                if (i == count - 1) {
                    HashMap<String, Object> attr = tabbedChunk.getAttributes();
                    attr.put(TEXT, content);
                    tabbedChunk.setAttributes(attr);
                }
                try {
                    l.add(this.getCssAppliers().apply(tabbedChunk, tag, this.getHtmlPipelineContext(ctx)));
                    continue;
                }
                catch (NoCustomContextException e) {
                    throw new RuntimeWorkerException(e);
                }
            }
            return l;
        }
        List<Chunk> sanitizedChunks = !"xfa-spacerun:yes".equals(styleValue) ? HTMLUtils.sanitizeInline(content, false) : HTMLUtils.sanitizeInline(content, true, true);
        for (Chunk sanitized : sanitizedChunks) {
            try {
                l.add(this.getCssAppliers().apply(sanitized, tag, this.getHtmlPipelineContext(ctx)));
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(e);
            }
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        String embedValue;
        Map<String, String> attributes = tag.getAttributes();
        if (attributes != null && (embedValue = this.findEmbedAttributeValue("embed", attributes)) != null) {
            EmbeddedElement embedded = new EmbeddedElement(embedValue);
            String embedTypeValue = this.findEmbedAttributeValue("embedType", attributes);
            if (embedTypeValue == null || "som".equals(embedTypeValue)) {
                embedded.setUri(false);
            } else if ("uri".equals(embedTypeValue)) {
                embedded.setUri(true);
            }
            String embedModeValue = this.findEmbedAttributeValue("embedMode", attributes);
            if (embedModeValue == null || "formatted".equals(embedModeValue)) {
                embedded.setRaw(false);
            } else if ("raw".equals(embedModeValue)) {
                embedded.setRaw(true);
            }
            Chunk dummy = this.getCssAppliers().getChunkCssAplier().apply(new Chunk("dummy"), tag);
            embedded.setFont(dummy.getFont());
            embedded.setAttributes(dummy.getAttributes());
            currentContent.add(embedded);
        }
        return this.currentContentToParagraph(currentContent, false, true, tag, ctx);
    }

    private String findEmbedAttributeValue(String nameAttribute, Map<String, String> attributes) {
        for (String attr : attributes.keySet()) {
            if (!attr.endsWith(nameAttribute)) continue;
            return attributes.get(attr);
        }
        return null;
    }
}

