/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.xml.xmp;

import com.itextpdf.text.pdf.PdfAConformanceLevel;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.xml.xmp.XmpWriter;
import com.itextpdf.xmp.XMPException;
import com.itextpdf.xmp.XMPMeta;
import com.itextpdf.xmp.XMPMetaFactory;
import com.itextpdf.xmp.XMPUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class PdfAXmpWriter
extends XmpWriter {
    private static final String pdfUaExtension = "    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:namespaceURI>http://www.aiim.org/pdfua/ns/id/</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>pdfuaid</pdfaSchema:prefix>\n                <pdfaSchema:schema>PDF/UA identification schema</pdfaSchema:schema>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA version identifier</pdfaProperty:description>\n                      <pdfaProperty:name>part</pdfaProperty:name>\n                      <pdfaProperty:valueType>Integer</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA amendment identifier</pdfaProperty:description>\n                      <pdfaProperty:name>amd</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:category>internal</pdfaProperty:category>\n                      <pdfaProperty:description>PDF/UA corrigenda identifier</pdfaProperty:description>\n                      <pdfaProperty:name>corr</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>";
    private static final String zugferdExtension = "    <x:xmpmeta xmlns:x=\"adobe:ns:meta/\">\n      <rdf:RDF xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\">\n        <rdf:Description rdf:about=\"\" xmlns:zf=\"urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#\">\n          <zf:ConformanceLevel>%s</zf:ConformanceLevel>\n          <zf:DocumentFileName>ZUGFeRD-invoice.xml</zf:DocumentFileName>\n          <zf:DocumentType>INVOICE</zf:DocumentType>\n          <zf:Version>1.0</zf:Version>\n        </rdf:Description>\n        <rdf:Description rdf:about=\"\" xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\">\n          <pdfaExtension:schemas>\n            <rdf:Bag>\n              <rdf:li rdf:parseType=\"Resource\">\n                <pdfaSchema:schema>ZUGFeRD PDFA Extension Schema</pdfaSchema:schema>\n                <pdfaSchema:namespaceURI>urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#</pdfaSchema:namespaceURI>\n                <pdfaSchema:prefix>zf</pdfaSchema:prefix>\n                <pdfaSchema:property>\n                  <rdf:Seq>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>DocumentFileName</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>name of the embedded XML invoice file</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>DocumentType</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>INVOICE</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>Version</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>The actual version of the ZUGFeRD data</pdfaProperty:description>\n                    </rdf:li>\n                    <rdf:li rdf:parseType=\"Resource\">\n                      <pdfaProperty:name>ConformanceLevel</pdfaProperty:name>\n                      <pdfaProperty:valueType>Text</pdfaProperty:valueType>\n                      <pdfaProperty:category>external</pdfaProperty:category>\n                      <pdfaProperty:description>The conformance level of the ZUGFeRD data</pdfaProperty:description>\n                    </rdf:li>\n                  </rdf:Seq>\n                </pdfaSchema:property>\n              </rdf:li>\n            </rdf:Bag>\n          </pdfaExtension:schemas>\n        </rdf:Description>\n      </rdf:RDF>\n    </x:xmpmeta>\n";
    private PdfWriter writer;
    public static final String zugferdSchemaNS = "urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#";
    public static final String zugferdConformanceLevel = "ConformanceLevel";
    public static final String zugferdDocumentFileName = "DocumentFileName";
    public static final String zugferdDocumentType = "DocumentType";
    public static final String zugferdVersion = "Version";

    public PdfAXmpWriter(OutputStream os, PdfAConformanceLevel conformanceLevel, PdfWriter writer) throws IOException {
        super(os);
        this.writer = writer;
        try {
            this.addRdfDescription(conformanceLevel);
        }
        catch (XMPException xmpExc) {
            throw new IOException(xmpExc.getMessage());
        }
    }

    public PdfAXmpWriter(OutputStream os, PdfDictionary info, PdfAConformanceLevel conformanceLevel, PdfWriter writer) throws IOException {
        super(os, info);
        this.writer = writer;
        try {
            this.addRdfDescription(conformanceLevel);
        }
        catch (XMPException xmpExc) {
            throw new IOException(xmpExc.getMessage());
        }
    }

    public PdfAXmpWriter(OutputStream os, Map<String, String> info, PdfAConformanceLevel conformanceLevel, PdfWriter writer) throws IOException {
        super(os, info);
        this.writer = writer;
        try {
            this.addRdfDescription(conformanceLevel);
        }
        catch (XMPException xmpExc) {
            throw new IOException(xmpExc.getMessage());
        }
    }

    private void addRdfDescription(PdfAConformanceLevel conformanceLevel) throws XMPException {
        switch (conformanceLevel) {
            case PDF_A_1A: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "1");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "A");
                break;
            }
            case PDF_A_1B: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "1");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "B");
                break;
            }
            case PDF_A_2A: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "2");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "A");
                break;
            }
            case PDF_A_2B: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "2");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "B");
                break;
            }
            case PDF_A_2U: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "2");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "U");
                break;
            }
            case PDF_A_3A: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "3");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "A");
                break;
            }
            case PDF_A_3B: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "3");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "B");
                break;
            }
            case PDF_A_3U: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "3");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "U");
                break;
            }
            case ZUGFeRD: 
            case ZUGFeRDBasic: 
            case ZUGFeRDComfort: 
            case ZUGFeRDExtended: {
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "part", "3");
                this.xmpMeta.setProperty("http://www.aiim.org/pdfa/ns/id/", "conformance", "B");
                XMPMeta taggedExtensionMetaComfort = XMPMetaFactory.parseFromString(this.getZugferdExtension(conformanceLevel));
                XMPUtils.appendProperties(taggedExtensionMetaComfort, this.xmpMeta, true, false);
                break;
            }
        }
        if (this.writer.isTagged()) {
            XMPMeta taggedExtensionMeta = XMPMetaFactory.parseFromString(pdfUaExtension);
            XMPUtils.appendProperties(taggedExtensionMeta, this.xmpMeta, true, false);
        }
    }

    private String getZugferdExtension(PdfAConformanceLevel conformanceLevel) {
        switch (conformanceLevel) {
            case ZUGFeRD: 
            case ZUGFeRDBasic: {
                return String.format(zugferdExtension, "BASIC");
            }
            case ZUGFeRDComfort: {
                return String.format(zugferdExtension, "COMFORT");
            }
            case ZUGFeRDExtended: {
                return String.format(zugferdExtension, "EXTENDED");
            }
        }
        return null;
    }
}

