/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.js;

import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsNodeList;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import org.mozilla.javascript.NativeObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsLayout
extends NativeObject {
    private static final Logger logger = LoggerFactory.getLogger(JsLayout.class);
    private FlattenerContext flattenerContext;

    public JsLayout(FlattenerContext flattenerContext) {
        this.flattenerContext = flattenerContext;
        this.defineFunctionProperties(new String[]{"absPage"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"absPageSpan"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"h"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"page"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"pageContent"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"pageCount"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"pageSpan"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"sheet"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"sheetCount"}, JsLayout.class, 1);
        this.defineFunctionProperties(new String[]{"w"}, JsLayout.class, 1);
    }

    public Object pageCount() {
        return this.flattenerContext.getPageCount();
    }

    public Object sheetCount() {
        return this.flattenerContext.getSheetCount();
    }

    public Object page(Object currentElement) {
        Integer pageNumber = null;
        if (currentElement instanceof Positioner) {
            pageNumber = ((Positioner)currentElement).getStartPageNumber();
        }
        return pageNumber != null ? pageNumber : this.flattenerContext.getCurrentPageNumber();
    }

    public Object sheet(Object currentElement) {
        Integer sheetNumber = null;
        if (currentElement instanceof Positioner) {
            sheetNumber = ((Positioner)currentElement).getStartSheetNumber();
        }
        return (sheetNumber != null ? sheetNumber : this.flattenerContext.getCurrentSheetNumber()) - 1;
    }

    public Object absPage(Object currentElement) {
        Integer pageNumber = null;
        if (currentElement instanceof Positioner) {
            pageNumber = ((Positioner)currentElement).getStartAbsPageNumber();
        }
        return pageNumber != null ? pageNumber : this.flattenerContext.getCurrentAbsPageNumber();
    }

    public Object pageSpan(Object currentElement) {
        if (currentElement instanceof Positioner) {
            Integer startPageNumber = ((Positioner)currentElement).getStartPageNumber();
            Integer endPageNumber = ((Positioner)currentElement).getEndPageNumber();
            if (endPageNumber != null && startPageNumber != null) {
                return endPageNumber - startPageNumber + 1;
            }
        }
        return currentElement == null ? 1 : -1;
    }

    public Object absPageSpan(Object currentElement) {
        if (currentElement instanceof Positioner) {
            Integer startPageNumber = ((Positioner)currentElement).getStartAbsPageNumber();
            Integer endPageNumber = ((Positioner)currentElement).getEndAbsPageNumber();
            if (endPageNumber != null && startPageNumber != null) {
                return endPageNumber - startPageNumber + 1;
            }
        }
        return currentElement == null ? 1 : -1;
    }

    public Object pageContent() {
        logger.error("pageContent js function is not implemented");
        return new RhinoJsNodeList();
    }

    public Object w(Object node, Object measurement) {
        Float w = null;
        if (node instanceof RhinoJsNodeList) {
            node = ((RhinoJsNodeList)((Object)node)).item(0);
        }
        if (node instanceof Positioner && ((Positioner)node).contentArea != null) {
            XFARectangle contentAreaClone = ((Positioner)node).getContentArea().clone();
            ((Positioner)node).unapplyMargins(contentAreaClone);
            w = contentAreaClone.getWidth();
        }
        if (w == null) {
            w = Float.valueOf(1.0f);
        }
        if (!"pt".equals(measurement)) {
            w = Float.valueOf(1.0f / CssUtils.getInstance().parsePxInCmMmPcToPt("1", measurement.toString()) * w.floatValue());
        }
        return w;
    }

    public Object h(Object node, Object measurement) {
        Float h = null;
        if (node instanceof RhinoJsNodeList) {
            node = ((RhinoJsNodeList)((Object)node)).item(0);
        }
        if (node instanceof Positioner && ((Positioner)node).contentArea != null) {
            XFARectangle contentAreaClone = ((Positioner)node).getContentArea().clone();
            ((Positioner)node).unapplyMargins(contentAreaClone);
            h = contentAreaClone.getHeight();
        }
        if (h == null) {
            h = Float.valueOf(1.0f);
        }
        if (!"pt".equals(measurement)) {
            h = Float.valueOf(1.0f / CssUtils.getInstance().parsePxInCmMmPcToPt("1", measurement.toString()) * h.floatValue());
        }
        return h;
    }
}

