/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.tags;

import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class XFATemplateTag
extends Tag
implements FormNode {
    private List<String> content;
    private List<Element> richText;
    private String dataRef;
    private String fullDataRef;
    private int minOccur = 1;
    private int maxOccur = 1;
    private int initialOccur = 1;
    private Tag bind;

    public XFATemplateTag(String tag, Map<String, String> attr, String ns) {
        super(tag, attr, ns);
        if ("pageArea".equalsIgnoreCase(tag) || "pageSet".equalsIgnoreCase(tag)) {
            this.maxOccur = Integer.MAX_VALUE;
        }
    }

    public XFATemplateTag(String tag) {
        this(tag, new HashMap<String, String>(), "");
    }

    public void addContent(String content) {
        if (this.content == null) {
            this.content = new ArrayList<String>();
        }
        this.content.add(content);
    }

    public List<String> getContent() {
        return this.content;
    }

    @Override
    public XFATemplateTag getParent() {
        return (XFATemplateTag)super.getParent();
    }

    public void addRichTextList(List<Element> list) {
        this.richText = list;
    }

    public List<Element> getRichText() {
        return this.richText;
    }

    public void setDataRef(String dataRef) {
        this.dataRef = dataRef;
    }

    public String getDataRef() {
        return this.dataRef;
    }

    public void setFullDataRef(String fullDataRef) {
        this.fullDataRef = fullDataRef;
    }

    public String getFullDataRef() {
        return this.fullDataRef;
    }

    public int getMinOccur() {
        return this.minOccur;
    }

    public void setMinOccur(int minOccur) {
        this.minOccur = minOccur;
    }

    public int getMaxOccur() {
        return this.maxOccur;
    }

    public void setMaxOccur(int maxOccur) {
        this.maxOccur = maxOccur;
    }

    public int getInitialOccur() {
        return this.initialOccur;
    }

    public Tag getBind() {
        return this.bind;
    }

    public void setBind(Tag bind) {
        this.bind = bind;
    }

    @Override
    public void addChild(Tag t) {
        super.addChild(t);
        if ("occur".equals(t.getName())) {
            this.retrieveOccurence(this);
        }
        if (this.bind == null && "bind".equals(t.getName())) {
            this.bind = t;
        }
    }

    @Override
    public boolean isHidden() {
        String presence;
        Map<String, String> attributes = this.getAttributes();
        return attributes != null && (presence = attributes.get("presence")) != null && "hidden".equals(presence);
    }

    private void retrieveOccurence(XFATemplateTag subForm) {
        Tag occurTag = subForm.getChild("occur", "", false);
        if (occurTag != null) {
            Integer parsedInitial;
            Integer parsedMax;
            Map<String, String> attrs = occurTag.getAttributes();
            Integer parsedMin = XFAUtil.parseInt(attrs.get("min"));
            if (parsedMin != null) {
                this.minOccur = parsedMin;
                if (!"pageArea".equalsIgnoreCase(this.getName())) {
                    this.maxOccur = this.minOccur > 0 ? this.minOccur : 1;
                }
                this.initialOccur = this.minOccur;
            }
            if ((parsedMax = XFAUtil.parseInt(attrs.get("max"))) != null) {
                this.maxOccur = parsedMax;
            }
            if ((parsedInitial = XFAUtil.parseInt(attrs.get("initial"))) != null) {
                this.initialOccur = parsedInitial;
            }
            if (this.maxOccur == -1) {
                this.maxOccur = Integer.MAX_VALUE;
            }
        }
    }

    @Override
    public FormNode retrieveChild(String name) {
        return (FormNode)((Object)this.getChild(name, ""));
    }

    @Override
    public FormNode retrieveChild(String ... path) {
        String name;
        FormNode result = this;
        String[] stringArray = path;
        int n = stringArray.length;
        for (int i = 0; i < n && (result = result.retrieveChild(name = stringArray[i])) != null; ++i) {
        }
        return result;
    }

    public FormNode retrieveLastChild(String name) {
        ListIterator<Tag> it = this.getChildren().listIterator(this.getChildren().size());
        while (it.hasPrevious()) {
            Tag currentChild = it.previous();
            if (!currentChild.getName().equals(name)) continue;
            return (FormNode)((Object)currentChild);
        }
        return null;
    }

    @Override
    public List<FormNode> retrieveChildren() {
        return this.getChildren();
    }

    @Override
    public List<FormNode> retrieveChildren(String name) {
        return this.getChildren(name);
    }

    @Override
    public String retrieveName() {
        return this.getName();
    }

    @Override
    public Map<String, String> retrieveAttributes() {
        return this.getAttributes();
    }

    @Override
    public String retrieveAttribute(String attributeName) {
        return this.getAttributes() != null ? this.getAttributes().get(attributeName) : null;
    }

    @Override
    public FormNode retrieveParent() {
        return this.getParent();
    }

    @Override
    public String retrieveValue() {
        String value = null;
        List<String> content = this.getContent();
        if (content != null && content.size() > 0) {
            value = content.get(0);
        }
        return value;
    }

    @Override
    public List<Element> retrieveRichText() {
        return this.getRichText();
    }

    @Override
    public List<String> retrieveContent() {
        return this.getContent();
    }

    @Override
    public String getClassName() {
        return this.getName();
    }

    @Override
    public String retrieveTagName() {
        return this.getName();
    }
}

