// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ChecksumMode
import aws.sdk.kotlin.services.s3.model.GetObjectRequest
import aws.sdk.kotlin.services.s3.model.RequestPayer
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class GetObjectOperationSerializer: HttpSerialize<GetObjectRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetObjectRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                "${input.key}".split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters {
                add("x-id", "GetObject")
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.partNumber != null) add("partNumber", "${input.partNumber}")
                if (input.responseCacheControl != null) add("response-cache-control", input.responseCacheControl)
                if (input.responseContentDisposition != null) add("response-content-disposition", input.responseContentDisposition)
                if (input.responseContentEncoding != null) add("response-content-encoding", input.responseContentEncoding)
                if (input.responseContentLanguage != null) add("response-content-language", input.responseContentLanguage)
                if (input.responseContentType != null) add("response-content-type", input.responseContentType)
                if (input.responseExpires != null) add("response-expires", input.responseExpires.format(TimestampFormat.RFC_5322))
                if (input.versionId != null) add("versionId", input.versionId)
            }
        }

        builder.headers {
            if (input.checksumMode != null) append("x-amz-checksum-mode", input.checksumMode.value)
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.ifMatch?.isNotEmpty() == true) append("If-Match", input.ifMatch)
            if (input.ifModifiedSince != null) append("If-Modified-Since", input.ifModifiedSince.format(TimestampFormat.RFC_5322))
            if (input.ifNoneMatch?.isNotEmpty() == true) append("If-None-Match", input.ifNoneMatch)
            if (input.ifUnmodifiedSince != null) append("If-Unmodified-Since", input.ifUnmodifiedSince.format(TimestampFormat.RFC_5322))
            if (input.range?.isNotEmpty() == true) append("Range", input.range)
            if (input.requestPayer != null) append("x-amz-request-payer", input.requestPayer.value)
            if (input.sseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-algorithm", input.sseCustomerAlgorithm)
            if (input.sseCustomerKey?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key", input.sseCustomerKey)
            if (input.sseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key-MD5", input.sseCustomerKeyMd5)
        }

        return builder
    }
}
