// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.s3.serde

import aws.sdk.kotlin.services.s3.model.ExpressionType
import aws.sdk.kotlin.services.s3.model.InputSerialization
import aws.sdk.kotlin.services.s3.model.OutputSerialization
import aws.sdk.kotlin.services.s3.model.RequestProgress
import aws.sdk.kotlin.services.s3.model.ScanRange
import aws.sdk.kotlin.services.s3.model.SelectObjectContentRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.serde.xml.XmlDeserializer
import aws.smithy.kotlin.runtime.serde.xml.XmlNamespace
import aws.smithy.kotlin.runtime.serde.xml.XmlSerialName
import aws.smithy.kotlin.runtime.serde.xml.XmlSerializer
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SelectObjectContentOperationSerializer: HttpSerialize<SelectObjectContentRequest> {
    override suspend fun serialize(context: ExecutionContext, input: SelectObjectContentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.key) { "key is bound to the URI and must not be null" }
            path.encodedSegments {
                "${input.key}".split("/").mapTo(this) { PercentEncoding.SmithyLabel.encode(it) }
            }
            parameters.decodedParameters {
                add("select", "")
                add("select-type", "2")
                add("x-id", "SelectObjectContent")
            }
        }

        builder.headers {
            if (input.expectedBucketOwner?.isNotEmpty() == true) append("x-amz-expected-bucket-owner", input.expectedBucketOwner)
            if (input.sseCustomerAlgorithm?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-algorithm", input.sseCustomerAlgorithm)
            if (input.sseCustomerKey?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key", input.sseCustomerKey)
            if (input.sseCustomerKeyMd5?.isNotEmpty() == true) append("x-amz-server-side-encryption-customer-key-MD5", input.sseCustomerKeyMd5)
        }

        val payload = serializeSelectObjectContentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/xml")
        }
        return builder
    }
}

private fun serializeSelectObjectContentOperationBody(context: ExecutionContext, input: SelectObjectContentRequest): ByteArray {
    val serializer = XmlSerializer()
    val EXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, XmlSerialName("Expression"))
    val EXPRESSIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, XmlSerialName("ExpressionType"))
    val INPUTSERIALIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("InputSerialization"))
    val OUTPUTSERIALIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("OutputSerialization"))
    val REQUESTPROGRESS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("RequestProgress"))
    val SCANRANGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, XmlSerialName("ScanRange"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(XmlSerialName("SelectObjectContentRequest"))
        trait(XmlNamespace("http://s3.amazonaws.com/doc/2006-03-01/"))
        field(EXPRESSION_DESCRIPTOR)
        field(EXPRESSIONTYPE_DESCRIPTOR)
        field(INPUTSERIALIZATION_DESCRIPTOR)
        field(OUTPUTSERIALIZATION_DESCRIPTOR)
        field(REQUESTPROGRESS_DESCRIPTOR)
        field(SCANRANGE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.expression?.let { field(EXPRESSION_DESCRIPTOR, it) }
        input.expressionType?.let { field(EXPRESSIONTYPE_DESCRIPTOR, it.value) }
        input.inputSerialization?.let { field(INPUTSERIALIZATION_DESCRIPTOR, it, ::serializeInputSerializationDocument) }
        input.outputSerialization?.let { field(OUTPUTSERIALIZATION_DESCRIPTOR, it, ::serializeOutputSerializationDocument) }
        input.requestProgress?.let { field(REQUESTPROGRESS_DESCRIPTOR, it, ::serializeRequestProgressDocument) }
        input.scanRange?.let { field(SCANRANGE_DESCRIPTOR, it, ::serializeScanRangeDocument) }
    }
    return serializer.toByteArray()
}
