/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.http.interceptors;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.client.Interceptor;
import aws.smithy.kotlin.runtime.client.ProtocolRequestInterceptorContext;
import aws.smithy.kotlin.runtime.client.ProtocolResponseInterceptorContext;
import aws.smithy.kotlin.runtime.client.RequestInterceptorContext;
import aws.smithy.kotlin.runtime.client.ResponseInterceptorContext;
import aws.smithy.kotlin.runtime.compression.CompressionAlgorithm;
import aws.smithy.kotlin.runtime.http.HttpBody;
import aws.smithy.kotlin.runtime.http.compression.CompressRequestKt;
import aws.smithy.kotlin.runtime.http.interceptors.RequestCompressionInterceptorKt;
import aws.smithy.kotlin.runtime.http.request.HttpRequest;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001j\u0002`\u0005B)\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\"\u0010\u0012\u001a\u00020\u00032\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u000f*\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0011\u00a8\u0006\u0016"}, d2={"Laws/smithy/kotlin/runtime/http/interceptors/RequestCompressionInterceptor;", "Laws/smithy/kotlin/runtime/client/Interceptor;", "", "Laws/smithy/kotlin/runtime/http/request/HttpRequest;", "Laws/smithy/kotlin/runtime/http/response/HttpResponse;", "Laws/smithy/kotlin/runtime/http/interceptors/HttpInterceptor;", "compressionThresholdBytes", "", "availableCompressionAlgorithms", "", "Laws/smithy/kotlin/runtime/compression/CompressionAlgorithm;", "supportedCompressionAlgorithms", "", "(JLjava/util/List;Ljava/util/List;)V", "isStreaming", "", "Laws/smithy/kotlin/runtime/http/HttpBody;", "(Laws/smithy/kotlin/runtime/http/HttpBody;)Z", "modifyBeforeRetryLoop", "context", "Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;", "(Laws/smithy/kotlin/runtime/client/ProtocolRequestInterceptorContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "http-client"})
@SourceDebugExtension(value={"SMAP\nRequestCompressionInterceptor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RequestCompressionInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/RequestCompressionInterceptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n*L\n1#1,62:1\n1#2:63\n1#2:65\n258#3:64\n259#3:66\n*S KotlinDebug\n*F\n+ 1 RequestCompressionInterceptor.kt\naws/smithy/kotlin/runtime/http/interceptors/RequestCompressionInterceptor\n*L\n47#1:65\n47#1:64\n47#1:66\n*E\n"})
public final class RequestCompressionInterceptor
implements Interceptor<Object, Object, HttpRequest, HttpResponse> {
    private final long compressionThresholdBytes;
    @NotNull
    private final List<CompressionAlgorithm> availableCompressionAlgorithms;
    @NotNull
    private final List<String> supportedCompressionAlgorithms;

    public RequestCompressionInterceptor(long compressionThresholdBytes, @NotNull List<? extends CompressionAlgorithm> availableCompressionAlgorithms, @NotNull List<String> supportedCompressionAlgorithms) {
        Intrinsics.checkNotNullParameter(availableCompressionAlgorithms, (String)"availableCompressionAlgorithms");
        Intrinsics.checkNotNullParameter(supportedCompressionAlgorithms, (String)"supportedCompressionAlgorithms");
        this.compressionThresholdBytes = compressionThresholdBytes;
        this.availableCompressionAlgorithms = availableCompressionAlgorithms;
        this.supportedCompressionAlgorithms = supportedCompressionAlgorithms;
        IntRange intRange = RequestCompressionInterceptorKt.access$getVALID_COMPRESSION_THRESHOLD_BYTES_RANGE$p();
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        long l = this.compressionThresholdBytes;
        if (!((long)n <= l ? l <= (long)n2 : false)) {
            boolean bl = false;
            String string = "compressionThresholdBytes (" + this.compressionThresholdBytes + ") must be in the range " + RequestCompressionInterceptorKt.access$getVALID_COMPRESSION_THRESHOLD_BYTES_RANGE$p();
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Nullable
    public Object modifyBeforeRetryLoop(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        void $this$logger$iv;
        HttpRequest httpRequest;
        String algorithm;
        block10: {
            block11: {
                boolean bl;
                Long payloadSizeBytes;
                block9: {
                    String string;
                    payloadSizeBytes = ((HttpRequest)context.getProtocolRequest()).getBody().getContentLength();
                    for (String id : (Iterable)this.supportedCompressionAlgorithms) {
                        Object v0;
                        block8: {
                            boolean bl2 = false;
                            Iterable iterable = this.availableCompressionAlgorithms;
                            for (Object t : iterable) {
                                CompressionAlgorithm it = (CompressionAlgorithm)t;
                                boolean bl3 = false;
                                if (!Intrinsics.areEqual((Object)it.getId(), (Object)id)) continue;
                                v0 = t;
                                break block8;
                            }
                            v0 = null;
                        }
                        if ((id = (CompressionAlgorithm)v0) == null) continue;
                        string = id;
                        break block9;
                    }
                    string = algorithm = null;
                }
                if (algorithm == null) break block10;
                if (this.isStreaming(((HttpRequest)context.getProtocolRequest()).getBody())) break block11;
                Long l = payloadSizeBytes;
                if (l != null) {
                    long it = ((Number)l).longValue();
                    boolean bl4 = false;
                    bl = it >= this.compressionThresholdBytes;
                } else {
                    bl = false;
                }
                if (!bl) break block10;
            }
            httpRequest = CompressRequestKt.compressRequest(algorithm, (HttpRequest)((HttpRequest)context.getProtocolRequest()));
            return httpRequest;
        }
        CoroutineContext it = $completion.getContext();
        boolean $i$f$logger = false;
        String string = Reflection.getOrCreateKotlinClass(RequestCompressionInterceptor.class).getQualifiedName();
        if (string == null) {
            boolean bl = false;
            String string2 = "logger<T> cannot be used on an anonymous object";
            throw new IllegalArgumentException(string2.toString());
        }
        String sourceComponent$iv = string;
        Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
        String skipCause = algorithm == null ? "no modeled compression algorithms are supported by the client" : "request size threshold (" + this.compressionThresholdBytes + ") was not met";
        Logger.DefaultImpls.debug$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(skipCause){
            final /* synthetic */ String $skipCause;
            {
                this.$skipCause = $skipCause;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "skipping request compression because " + this.$skipCause;
            }
        }), (int)1, null);
        httpRequest = (HttpRequest)context.getProtocolRequest();
        return httpRequest;
    }

    private final boolean isStreaming(HttpBody $this$isStreaming) {
        return $this$isStreaming instanceof HttpBody.ChannelContent || $this$isStreaming instanceof HttpBody.SourceContent || $this$isStreaming.getContentLength() == null;
    }

    @Nullable
    public Object modifyBeforeAttemptCompletion-gIAlu-s(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super Result<? extends Object>> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeAttemptCompletion-gIAlu-s((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeCompletion-gIAlu-s(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super Result<? extends Object>> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeCompletion-gIAlu-s((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeDeserialization(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context, @NotNull Continuation<? super HttpResponse> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeDeserialization((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeSerialization(@NotNull RequestInterceptorContext<Object> context, @NotNull Continuation<Object> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeSerialization((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeSigning((Interceptor)this, context, $completion);
    }

    @Nullable
    public Object modifyBeforeTransmit(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context, @NotNull Continuation<? super HttpRequest> $completion) {
        return Interceptor.DefaultImpls.modifyBeforeTransmit((Interceptor)this, context, $completion);
    }

    public void readAfterAttempt(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterAttempt((Interceptor)this, context);
    }

    public void readAfterDeserialization(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterDeserialization((Interceptor)this, context);
    }

    public void readAfterExecution(@NotNull ResponseInterceptorContext<Object, Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterExecution((Interceptor)this, context);
    }

    public void readAfterSerialization(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readAfterSerialization((Interceptor)this, context);
    }

    public void readAfterSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readAfterSigning((Interceptor)this, context);
    }

    public void readAfterTransmit(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readAfterTransmit((Interceptor)this, context);
    }

    public void readBeforeAttempt(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readBeforeAttempt((Interceptor)this, context);
    }

    public void readBeforeDeserialization(@NotNull ProtocolResponseInterceptorContext<Object, HttpRequest, HttpResponse> context) {
        Interceptor.DefaultImpls.readBeforeDeserialization((Interceptor)this, context);
    }

    public void readBeforeExecution(@NotNull RequestInterceptorContext<Object> context) {
        Interceptor.DefaultImpls.readBeforeExecution((Interceptor)this, context);
    }

    public void readBeforeSerialization(@NotNull RequestInterceptorContext<Object> context) {
        Interceptor.DefaultImpls.readBeforeSerialization((Interceptor)this, context);
    }

    public void readBeforeSigning(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readBeforeSigning((Interceptor)this, context);
    }

    public void readBeforeTransmit(@NotNull ProtocolRequestInterceptorContext<Object, HttpRequest> context) {
        Interceptor.DefaultImpls.readBeforeTransmit((Interceptor)this, context);
    }
}

