/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml.deserialization;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.XmlTokenKt;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.ChildXmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.EmptyXmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.LexingXmlStreamReaderKt;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.StringTextStream;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.StringTextStreamKt;
import aws.smithy.kotlin.runtime.serde.xml.deserialization.XmlLexer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0080\b\u00a2\u0006\u0002\b\u0010J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\"\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Laws/smithy/kotlin/runtime/serde/xml/deserialization/LexingXmlStreamReader;", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "source", "Laws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer;", "(Laws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer;)V", "<set-?>", "Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "lastToken", "getLastToken", "()Laws/smithy/kotlin/runtime/serde/xml/XmlToken;", "peekQueue", "Lkotlin/collections/ArrayDeque;", "error", "", "msg", "", "error$serde_xml", "nextToken", "peek", "index", "", "skipNext", "", "subTreeReader", "subtreeStartDepth", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader$SubtreeStartDepth;", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nLexingXmlStreamReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LexingXmlStreamReader.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/LexingXmlStreamReader\n+ 2 XmlLexer.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/XmlLexer\n+ 3 StringTextStream.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/StringTextStream\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,135:1\n50#2:136\n94#3,12:137\n1#4:149\n*S KotlinDebug\n*F\n+ 1 LexingXmlStreamReader.kt\naws/smithy/kotlin/runtime/serde/xml/deserialization/LexingXmlStreamReader\n*L\n27#1:136\n27#1:137,12\n*E\n"})
public final class LexingXmlStreamReader
implements XmlStreamReader {
    @NotNull
    private final XmlLexer source;
    @NotNull
    private final ArrayDeque<XmlToken> peekQueue;
    @Nullable
    private XmlToken lastToken;

    public LexingXmlStreamReader(@NotNull XmlLexer source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.peekQueue = new ArrayDeque();
    }

    @NotNull
    public final Void error$serde_xml(@NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        boolean $i$f$error$serde_xml = false;
        XmlLexer this_$iv = this.source;
        boolean $i$f$error$serde_xml2 = false;
        StringTextStream this_$iv$iv = this_$iv.getSource$serde_xml();
        boolean $i$f$error$serde_xml3 = false;
        int start$iv$iv = Math.max(0, StringTextStream.access$getOffset$p(this_$iv$iv) - 3);
        int end$iv$iv = Math.min(StringTextStream.access$getEnd$p(this_$iv$iv) - 1, StringTextStream.access$getOffset$p(this_$iv$iv) + 3);
        String string = StringTextStream.access$getSource$p(this_$iv$iv).substring(start$iv$iv, end$iv$iv + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        CharSequence charSequence = string;
        Regex regex = StringTextStreamKt.access$getNonAscii$p();
        String string2 = "\u00b7";
        String snippet$iv$iv = regex.replace(charSequence, string2);
        int caretPos$iv$iv = StringTextStream.access$getOffset$p(this_$iv$iv) - start$iv$iv;
        String caret$iv$iv = StringsKt.repeat((CharSequence)" ", (int)caretPos$iv$iv) + '^';
        String locationMultilineString$iv$iv = "At offset " + StringTextStream.access$getOffset$p(this_$iv$iv) + " (showing range " + start$iv$iv + '-' + end$iv$iv + "):\n" + snippet$iv$iv + '\n' + caret$iv$iv;
        String fullMsg$iv$iv = msg + '\n' + locationMultilineString$iv$iv;
        throw new DeserializationException(fullMsg$iv$iv);
    }

    @Override
    @Nullable
    public XmlToken getLastToken() {
        return this.lastToken;
    }

    @Override
    @Nullable
    public XmlToken nextToken() {
        XmlToken xmlToken;
        XmlToken xmlToken2 = (XmlToken)this.peekQueue.removeFirstOrNull();
        if (xmlToken2 == null) {
            xmlToken2 = this.source.parseNext();
        }
        XmlToken it = xmlToken = xmlToken2;
        boolean bl = false;
        this.lastToken = it;
        return xmlToken;
    }

    @Override
    @Nullable
    public XmlToken peek(int index) {
        while (index > this.peekQueue.size() && !this.source.getEndOfDocument()) {
            XmlToken xmlToken = this.source.parseNext();
            Intrinsics.checkNotNull((Object)xmlToken);
            this.peekQueue.addLast((Object)xmlToken);
        }
        return (XmlToken)LexingXmlStreamReaderKt.access$getOrNull((List)this.peekQueue, index - 1);
    }

    @Override
    public void skipNext() {
        XmlToken xmlToken = this.peek(1);
        if (xmlToken == null) {
            return;
        }
        XmlToken peekToken = xmlToken;
        int startDepth = peekToken.getDepth();
        LexingXmlStreamReader.skipNext$scanUntilDepth(startDepth, this, this.nextToken());
    }

    @Override
    @NotNull
    public XmlStreamReader subTreeReader(@NotNull XmlStreamReader.SubtreeStartDepth subtreeStartDepth) {
        XmlStreamReader xmlStreamReader;
        Intrinsics.checkNotNullParameter((Object)((Object)subtreeStartDepth), (String)"subtreeStartDepth");
        if (XmlTokenKt.terminates(this.peek(1), this.getLastToken())) {
            this.nextToken();
            xmlStreamReader = new EmptyXmlStreamReader(this);
        } else {
            xmlStreamReader = new ChildXmlStreamReader(this, subtreeStartDepth);
        }
        return xmlStreamReader;
    }

    private static final void skipNext$scanUntilDepth(int startDepth, LexingXmlStreamReader this$0, XmlToken from) {
        while (from != null && !(from instanceof XmlToken.EndDocument)) {
            if (from instanceof XmlToken.EndElement && ((XmlToken.EndElement)from).getDepth() == startDepth) {
                return;
            }
            from = this$0.nextToken();
        }
        return;
    }
}

