/*
 * Decompiled with CFR 0.152.
 */
package aws.smithy.kotlin.runtime.serde.xml.dom;

import aws.smithy.kotlin.runtime.InternalApi;
import aws.smithy.kotlin.runtime.collections.StackKt;
import aws.smithy.kotlin.runtime.serde.DeserializationException;
import aws.smithy.kotlin.runtime.serde.xml.XmlStreamReader;
import aws.smithy.kotlin.runtime.serde.xml.XmlToken;
import aws.smithy.kotlin.runtime.serde.xml.dom.XmlNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u001a,\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rH\u0007\u001a\u0016\u0010\u000e\u001a\u00020\u000f*\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u0010"}, d2={"formatXmlNode", "", "curr", "Laws/smithy/kotlin/runtime/serde/xml/dom/XmlNode;", "depth", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pretty", "", "parseDom", "reader", "Laws/smithy/kotlin/runtime/serde/xml/XmlStreamReader;", "toXmlString", "", "serde-xml"})
@SourceDebugExtension(value={"SMAP\nXmlNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlNode.kt\naws/smithy/kotlin/runtime/serde/xml/dom/XmlNodeKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,164:1\n1#2:165\n1855#3,2:166\n1855#3,2:171\n215#4,2:168\n215#4:170\n216#4:173\n*S KotlinDebug\n*F\n+ 1 XmlNode.kt\naws/smithy/kotlin/runtime/serde/xml/dom/XmlNodeKt\n*L\n125#1:166,2\n147#1:171,2\n136#1:168,2\n146#1:170\n146#1:173\n*E\n"})
public final class XmlNodeKt {
    @InternalApi
    @NotNull
    public static final XmlNode parseDom(@NotNull XmlStreamReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        List nodeStack = new ArrayList();
        while (true) {
            XmlNode curr;
            XmlToken token;
            if ((token = reader.nextToken()) instanceof XmlToken.BeginElement) {
                XmlNode newNode = XmlNode.Companion.fromToken$serde_xml((XmlToken.BeginElement)token);
                if (!((Collection)nodeStack).isEmpty()) {
                    XmlNode curr2 = (XmlNode)StackKt.top((List)nodeStack);
                    curr2.addChild(newNode);
                    newNode.setParent(curr2);
                }
                StackKt.push((List)nodeStack, (Object)newNode);
                continue;
            }
            if (token instanceof XmlToken.EndElement) {
                curr = (XmlNode)StackKt.top((List)nodeStack);
                if (!Intrinsics.areEqual((Object)curr.getName(), (Object)((XmlToken.EndElement)token).getName())) {
                    throw new DeserializationException("expected end of element: `" + curr.getName() + "`, found: `" + ((XmlToken.EndElement)token).getName() + '`');
                }
                if (((Collection)nodeStack).size() <= 1) continue;
                StackKt.pop((List)nodeStack);
                continue;
            }
            if (token instanceof XmlToken.Text) {
                curr = (XmlNode)StackKt.top((List)nodeStack);
                curr.setText(((XmlToken.Text)token).getValue());
                continue;
            }
            if (token == null ? true : token instanceof XmlToken.EndDocument) break;
        }
        if (!(((Collection)nodeStack).size() == 1)) {
            boolean bl = false;
            String string = "invalid XML document, node stack size > 1";
            throw new IllegalStateException(string.toString());
        }
        return (XmlNode)StackKt.pop((List)nodeStack);
    }

    @InternalApi
    @NotNull
    public static final String toXmlString(@NotNull XmlNode $this$toXmlString, boolean pretty) {
        Intrinsics.checkNotNullParameter((Object)$this$toXmlString, (String)"<this>");
        StringBuilder sb = new StringBuilder();
        XmlNodeKt.formatXmlNode($this$toXmlString, 0, sb, pretty);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String toXmlString$default(XmlNode xmlNode, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return XmlNodeKt.toXmlString(xmlNode, bl);
    }

    public static final void formatXmlNode(@NotNull XmlNode curr, int depth, @NotNull StringBuilder sb, boolean pretty) {
        Object it;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)curr, (String)"curr");
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        StringBuilder $this$formatXmlNode_u24lambda_u245 = stringBuilder = sb;
        boolean bl = false;
        String indent = pretty ? StringsKt.repeat((CharSequence)" ", (int)(depth * 4)) : "";
        $this$formatXmlNode_u24lambda_u245.append(indent + '<');
        $this$formatXmlNode_u24lambda_u245.append(curr.getName().toString());
        Map<String, List<XmlNode>> $this$forEach$iv = curr.getNamespaces();
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object t = iterator.next();
            it = (XmlToken.Namespace)t;
            boolean bl2 = false;
            $this$formatXmlNode_u24lambda_u245.append(" xmlns");
            if (((XmlToken.Namespace)it).getPrefix() != null) {
                $this$formatXmlNode_u24lambda_u245.append(':' + ((XmlToken.Namespace)it).getPrefix());
            }
            $this$formatXmlNode_u24lambda_u245.append("=\"" + ((XmlToken.Namespace)it).getUri() + '\"');
        }
        if (!curr.getAttributes().isEmpty()) {
            $this$formatXmlNode_u24lambda_u245.append(" ");
        }
        $this$forEach$iv = curr.getAttributes();
        $i$f$forEach = false;
        for (Map.Entry entry2 : $this$forEach$iv.entrySet()) {
            it = entry2;
            boolean bl3 = false;
            $this$formatXmlNode_u24lambda_u245.append(it.getKey() + "=\"" + (String)it.getValue() + '\"');
        }
        $this$formatXmlNode_u24lambda_u245.append(">");
        if (curr.getText() != null) {
            $this$formatXmlNode_u24lambda_u245.append(curr.getText());
        }
        if (pretty && !curr.getChildren().isEmpty()) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$formatXmlNode_u24lambda_u245.append('\n'), (String)"append(...)");
        }
        $this$forEach$iv = curr.getChildren();
        $i$f$forEach = false;
        for (Map.Entry entry3 : $this$forEach$iv.entrySet()) {
            it = entry3;
            boolean bl4 = false;
            Iterable $this$forEach$iv2 = (Iterable)it.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                XmlNode child = (XmlNode)element$iv2;
                boolean bl5 = false;
                XmlNodeKt.formatXmlNode(child, depth + 1, sb, pretty);
            }
        }
        if (!curr.getChildren().isEmpty()) {
            $this$formatXmlNode_u24lambda_u245.append(indent);
        }
        $this$formatXmlNode_u24lambda_u245.append("</");
        $this$formatXmlNode_u24lambda_u245.append(curr.getName().toString());
        $this$formatXmlNode_u24lambda_u245.append(">");
        if (pretty && depth > 0) {
            Intrinsics.checkNotNullExpressionValue((Object)$this$formatXmlNode_u24lambda_u245.append('\n'), (String)"append(...)");
        }
    }
}

