/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.accessanalyzer.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.accessanalyzer.model.AnalyzerSummary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListAnalyzersResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<AnalyzerSummary> analyzers;
    private String nextToken;

    public List<AnalyzerSummary> getAnalyzers() {
        return this.analyzers;
    }

    public void setAnalyzers(Collection<AnalyzerSummary> analyzers) {
        if (analyzers == null) {
            this.analyzers = null;
            return;
        }
        this.analyzers = new ArrayList<AnalyzerSummary>(analyzers);
    }

    public ListAnalyzersResult withAnalyzers(AnalyzerSummary ... analyzers) {
        if (this.analyzers == null) {
            this.setAnalyzers(new ArrayList<AnalyzerSummary>(analyzers.length));
        }
        for (AnalyzerSummary ele : analyzers) {
            this.analyzers.add(ele);
        }
        return this;
    }

    public ListAnalyzersResult withAnalyzers(Collection<AnalyzerSummary> analyzers) {
        this.setAnalyzers(analyzers);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListAnalyzersResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAnalyzers() != null) {
            sb.append("Analyzers: ").append(this.getAnalyzers()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalyzersResult)) {
            return false;
        }
        ListAnalyzersResult other = (ListAnalyzersResult)obj;
        if (other.getAnalyzers() == null ^ this.getAnalyzers() == null) {
            return false;
        }
        if (other.getAnalyzers() != null && !other.getAnalyzers().equals(this.getAnalyzers())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAnalyzers() == null ? 0 : this.getAnalyzers().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListAnalyzersResult clone() {
        try {
            return (ListAnalyzersResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

