/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.signer;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.signer.AWSsignerAsync;
import com.amazonaws.services.signer.AWSsignerAsyncClientBuilder;
import com.amazonaws.services.signer.AWSsignerClient;
import com.amazonaws.services.signer.model.CancelSigningProfileRequest;
import com.amazonaws.services.signer.model.CancelSigningProfileResult;
import com.amazonaws.services.signer.model.DescribeSigningJobRequest;
import com.amazonaws.services.signer.model.DescribeSigningJobResult;
import com.amazonaws.services.signer.model.GetSigningPlatformRequest;
import com.amazonaws.services.signer.model.GetSigningPlatformResult;
import com.amazonaws.services.signer.model.GetSigningProfileRequest;
import com.amazonaws.services.signer.model.GetSigningProfileResult;
import com.amazonaws.services.signer.model.ListSigningJobsRequest;
import com.amazonaws.services.signer.model.ListSigningJobsResult;
import com.amazonaws.services.signer.model.ListSigningPlatformsRequest;
import com.amazonaws.services.signer.model.ListSigningPlatformsResult;
import com.amazonaws.services.signer.model.ListSigningProfilesRequest;
import com.amazonaws.services.signer.model.ListSigningProfilesResult;
import com.amazonaws.services.signer.model.PutSigningProfileRequest;
import com.amazonaws.services.signer.model.PutSigningProfileResult;
import com.amazonaws.services.signer.model.StartSigningJobRequest;
import com.amazonaws.services.signer.model.StartSigningJobResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSsignerAsyncClient
extends AWSsignerClient
implements AWSsignerAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSsignerAsyncClientBuilder asyncBuilder() {
        return AWSsignerAsyncClientBuilder.standard();
    }

    AWSsignerAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<CancelSigningProfileResult> cancelSigningProfileAsync(CancelSigningProfileRequest request) {
        return this.cancelSigningProfileAsync(request, null);
    }

    @Override
    public Future<CancelSigningProfileResult> cancelSigningProfileAsync(CancelSigningProfileRequest request, final AsyncHandler<CancelSigningProfileRequest, CancelSigningProfileResult> asyncHandler) {
        final CancelSigningProfileRequest finalRequest = (CancelSigningProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CancelSigningProfileResult>(){

            @Override
            public CancelSigningProfileResult call() throws Exception {
                CancelSigningProfileResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeCancelSigningProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSigningJobResult> describeSigningJobAsync(DescribeSigningJobRequest request) {
        return this.describeSigningJobAsync(request, null);
    }

    @Override
    public Future<DescribeSigningJobResult> describeSigningJobAsync(DescribeSigningJobRequest request, final AsyncHandler<DescribeSigningJobRequest, DescribeSigningJobResult> asyncHandler) {
        final DescribeSigningJobRequest finalRequest = (DescribeSigningJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSigningJobResult>(){

            @Override
            public DescribeSigningJobResult call() throws Exception {
                DescribeSigningJobResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeDescribeSigningJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSigningPlatformResult> getSigningPlatformAsync(GetSigningPlatformRequest request) {
        return this.getSigningPlatformAsync(request, null);
    }

    @Override
    public Future<GetSigningPlatformResult> getSigningPlatformAsync(GetSigningPlatformRequest request, final AsyncHandler<GetSigningPlatformRequest, GetSigningPlatformResult> asyncHandler) {
        final GetSigningPlatformRequest finalRequest = (GetSigningPlatformRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSigningPlatformResult>(){

            @Override
            public GetSigningPlatformResult call() throws Exception {
                GetSigningPlatformResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeGetSigningPlatform(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetSigningProfileResult> getSigningProfileAsync(GetSigningProfileRequest request) {
        return this.getSigningProfileAsync(request, null);
    }

    @Override
    public Future<GetSigningProfileResult> getSigningProfileAsync(GetSigningProfileRequest request, final AsyncHandler<GetSigningProfileRequest, GetSigningProfileResult> asyncHandler) {
        final GetSigningProfileRequest finalRequest = (GetSigningProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetSigningProfileResult>(){

            @Override
            public GetSigningProfileResult call() throws Exception {
                GetSigningProfileResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeGetSigningProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSigningJobsResult> listSigningJobsAsync(ListSigningJobsRequest request) {
        return this.listSigningJobsAsync(request, null);
    }

    @Override
    public Future<ListSigningJobsResult> listSigningJobsAsync(ListSigningJobsRequest request, final AsyncHandler<ListSigningJobsRequest, ListSigningJobsResult> asyncHandler) {
        final ListSigningJobsRequest finalRequest = (ListSigningJobsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSigningJobsResult>(){

            @Override
            public ListSigningJobsResult call() throws Exception {
                ListSigningJobsResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeListSigningJobs(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSigningPlatformsResult> listSigningPlatformsAsync(ListSigningPlatformsRequest request) {
        return this.listSigningPlatformsAsync(request, null);
    }

    @Override
    public Future<ListSigningPlatformsResult> listSigningPlatformsAsync(ListSigningPlatformsRequest request, final AsyncHandler<ListSigningPlatformsRequest, ListSigningPlatformsResult> asyncHandler) {
        final ListSigningPlatformsRequest finalRequest = (ListSigningPlatformsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSigningPlatformsResult>(){

            @Override
            public ListSigningPlatformsResult call() throws Exception {
                ListSigningPlatformsResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeListSigningPlatforms(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListSigningProfilesResult> listSigningProfilesAsync(ListSigningProfilesRequest request) {
        return this.listSigningProfilesAsync(request, null);
    }

    @Override
    public Future<ListSigningProfilesResult> listSigningProfilesAsync(ListSigningProfilesRequest request, final AsyncHandler<ListSigningProfilesRequest, ListSigningProfilesResult> asyncHandler) {
        final ListSigningProfilesRequest finalRequest = (ListSigningProfilesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListSigningProfilesResult>(){

            @Override
            public ListSigningProfilesResult call() throws Exception {
                ListSigningProfilesResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeListSigningProfiles(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutSigningProfileResult> putSigningProfileAsync(PutSigningProfileRequest request) {
        return this.putSigningProfileAsync(request, null);
    }

    @Override
    public Future<PutSigningProfileResult> putSigningProfileAsync(PutSigningProfileRequest request, final AsyncHandler<PutSigningProfileRequest, PutSigningProfileResult> asyncHandler) {
        final PutSigningProfileRequest finalRequest = (PutSigningProfileRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutSigningProfileResult>(){

            @Override
            public PutSigningProfileResult call() throws Exception {
                PutSigningProfileResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executePutSigningProfile(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartSigningJobResult> startSigningJobAsync(StartSigningJobRequest request) {
        return this.startSigningJobAsync(request, null);
    }

    @Override
    public Future<StartSigningJobResult> startSigningJobAsync(StartSigningJobRequest request, final AsyncHandler<StartSigningJobRequest, StartSigningJobResult> asyncHandler) {
        final StartSigningJobRequest finalRequest = (StartSigningJobRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartSigningJobResult>(){

            @Override
            public StartSigningJobResult call() throws Exception {
                StartSigningJobResult result = null;
                try {
                    result = AWSsignerAsyncClient.this.executeStartSigningJob(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

