/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.bootstrap.ContextStore;
import datadog.trace.bootstrap.WeakMap;

final class WeakMapContextStore
implements ContextStore<Object, Object> {
    private static final int MAX_SIZE = 50000;
    private final WeakMap<Object, Object> map = WeakMap.Provider.newWeakMap();

    WeakMapContextStore() {
    }

    @Override
    public Object get(Object key) {
        return this.map.get(key);
    }

    @Override
    public void put(Object key, Object context) {
        if (this.map.size() < 50000) {
            this.map.put(key, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putIfAbsent(Object key, Object context) {
        Object existingContext = this.map.get(key);
        if (null == existingContext) {
            WeakMap<Object, Object> weakMap = this.map;
            synchronized (weakMap) {
                existingContext = this.map.get(key);
                if (null == existingContext) {
                    existingContext = context;
                    this.put(key, existingContext);
                }
            }
        }
        return existingContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object putIfAbsent(Object key, ContextStore.Factory<Object> contextFactory) {
        Object existingContext = this.map.get(key);
        if (null == existingContext) {
            WeakMap<Object, Object> weakMap = this.map;
            synchronized (weakMap) {
                existingContext = this.map.get(key);
                if (null == existingContext) {
                    existingContext = contextFactory.create();
                    this.put(key, existingContext);
                }
            }
        }
        return existingContext;
    }
}

