/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;

class AppVeyorInfo
extends CIProviderInfo {
    public static final String APPVEYOR = "APPVEYOR";
    public static final String APPVEYOR_PROVIDER_NAME = "appveyor";
    public static final String APPVEYOR_BUILD_ID = "APPVEYOR_BUILD_ID";
    public static final String APPVEYOR_REPO_NAME = "APPVEYOR_REPO_NAME";
    public static final String APPVEYOR_PIPELINE_NUMBER = "APPVEYOR_BUILD_NUMBER";
    public static final String APPVEYOR_WORKSPACE_PATH = "APPVEYOR_BUILD_FOLDER";
    public static final String APPVEYOR_REPO_PROVIDER = "APPVEYOR_REPO_PROVIDER";
    public static final String APPVEYOR_REPO_COMMIT = "APPVEYOR_REPO_COMMIT";
    public static final String APPVEYOR_REPO_BRANCH = "APPVEYOR_REPO_BRANCH";
    public static final String APPVEYOR_PULL_REQUEST_HEAD_REPO_BRANCH = "APPVEYOR_PULL_REQUEST_HEAD_REPO_BRANCH";
    public static final String APPVEYOR_REPO_TAG_NAME = "APPVEYOR_REPO_TAG_NAME";

    AppVeyorInfo() {
        String buildId = System.getenv(APPVEYOR_BUILD_ID);
        String repoName = System.getenv(APPVEYOR_REPO_NAME);
        String url = this.buildPipelineUrl(repoName, buildId);
        String repoProvider = System.getenv(APPVEYOR_REPO_PROVIDER);
        String tag = this.buildGitTag(repoProvider);
        this.ciTags = new CIProviderInfo.CITagsBuilder().withCiProviderName(APPVEYOR_PROVIDER_NAME).withCiPipelineId(buildId).withCiPipelineName(repoName).withCiPipelineNumber(System.getenv(APPVEYOR_PIPELINE_NUMBER)).withCiPipelineUrl(url).withCiJorUrl(url).withCiWorkspacePath(this.expandTilde(System.getenv(APPVEYOR_WORKSPACE_PATH))).withGitRepositoryUrl(this.buildGitRepositoryUrl(repoProvider, repoName)).withGitCommit(this.buildGitCommit(repoProvider)).withGitBranch(this.buildGitBranch(repoProvider, tag)).withGitTag(tag).build();
    }

    private String buildGitTag(String repoProvider) {
        if ("github".equals(repoProvider)) {
            return this.normalizeRef(System.getenv(APPVEYOR_REPO_TAG_NAME));
        }
        return null;
    }

    private String buildGitBranch(String repoProvider, String gitTag) {
        if (gitTag != null) {
            return null;
        }
        if ("github".equals(repoProvider)) {
            String branch = System.getenv(APPVEYOR_PULL_REQUEST_HEAD_REPO_BRANCH);
            if (branch == null || branch.isEmpty()) {
                branch = System.getenv(APPVEYOR_REPO_BRANCH);
            }
            return this.normalizeRef(branch);
        }
        return null;
    }

    private String buildGitCommit(String repoProvider) {
        if ("github".equals(repoProvider)) {
            return System.getenv(APPVEYOR_REPO_COMMIT);
        }
        return null;
    }

    private String buildGitRepositoryUrl(String repoProvider, String repoName) {
        if ("github".equals(repoProvider)) {
            return String.format("https://github.com/%s.git", repoName);
        }
        return null;
    }

    private String buildPipelineUrl(String repoName, String buildId) {
        return String.format("https://ci.appveyor.com/project/%s/builds/%s", repoName, buildId);
    }
}

