/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api.ci;

import datadog.trace.bootstrap.instrumentation.api.ci.CIProviderInfo;

class TravisInfo
extends CIProviderInfo {
    public static final String TRAVIS = "TRAVIS";
    public static final String TRAVIS_PROVIDER_NAME = "travisci";
    public static final String TRAVIS_PIPELINE_ID = "TRAVIS_BUILD_ID";
    public static final String TRAVIS_PIPELINE_NUMBER = "TRAVIS_BUILD_NUMBER";
    public static final String TRAVIS_PIPELINE_URL = "TRAVIS_BUILD_WEB_URL";
    public static final String TRAVIS_JOB_URL = "TRAVIS_JOB_WEB_URL";
    public static final String TRAVIS_WORKSPACE_PATH = "TRAVIS_BUILD_DIR";
    public static final String TRAVIS_REPOSITORY_SLUG = "TRAVIS_REPO_SLUG";
    public static final String TRAVIS_PR_REPOSITORY_SLUG = "TRAVIS_PULL_REQUEST_SLUG";
    public static final String TRAVIS_GIT_COMMIT = "TRAVIS_COMMIT";
    public static final String TRAVIS_GIT_PR_BRANCH = "TRAVIS_PULL_REQUEST_BRANCH";
    public static final String TRAVIS_GIT_BRANCH = "TRAVIS_BRANCH";
    public static final String TRAVIS_GIT_TAG = "TRAVIS_TAG";

    TravisInfo() {
        String gitTag = this.normalizeRef(System.getenv(TRAVIS_GIT_TAG));
        this.ciTags = new CIProviderInfo.CITagsBuilder().withCiProviderName(TRAVIS_PROVIDER_NAME).withCiPipelineId(System.getenv(TRAVIS_PIPELINE_ID)).withCiPipelineName(this.buildCiPipelineName()).withCiPipelineNumber(System.getenv(TRAVIS_PIPELINE_NUMBER)).withCiPipelineUrl(System.getenv(TRAVIS_PIPELINE_URL)).withCiJorUrl(System.getenv(TRAVIS_JOB_URL)).withCiWorkspacePath(this.expandTilde(System.getenv(TRAVIS_WORKSPACE_PATH))).withGitRepositoryUrl(this.buildGitRepositoryUrl()).withGitCommit(System.getenv(TRAVIS_GIT_COMMIT)).withGitBranch(this.buildGitBranch(gitTag)).withGitTag(gitTag).build();
    }

    private String buildGitBranch(String gitTag) {
        if (gitTag != null) {
            return null;
        }
        String fromBranch = System.getenv(TRAVIS_GIT_PR_BRANCH);
        if (fromBranch != null && !fromBranch.isEmpty()) {
            return this.normalizeRef(fromBranch);
        }
        return this.normalizeRef(System.getenv(TRAVIS_GIT_BRANCH));
    }

    private String buildGitRepositoryUrl() {
        String repoSlug = System.getenv(TRAVIS_PR_REPOSITORY_SLUG);
        if (repoSlug == null || repoSlug.isEmpty()) {
            repoSlug = System.getenv(TRAVIS_REPOSITORY_SLUG);
        }
        return String.format("https://github.com/%s.git", repoSlug);
    }

    private String buildCiPipelineName() {
        String repoSlug = System.getenv(TRAVIS_PR_REPOSITORY_SLUG);
        if (repoSlug == null || repoSlug.isEmpty()) {
            repoSlug = System.getenv(TRAVIS_REPOSITORY_SLUG);
        }
        return repoSlug;
    }
}

