/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.decorator;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Config;
import datadog.trace.api.cache.RadixTreeCache;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.InternalSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.URIDataAdapter;
import datadog.trace.bootstrap.instrumentation.decorator.ServerDecorator;
import java.util.BitSet;
import java.util.regex.Pattern;

public abstract class HttpServerDecorator<REQUEST, CONNECTION, RESPONSE>
extends ServerDecorator {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDecorator.class);
    public static final String DD_SPAN_ATTRIBUTE = "datadog.span";
    public static final String DD_DISPATCH_SPAN_ATTRIBUTE = "datadog.span.dispatch";
    public static final String DD_RESPONSE_ATTRIBUTE = "datadog.response";
    private static final Pattern VALID_IPV4_ADDRESS = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    private static final BitSet SERVER_ERROR_STATUSES = Config.get().getHttpServerErrorStatuses();

    protected abstract String method(REQUEST var1);

    protected abstract URIDataAdapter url(REQUEST var1);

    protected abstract String peerHostIP(CONNECTION var1);

    protected abstract int peerPort(CONNECTION var1);

    protected abstract int status(RESPONSE var1);

    @Override
    protected CharSequence spanType() {
        return InternalSpanTypes.HTTP_SERVER;
    }

    @Override
    protected boolean traceAnalyticsDefault() {
        return Config.get().isTraceAnalyticsEnabled();
    }

    public AgentSpan onRequest(AgentSpan span, REQUEST request) {
        if (request != null) {
            span.setTag("http.method", this.method(request));
            try {
                URIDataAdapter url = this.url(request);
                if (url != null) {
                    String path;
                    String host;
                    StringBuilder urlNoParams = new StringBuilder();
                    String scheme = url.scheme();
                    if (scheme != null) {
                        urlNoParams.append(scheme);
                        urlNoParams.append("://");
                    }
                    if ((host = url.host()) != null) {
                        urlNoParams.append(host);
                        int port = url.port();
                        if (port > 0 && port != 80 && port != 443) {
                            urlNoParams.append(":");
                            urlNoParams.append(port);
                        }
                    }
                    if (null == (path = url.path()) || path.isEmpty()) {
                        urlNoParams.append("/");
                    } else {
                        if (!path.startsWith("/")) {
                            urlNoParams.append("/");
                        }
                        urlNoParams.append(path);
                    }
                    span.setTag("http.url", urlNoParams.toString());
                    if (Config.get().isHttpServerTagQueryString()) {
                        span.setTag("http.query.string", url.query());
                        span.setTag("http.fragment.string", url.fragment());
                    }
                }
            }
            catch (Exception e) {
                log.debug("Error tagging url", e);
            }
        }
        return span;
    }

    public AgentSpan onConnection(AgentSpan span, CONNECTION connection) {
        if (connection != null) {
            String ip = this.peerHostIP(connection);
            if (ip != null) {
                if (VALID_IPV4_ADDRESS.matcher(ip).matches()) {
                    span.setTag("peer.ipv4", ip);
                } else if (ip.contains(":")) {
                    span.setTag("peer.ipv6", ip);
                }
            }
            this.setPeerPort(span, this.peerPort(connection));
        }
        return span;
    }

    public AgentSpan onResponse(AgentSpan span, RESPONSE response) {
        if (response != null) {
            int status = this.status(response);
            if (status > 0) {
                span.setTag("http.status_code", RadixTreeCache.HTTP_STATUSES.get(status));
            }
            if (SERVER_ERROR_STATUSES.get(status)) {
                span.setError(true);
            }
        }
        return span;
    }
}

