/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.context.TraceScope;

public final class ComparableRunnable<T extends Runnable & Comparable<T>>
implements Runnable,
Comparable<ComparableRunnable<T>> {
    private final T delegate;
    private final TraceScope.Continuation continuation;

    public ComparableRunnable(T delegate) {
        this.delegate = delegate;
        TraceScope.Continuation continuation = null;
        TraceScope scope = AgentTracer.activeScope();
        if (null != scope) {
            continuation = scope.capture();
        }
        this.continuation = continuation;
    }

    @Override
    public int compareTo(ComparableRunnable<T> o) {
        return ((Comparable)this.delegate).compareTo(o.delegate);
    }

    @Override
    public void run() {
        try (TraceScope scope = this.activate();){
            this.delegate.run();
        }
    }

    private TraceScope activate() {
        return null == this.continuation ? null : this.continuation.activate();
    }
}

