/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.java.concurrent;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.bootstrap.ContextStore;
import datadog.trace.context.TraceScope;
import java.util.concurrent.atomic.AtomicReference;

public final class State {
    private static final Logger log = LoggerFactory.getLogger(State.class);
    public static ContextStore.Factory<State> FACTORY = new ContextStore.Factory<State>(){

        @Override
        public State create() {
            return new State();
        }
    };
    private static final TraceScope.Continuation CLAIMED = new ContinuationClaim();
    private final AtomicReference<TraceScope.Continuation> continuationRef = new AtomicReference<Object>(null);

    private State() {
    }

    public boolean captureAndSetContinuation(TraceScope scope) {
        if (this.continuationRef.compareAndSet(null, CLAIMED)) {
            this.continuationRef.lazySet(scope.capture());
            return true;
        }
        return false;
    }

    public boolean setOrCancelContinuation(TraceScope.Continuation continuation) {
        if (this.continuationRef.compareAndSet(null, CLAIMED)) {
            this.continuationRef.lazySet(continuation);
            return true;
        }
        continuation.cancel();
        return false;
    }

    public void closeContinuation() {
        TraceScope.Continuation continuation = this.getAndResetContinuation();
        if (null != continuation) {
            continuation.cancel();
        }
    }

    public TraceScope.Continuation getAndResetContinuation() {
        TraceScope.Continuation continuation = this.continuationRef.get();
        if (null == continuation || CLAIMED == continuation) {
            return null;
        }
        this.continuationRef.compareAndSet(continuation, null);
        return continuation;
    }

    private static final class ContinuationClaim
    implements TraceScope.Continuation {
        private ContinuationClaim() {
        }

        @Override
        public TraceScope activate() {
            throw new IllegalStateException();
        }

        @Override
        public void cancel() {
            throw new IllegalStateException();
        }
    }
}

