/*
 * Decompiled with CFR 0.152.
 */
package com.github.jknack.handlebars.internal;

import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Parser;
import com.github.jknack.handlebars.ParserFactory;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.internal.HbsErrorReporter;
import com.github.jknack.handlebars.internal.HbsErrorStrategy;
import com.github.jknack.handlebars.internal.HbsLexer;
import com.github.jknack.handlebars.internal.HbsParser;
import com.github.jknack.handlebars.internal.SpaceTrimmer;
import com.github.jknack.handlebars.internal.TemplateBuilder;
import com.github.jknack.handlebars.io.TemplateSource;
import java.io.IOException;
import java.io.Reader;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.LexerNoViableAltException;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Interval;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HbsParserFactory
implements ParserFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public Parser create(final Handlebars handlebars, final String startDelimiter, final String endDelimiter) {
        return new Parser(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Template parse(TemplateSource source) throws IOException {
                Reader reader = null;
                try {
                    Template template;
                    HbsParserFactory.this.logger.debug("About to parse: {}", (Object)source);
                    final HbsErrorReporter errorReporter = new HbsErrorReporter(source.filename());
                    reader = source.reader();
                    HbsLexer lexer = HbsParserFactory.this.newLexer(HbsParserFactory.this.newStream(source.filename(), reader), startDelimiter, endDelimiter);
                    HbsParserFactory.this.configure((Recognizer)lexer, errorReporter);
                    final HbsParser parser = HbsParserFactory.this.newParser(lexer);
                    HbsParserFactory.this.configure(parser, errorReporter);
                    HbsParserFactory.this.logger.debug("Building AST");
                    HbsParser.TemplateContext tree = parser.template();
                    if (handlebars.prettyPrint()) {
                        HbsParserFactory.this.logger.debug("Applying Mustache spec");
                        new ParseTreeWalker().walk((ParseTreeListener)new SpaceTrimmer(), (ParseTree)tree);
                    }
                    TemplateBuilder builder = new TemplateBuilder(handlebars, source){

                        @Override
                        protected void reportError(CommonToken offendingToken, int line, int column, String message) {
                            errorReporter.syntaxError((Recognizer)parser, (Object)offendingToken, line, column, message, null);
                        }
                    };
                    HbsParserFactory.this.logger.debug("Creating templates");
                    Template template2 = template = builder.visit((ParseTree)tree);
                    return template2;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
        };
    }

    private ANTLRInputStream newStream(String filename, Reader reader) throws IOException {
        ANTLRInputStream stream = new ANTLRInputStream(reader);
        stream.name = filename;
        return stream;
    }

    private HbsLexer newLexer(ANTLRInputStream stream, String startDelimiter, String endDelimiter) {
        return new HbsLexer((CharStream)stream, startDelimiter, endDelimiter){

            public void notifyListeners(LexerNoViableAltException e) {
                String text = this._input.getText(Interval.of((int)this._tokenStartCharIndex, (int)this._input.index()));
                String msg = "found: '" + this.getErrorDisplay(text) + "'";
                ANTLRErrorListener listener = this.getErrorListenerDispatch();
                listener.syntaxError((Recognizer)this, null, this._tokenStartLine, this._tokenStartCharPositionInLine, msg, (RecognitionException)e);
            }

            public void recover(LexerNoViableAltException e) {
                throw new IllegalArgumentException((Throwable)e);
            }
        };
    }

    private HbsParser newParser(final HbsLexer lexer) {
        return new HbsParser((TokenStream)new CommonTokenStream((TokenSource)lexer)){

            @Override
            void setStart(String start) {
                lexer.start = start;
            }

            @Override
            void setEnd(String end) {
                lexer.end = end;
            }
        };
    }

    private void configure(HbsParser parser, ANTLRErrorListener errorReporter) {
        this.configure((Recognizer<?, ?>)parser, errorReporter);
        parser.setErrorHandler((ANTLRErrorStrategy)new HbsErrorStrategy());
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
    }

    private void configure(Recognizer<?, ?> recognizer, ANTLRErrorListener errorReporter) {
        recognizer.removeErrorListeners();
        recognizer.addErrorListener(errorReporter);
    }
}

