

package com.google.javascript.jscomp.serialization;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.colors.ColorRegistry;
import com.google.javascript.rhino.Node;
import java.util.function.Supplier;
import javax.annotation.processing.Generated;
import org.jspecify.nullness.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_TypedAstDeserializer_DeserializedAst extends TypedAstDeserializer.DeserializedAst {

  private final ImmutableMap<SourceFile, Supplier<Node>> filesystem;
  private final Optional<ColorRegistry> colorRegistry;
  private final @Nullable ImmutableSet<String> externProperties;

  AutoValue_TypedAstDeserializer_DeserializedAst(
      ImmutableMap<SourceFile, Supplier<Node>> filesystem,
      Optional<ColorRegistry> colorRegistry,
       @Nullable ImmutableSet<String> externProperties) {
    if (filesystem == null) {
      throw new NullPointerException("Null filesystem");
    }
    this.filesystem = filesystem;
    if (colorRegistry == null) {
      throw new NullPointerException("Null colorRegistry");
    }
    this.colorRegistry = colorRegistry;
    this.externProperties = externProperties;
  }

  @Override
  public ImmutableMap<SourceFile, Supplier<Node>> getFilesystem() {
    return filesystem;
  }

  @Override
  public Optional<ColorRegistry> getColorRegistry() {
    return colorRegistry;
  }

  @Override
  public @Nullable ImmutableSet<String> getExternProperties() {
    return externProperties;
  }

  @Override
  public String toString() {
    return "DeserializedAst{"
         + "filesystem=" + filesystem + ", "
         + "colorRegistry=" + colorRegistry + ", "
         + "externProperties=" + externProperties
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TypedAstDeserializer.DeserializedAst) {
      TypedAstDeserializer.DeserializedAst that = (TypedAstDeserializer.DeserializedAst) o;
      return (this.filesystem.equals(that.getFilesystem()))
           && (this.colorRegistry.equals(that.getColorRegistry()))
           && ((this.externProperties == null) ? (that.getExternProperties() == null) : this.externProperties.equals(that.getExternProperties()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= filesystem.hashCode();
    h$ *= 1000003;
    h$ ^= colorRegistry.hashCode();
    h$ *= 1000003;
    h$ ^= (externProperties == null) ? 0 : externProperties.hashCode();
    return h$;
  }

}
