

package com.google.javascript.jscomp.modules;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.deps.ModuleLoader;
import javax.annotation.processing.Generated;
import org.jspecify.nullness.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_Module extends Module {

  private final ModuleMetadataMap.ModuleMetadata metadata;
  private final ModuleLoader.@Nullable ModulePath path;
  private final ImmutableMap<String, Binding> namespace;
  private final ImmutableMap<String, Binding> boundNames;
  private final ImmutableMap<String, Export> localNameToLocalExport;
  private final @Nullable String closureNamespace;

  private AutoValue_Module(
      ModuleMetadataMap.ModuleMetadata metadata,
       ModuleLoader.@Nullable ModulePath path,
      ImmutableMap<String, Binding> namespace,
      ImmutableMap<String, Binding> boundNames,
      ImmutableMap<String, Export> localNameToLocalExport,
       @Nullable String closureNamespace) {
    this.metadata = metadata;
    this.path = path;
    this.namespace = namespace;
    this.boundNames = boundNames;
    this.localNameToLocalExport = localNameToLocalExport;
    this.closureNamespace = closureNamespace;
  }

  @Override
  public ModuleMetadataMap.ModuleMetadata metadata() {
    return metadata;
  }

  @Override
  public ModuleLoader.@Nullable ModulePath path() {
    return path;
  }

  @Override
  public ImmutableMap<String, Binding> namespace() {
    return namespace;
  }

  @Override
  public ImmutableMap<String, Binding> boundNames() {
    return boundNames;
  }

  @Override
  public ImmutableMap<String, Export> localNameToLocalExport() {
    return localNameToLocalExport;
  }

  @Override
  public @Nullable String closureNamespace() {
    return closureNamespace;
  }

  @Override
  public String toString() {
    return "Module{"
         + "metadata=" + metadata + ", "
         + "path=" + path + ", "
         + "namespace=" + namespace + ", "
         + "boundNames=" + boundNames + ", "
         + "localNameToLocalExport=" + localNameToLocalExport + ", "
         + "closureNamespace=" + closureNamespace
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Module) {
      Module that = (Module) o;
      return (this.metadata.equals(that.metadata()))
           && ((this.path == null) ? (that.path() == null) : this.path.equals(that.path()))
           && (this.namespace.equals(that.namespace()))
           && (this.boundNames.equals(that.boundNames()))
           && (this.localNameToLocalExport.equals(that.localNameToLocalExport()))
           && ((this.closureNamespace == null) ? (that.closureNamespace() == null) : this.closureNamespace.equals(that.closureNamespace()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= (path == null) ? 0 : path.hashCode();
    h$ *= 1000003;
    h$ ^= namespace.hashCode();
    h$ *= 1000003;
    h$ ^= boundNames.hashCode();
    h$ *= 1000003;
    h$ ^= localNameToLocalExport.hashCode();
    h$ *= 1000003;
    h$ ^= (closureNamespace == null) ? 0 : closureNamespace.hashCode();
    return h$;
  }

  @Override
  public Module.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends Module.Builder {
    private ModuleMetadataMap.ModuleMetadata metadata;
    private ModuleLoader.@Nullable ModulePath path;
    private ImmutableMap<String, Binding> namespace;
    private ImmutableMap<String, Binding> boundNames;
    private ImmutableMap<String, Export> localNameToLocalExport;
    private @Nullable String closureNamespace;
    Builder() {
    }
    private Builder(Module source) {
      this.metadata = source.metadata();
      this.path = source.path();
      this.namespace = source.namespace();
      this.boundNames = source.boundNames();
      this.localNameToLocalExport = source.localNameToLocalExport();
      this.closureNamespace = source.closureNamespace();
    }
    @Override
    public Module.Builder metadata(ModuleMetadataMap.ModuleMetadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public Module.Builder path(ModuleLoader.@Nullable ModulePath path) {
      this.path = path;
      return this;
    }
    @Override
    public Module.Builder namespace(ImmutableMap<String, Binding> namespace) {
      if (namespace == null) {
        throw new NullPointerException("Null namespace");
      }
      this.namespace = namespace;
      return this;
    }
    @Override
    public Module.Builder boundNames(ImmutableMap<String, Binding> boundNames) {
      if (boundNames == null) {
        throw new NullPointerException("Null boundNames");
      }
      this.boundNames = boundNames;
      return this;
    }
    @Override
    public Module.Builder localNameToLocalExport(ImmutableMap<String, Export> localNameToLocalExport) {
      if (localNameToLocalExport == null) {
        throw new NullPointerException("Null localNameToLocalExport");
      }
      this.localNameToLocalExport = localNameToLocalExport;
      return this;
    }
    @Override
    public Module.Builder closureNamespace(@Nullable String closureNamespace) {
      this.closureNamespace = closureNamespace;
      return this;
    }
    @Override
    public Module build() {
      String missing = "";
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.namespace == null) {
        missing += " namespace";
      }
      if (this.boundNames == null) {
        missing += " boundNames";
      }
      if (this.localNameToLocalExport == null) {
        missing += " localNameToLocalExport";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Module(
          this.metadata,
          this.path,
          this.namespace,
          this.boundNames,
          this.localNameToLocalExport,
          this.closureNamespace);
    }
  }

}
