/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.reporting.AwsResourcesCreator;
import com.itextpdf.licensing.base.reporting.ILicenseServer;
import com.itextpdf.licensing.base.reporting.ProductLimitsRequest;
import com.itextpdf.licensing.base.reporting.ProductLimitsResponse;
import com.itextpdf.licensing.base.reporting.serverstatus.HealthCheckHolder;
import com.itextpdf.licensing.base.reporting.serverstatus.LicenseServerHealthStatus;
import com.itextpdf.licensing.base.reporting.volume.ProductUsage;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataAggregator;
import com.itextpdf.licensing.base.util.JsonUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayClient;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import com.itextpdf.licensing.remote.kinesis.KinesisDataSender;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;

final class AwsLicenseServer
implements ILicenseServer {
    private static final String AWS_API_LEFT_LIMITS_HOST = "sdk-requests.licensing.itextpdf.com";
    private static final String AWS_API_LEFT_LIMITS_PATH = "/v1/volume/limits-left";
    private static final String AWS_KINESIS_STREAM_NAME = "VolumeUsages";
    private static final int AWS_RECORD_MAX_SIZE = 0x100000;
    private static AwsLicenseServer instance;
    private final ApiGatewayClient leftLimitsRequestClient = AwsResourcesCreator.createApiGatewayClientWithAuth("sdk-requests.licensing.itextpdf.com", "/v1/volume/limits-left");
    private KinesisDataSender kinesisDataSender;

    private AwsLicenseServer() {
    }

    static AwsLicenseServer getInstance() {
        if (instance == null) {
            String healthCheckTime = VolumeDataAggregator.getCurrentTimeForSendUsage();
            instance = AwsLicenseServer.createInstanceWithHealthCheck(VolumeDataAggregator.createHealthCheckUsage(healthCheckTime));
        }
        return instance;
    }

    static void resetInstance() {
        instance = null;
    }

    @Override
    public boolean write(List<ProductUsage> usageList) {
        String usageArrayStr;
        if (this.kinesisDataSender == null) {
            this.kinesisDataSender = AwsResourcesCreator.createKinesisDataSender(0x100000, AWS_KINESIS_STREAM_NAME);
        }
        if ((usageArrayStr = JsonUtil.serializeToMinimalString(usageList)) != null) {
            byte[] recordBytes = usageArrayStr.getBytes(StandardCharsets.UTF_8);
            return this.kinesisDataSender.sendRecord(recordBytes);
        }
        return false;
    }

    @Override
    public List<ProductLimitsResponse> getRemainingEvents(List<ProductLimitsRequest> requestList) {
        String jsonRequestBody = JsonUtil.serializeToMinimalString(requestList);
        ApiGatewayResponse response = this.leftLimitsRequestClient.makePostRequest(jsonRequestBody);
        if (response.getStatus() != 200 || response.getBody() == null) {
            throw new LicenseKeyException("Exception during http request execution.");
        }
        return Arrays.asList((Object[])JsonUtil.deserializeFromString(response.getBody(), ProductLimitsResponse[].class));
    }

    @Override
    public LicenseServerHealthStatus healthCheck() {
        return HealthCheckHolder.getInstance().healthCheck();
    }

    static AwsLicenseServer createInstanceWithHealthCheck(List<ProductUsage> healthCheckUsage) {
        boolean isHealthy;
        AwsLicenseServer localInstance = new AwsLicenseServer();
        try {
            isHealthy = localInstance.write(healthCheckUsage);
        }
        catch (NoClassDefFoundError ex) {
            throw ex;
        }
        catch (Exception ignore) {
            isHealthy = false;
        }
        if (isHealthy || localInstance.healthCheck() == LicenseServerHealthStatus.UNHEALTHY_ON_SERVER_SIDE) {
            return localInstance;
        }
        throw new LicenseKeyException("Cannot send data to remote reporting server");
    }
}

