/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.serverstatus;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.reporting.serverstatus.LicenseServerHealthStatus;
import com.itextpdf.licensing.base.util.JsonUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayClient;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HealthCheckHolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckHolder.class);
    private static final int HEALTH_CHECK_REQUEST_TIMEOUT_MILLIS = 45000;
    private static final int SUCCESS_STATUS_CODE = 200;
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    private static final String AWS_API_HEALTH_CHECK_HOST = "sdk-health.licensing.itextpdf.com";
    private static final String AWS_API_HEALTH_CHECK_PATH = "/v1/health";
    private static final HealthCheckHolder INSTANCE = new HealthCheckHolder();
    private final Object healthCheckLock = new Object();
    private final ApiGatewayClient apiGatewayClient = new ApiGatewayClient("sdk-health.licensing.itextpdf.com", "/v1/health").setTimeoutMillis(45000);
    private final AtomicLong timeForNextCheck;
    private LicenseServerHealthStatus lastLicenseServerHealthStatus = LicenseServerHealthStatus.HEALTHY;

    private HealthCheckHolder() {
        this.timeForNextCheck = new AtomicLong(Long.MIN_VALUE);
    }

    public static HealthCheckHolder getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseServerHealthStatus healthCheck() {
        Object object = this.healthCheckLock;
        synchronized (object) {
            if (SystemUtil.getRelativeTimeMillis() > this.timeForNextCheck.get()) {
                try {
                    this.performHealthCheckRequest();
                }
                catch (Exception e) {
                    this.lastLicenseServerHealthStatus = LicenseServerHealthStatus.UNHEALTHY_ON_CLIENT_SIDE;
                    LOGGER.warn(MessageFormatUtil.format((String)"Exception with message \"{0}\" was thrown during the health check.", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
                }
            }
            return this.lastLicenseServerHealthStatus;
        }
    }

    private void performHealthCheckRequest() {
        ApiGatewayResponse response = this.apiGatewayClient.makePostRequest();
        if (response.getStatus() == 200) {
            HealthCheckResponse healthCheckResponse = JsonUtil.deserializeFromString(response.getBody(), HealthCheckResponse.class);
            this.timeForNextCheck.set(SystemUtil.getRelativeTimeMillis() + 1000L * healthCheckResponse.getCacheTimeoutSeconds());
            this.lastLicenseServerHealthStatus = healthCheckResponse.getSdkFlowHealthy() != false ? LicenseServerHealthStatus.HEALTHY : LicenseServerHealthStatus.UNHEALTHY_ON_SERVER_SIDE;
        } else {
            this.lastLicenseServerHealthStatus = LicenseServerHealthStatus.UNHEALTHY_ON_CLIENT_SIDE;
        }
    }

    private static final class HealthCheckResponse {
        @JsonProperty(value="sdkFlowHealthy")
        private final Boolean sdkFlowHealthy;
        @JsonProperty(value="cacheTimeoutSeconds")
        private final Long cacheTimeoutSeconds;

        public HealthCheckResponse(@JsonProperty(value="sdkFlowHealthy") Boolean sdkFlowHealthy, @JsonProperty(value="cacheTimeoutSeconds") Long cacheTimeoutSeconds) {
            this.sdkFlowHealthy = sdkFlowHealthy;
            this.cacheTimeoutSeconds = cacheTimeoutSeconds;
        }

        public Boolean getSdkFlowHealthy() {
            return this.sdkFlowHealthy;
        }

        public Long getCacheTimeoutSeconds() {
            return this.cacheTimeoutSeconds;
        }
    }
}

