/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.volume;

import com.itextpdf.licensing.base.reporting.volume.VolumeData;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataSignature;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class VolumeDataCacheComparatorBased {
    private final Map<VolumeDataSignature, VolumeData> map = new HashMap<VolumeDataSignature, VolumeData>();
    private final Set<VolumeData> orderedCache;

    public VolumeDataCacheComparatorBased(Comparator<VolumeData> comparator) {
        this.orderedCache = new TreeSet<VolumeData>(comparator);
    }

    public void put(VolumeData data) {
        if (data != null) {
            VolumeData old = this.map.put(data.getSignature(), data);
            if (old != null) {
                this.orderedCache.remove(old);
                data.mergeWith(old);
                this.orderedCache.add(data);
            } else {
                this.orderedCache.add(data);
            }
        }
    }

    public void putAll(List<VolumeData> dataList) {
        for (VolumeData data : dataList) {
            this.put(data);
        }
    }

    public VolumeData retrieveNext() {
        for (VolumeData data : this.orderedCache) {
            if (data == null) continue;
            this.map.remove(data.getSignature());
            this.orderedCache.remove(data);
            return data;
        }
        return null;
    }

    public List<VolumeData> retrieveAll() {
        VolumeData data;
        ArrayList<VolumeData> dataList = new ArrayList<VolumeData>();
        while ((data = this.retrieveNext()) != null) {
            dataList.add(data);
        }
        return dataList;
    }

    public List<VolumeData> clear() {
        ArrayList<VolumeData> result = new ArrayList<VolumeData>(this.map.values());
        this.map.clear();
        this.orderedCache.clear();
        return result;
    }
}

