/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.volume;

import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.reporting.ILicenseServer;
import com.itextpdf.licensing.base.reporting.resultprocessor.IVolumeResultProcessor;
import com.itextpdf.licensing.base.reporting.serverstatus.LicenseServerHealthStatus;
import com.itextpdf.licensing.base.reporting.volume.ProductUsage;
import com.itextpdf.licensing.base.reporting.volume.VolumeData;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataAggregator;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataCacheComparatorBased;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataFactory;
import com.itextpdf.licensing.base.reporting.volume.WaitTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;

public class VolumeEventDataHandler {
    private final Object processLock = new Object();
    private final Object factoryLock = new Object();
    private final Object cacheLock = new Object();
    private final VolumeDataCacheComparatorBased cache;
    private final VolumeDataFactory factory;
    private final AtomicLong lastProcessedTime = new AtomicLong();
    private final ILicenseServer licenseServer;
    private final IVolumeResultProcessor resultProcessor;
    private final WaitTime waitTime;

    public VolumeEventDataHandler(VolumeDataCacheComparatorBased cache, VolumeDataFactory factory, long initialWaitTimeMillis, long maxWaitTimeMillis, ILicenseServer licenseServer, IVolumeResultProcessor resultProcessor) {
        this.cache = cache;
        this.factory = factory;
        this.waitTime = new WaitTime(initialWaitTimeMillis, maxWaitTimeMillis);
        this.licenseServer = licenseServer;
        this.resultProcessor = resultProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(AbstractProductProcessITextEvent event) {
        VolumeData data;
        Object object = this.factoryLock;
        synchronized (object) {
            data = this.factory.create(event);
        }
        if (data != null) {
            object = this.cacheLock;
            synchronized (object) {
                this.cache.put(data);
            }
            this.tryProcessNextAsync();
        }
    }

    public void tryProcessNextAsync(Boolean daemon) {
        if (this.hasProcessingTimeCome()) {
            Thread thread = new Thread(() -> this.processNext(true));
            if (daemon != null) {
                thread.setDaemon(daemon);
            }
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryProcessRest() {
        List<VolumeData> unprocessedEvents = this.clear();
        if (!unprocessedEvents.isEmpty()) {
            try {
                Object object = this.processLock;
                synchronized (object) {
                    this.process(unprocessedEvents);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public WaitTime getWaitTime() {
        return this.waitTime;
    }

    public void checkEvent(String productName, String eventType) {
        try {
            this.resultProcessor.onEventProcessing(productName, eventType);
        }
        catch (LicenseKeyException e) {
            this.processNextUnscheduled();
            this.resultProcessor.onEventProcessing(productName, eventType);
        }
    }

    protected boolean process(List<VolumeData> data) {
        if (this.licenseServer != null) {
            List<ProductUsage> usageList = VolumeDataAggregator.aggregateVolumeEvents(data);
            return this.licenseServer.write(usageList);
        }
        return false;
    }

    protected void onSuccess(List<VolumeData> dataList) {
        this.waitTime.resetTime();
        if (this.resultProcessor != null) {
            for (VolumeData data : dataList) {
                this.resultProcessor.onSuccess(data.getProductName(), data.getEventType());
            }
        }
    }

    protected void onFailure(List<VolumeData> dataList) {
        this.waitTime.increaseWaitTime();
        if (this.resultProcessor != null) {
            for (VolumeData data : dataList) {
                this.resultProcessor.onFailure(data.getProductName(), data.getEventType());
            }
        }
    }

    protected boolean isFailExpected() {
        return this.licenseServer.healthCheck() == LicenseServerHealthStatus.UNHEALTHY_ON_SERVER_SIDE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<VolumeData> clear() {
        List<VolumeData> all;
        Object object = this.cacheLock;
        synchronized (object) {
            all = this.cache.clear();
        }
        this.lastProcessedTime.set(0L);
        this.waitTime.resetTime();
        return all != null ? all : Collections.emptyList();
    }

    private void processNextUnscheduled() {
        this.processNext(false);
    }

    private void tryProcessNextAsync() {
        this.tryProcessNextAsync(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNext(boolean scheduled) {
        List<VolumeData> dataList;
        if (scheduled && !this.hasProcessingTimeCome()) {
            return;
        }
        if (scheduled) {
            this.lastProcessedTime.set(SystemUtil.getRelativeTimeMillis());
        }
        Object object = this.cacheLock;
        synchronized (object) {
            dataList = this.cache.retrieveAll();
        }
        if (!dataList.isEmpty()) {
            boolean successful;
            Object object2 = this.processLock;
            synchronized (object2) {
                successful = this.tryProcess(dataList);
            }
            if (successful) {
                this.lastProcessedTime.set(SystemUtil.getRelativeTimeMillis());
                this.onSuccess(dataList);
            } else {
                object2 = this.cacheLock;
                synchronized (object2) {
                    this.cache.putAll(dataList);
                }
                if (this.isFailExpected()) {
                    this.lastProcessedTime.set(SystemUtil.getRelativeTimeMillis());
                    this.onSuccess(dataList);
                } else if (scheduled) {
                    this.onFailure(dataList);
                }
            }
        }
    }

    private boolean tryProcess(List<VolumeData> data) {
        try {
            return this.process(data);
        }
        catch (Exception any) {
            return false;
        }
    }

    private boolean hasProcessingTimeCome() {
        long currentTime = SystemUtil.getRelativeTimeMillis();
        return currentTime - this.lastProcessedTime.get() > this.waitTime.getTime();
    }
}

