/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.itextpdf.licensing.base.LicenseKeyProductData;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class VersionUtil {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+)\\.([\\d]+)\\.([\\d]+).*$");
    public static final int LICENSING_BASE_MAJOR;
    public static final int LICENSING_BASE_MINOR;
    public static final int LICENSING_BASE_PATCH;
    public static final int MAJOR_VERSION_POSITION = 0;
    public static final int MINOR_VERSION_POSITION = 1;
    public static final int PATCH_VERSION_POSITION = 2;

    private VersionUtil() {
    }

    public static List<Integer> parseModuleOrProductVersion(String versionToParse) {
        Matcher matcher = VERSION_PATTERN.matcher(versionToParse);
        if (!matcher.find()) {
            return null;
        }
        ArrayList<Integer> listWithVersion = new ArrayList<Integer>();
        listWithVersion.add(Integer.parseInt(matcher.group(1)));
        listWithVersion.add(Integer.parseInt(matcher.group(2)));
        listWithVersion.add(Integer.parseInt(matcher.group(3)));
        return listWithVersion;
    }

    public static boolean isVersionsIncompatible(int expectedMajor, int expectedMinor, int expectedPatch, int actualMajor, int actualMinor, int actualPatch) {
        if (expectedMajor > actualMajor) {
            return true;
        }
        if (expectedMajor < actualMajor) {
            return false;
        }
        if (expectedMinor > actualMinor) {
            return true;
        }
        if (expectedMinor < actualMinor) {
            return false;
        }
        return expectedPatch > actualPatch;
    }

    static {
        List<Integer> parsedLicensingBaseVersion = VersionUtil.parseModuleOrProductVersion(LicenseKeyProductData.getInstance().getVersion());
        LICENSING_BASE_MAJOR = parsedLicensingBaseVersion.get(0);
        LICENSING_BASE_MINOR = parsedLicensingBaseVersion.get(1);
        LICENSING_BASE_PATCH = parsedLicensingBaseVersion.get(2);
    }
}

