/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.actions;

import com.itextpdf.commons.utils.DateTimeUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.actions.ILicenseFileExpirationChecker;
import com.itextpdf.licensing.base.licensefile.OnExpirationStrategy;
import com.itextpdf.licensing.base.strategy.IStrategy;
import com.itextpdf.licensing.base.strategy.StrategyFactory;
import com.itextpdf.licensing.base.util.LicenseFileUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultLicenseFileExpirationChecker
implements ILicenseFileExpirationChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLicenseFileExpirationChecker.class);
    private static final int EXPIRATION_LOG_THRESHOLD = 30;
    private final Date expireDate;
    private final IStrategy onExpireStrategy;
    private final String productName;

    DefaultLicenseFileExpirationChecker(String productName, OnExpirationStrategy onExpirationStrategy, String expireDate, String gracePeriod) {
        try {
            this.productName = productName;
            if (gracePeriod != null && onExpirationStrategy == OnExpirationStrategy.grace) {
                long gracePeriodMillis = LicenseFileUtil.parseGracePeriodStrToMilliseconds(gracePeriod);
                this.expireDate = DateTimeUtil.addMillisToDate((Date)DateTimeUtil.parseWithDefaultPattern((String)expireDate), (long)gracePeriodMillis);
            } else {
                this.expireDate = DateTimeUtil.parseWithDefaultPattern((String)expireDate);
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(MessageFormatUtil.format((String)"Invalid expire date for license file which corresponds to \"{0}\" product.", (Object[])new Object[]{productName}));
        }
        this.onExpireStrategy = StrategyFactory.createLicenseFileExpirationStrategy(productName, onExpirationStrategy);
    }

    @Override
    public boolean isLicenseFileExpired() {
        return DateTimeUtil.isInPast((Date)DateTimeUtil.addDaysToDate((Date)this.expireDate, (int)1));
    }

    @Override
    public void checkExpiration() {
        if (this.isLicenseFileExpired()) {
            this.onExpireStrategy.onFailure();
        } else {
            this.onExpireStrategy.onSuccess();
            int daysBeforeExpiration = this.daysBeforeLicenseExpiration();
            if (daysBeforeExpiration < 30) {
                LOGGER.info(MessageFormatUtil.format((String)"A license which corresponds to \"{0}\" product expires in {1} days.", (Object[])new Object[]{this.productName, daysBeforeExpiration}));
            }
        }
        this.onExpireStrategy.onProcessing();
    }

    private int daysBeforeLicenseExpiration() {
        long timeDifference = DateTimeUtil.getRelativeTime((Date)this.expireDate) - DateTimeUtil.getRelativeTime((Date)DateTimeUtil.getCurrentTimeDate());
        return (int)(timeDifference / 86400000L);
    }
}

