/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.actions;

import com.itextpdf.commons.actions.processors.ITextProductEventProcessor;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.actions.LicenseITextProductEventProcessor;
import com.itextpdf.licensing.base.reporting.AbstractLicenseConfigurationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnloadLicenseEvent
extends AbstractLicenseConfigurationEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnloadLicenseEvent.class);
    private final String productName;

    public UnloadLicenseEvent(String productName) {
        this.productName = productName;
    }

    @Override
    protected void doSynchronizedAction() {
        ITextProductEventProcessor removedProcessor = this.removeProcessor(this.productName);
        this.getReportingHandler().updateReportingForProduct(this.productName);
        if (!(removedProcessor instanceof LicenseITextProductEventProcessor) && LOGGER.isWarnEnabled()) {
            LOGGER.warn(MessageFormatUtil.format((String)"There was a request to unload a license for the product \"{0}\". However license was not loaded for the product.", (Object[])new Object[]{this.productName}));
        }
    }
}

