/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting.volume;

import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.reporting.volume.VolumeData;
import com.itextpdf.licensing.base.reporting.volume.VolumeDataSignature;
import java.util.HashMap;
import java.util.Map;

public class VolumeDataFactory {
    private final CacheBuffer buffer = new CacheBuffer("", "", "");
    private final Map<CacheBuffer, VolumeDataSignature> cache = new HashMap<CacheBuffer, VolumeDataSignature>();

    public VolumeData create(AbstractProductProcessITextEvent event) {
        LicenseFile licenseFile = LicenseFileService.getLicenseFileForProduct(event.getProductName());
        String licenseFileKey = licenseFile == null ? null : licenseFile.getKey();
        VolumeDataSignature signature = this.createSignature(licenseFileKey, event);
        return new VolumeData(signature, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VolumeDataSignature createSignature(String licenseFileKey, AbstractProductProcessITextEvent event) {
        CacheBuffer cacheBuffer = this.buffer;
        synchronized (cacheBuffer) {
            this.buffer.licenseFileKey = VolumeDataFactory.ensureNotNull(licenseFileKey);
            this.buffer.productName = VolumeDataFactory.ensureNotNull(event.getProductName());
            this.buffer.eventType = VolumeDataFactory.ensureNotNull(event.getEventType());
            VolumeDataSignature result = this.cache.get(this.buffer);
            if (result == null) {
                result = new VolumeDataSignature(this.buffer.licenseFileKey, this.buffer.productName, this.buffer.eventType);
                this.cache.put(new CacheBuffer(this.buffer), result);
            }
            return result;
        }
    }

    private static String ensureNotNull(String toCheck) {
        return toCheck == null ? "" : toCheck;
    }

    private static class CacheBuffer {
        String licenseFileKey;
        String productName;
        String eventType;

        CacheBuffer(String licenseFileKey, String productName, String eventType) {
            this.licenseFileKey = licenseFileKey;
            this.productName = productName;
            this.eventType = eventType;
        }

        CacheBuffer(CacheBuffer other) {
            this(other.licenseFileKey, other.productName, other.eventType);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && this.getClass() == obj.getClass()) {
                CacheBuffer buff = (CacheBuffer)obj;
                return this.licenseFileKey.equals(buff.licenseFileKey) && this.productName.equals(buff.productName) && this.eventType.equals(buff.eventType);
            }
            return false;
        }

        public int hashCode() {
            int hashCode = this.licenseFileKey.hashCode();
            hashCode = 31 * hashCode + this.productName.hashCode();
            return 31 * hashCode + this.eventType.hashCode();
        }
    }
}

